/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import java.util.List;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;

public class MeshProperties {
    public static double compute(List p, Point3d cm, double[][] inertia) {
        int tmax = p.size() / 3;
        double[] mult = new double[]{0.16666666666666666, 0.041666666666666664, 0.041666666666666664, 0.041666666666666664, 0.016666666666666666, 0.016666666666666666, 0.016666666666666666, 0.008333333333333333, 0.008333333333333333, 0.008333333333333333};
        double[] intg = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] fg = new double[6];
        for (int t = 0; t < tmax; ++t) {
            int i0 = 3 * t;
            int i1 = 3 * t + 1;
            int i2 = 3 * t + 2;
            double x0 = ((Point3f)p.get((int)i0)).x;
            double y0 = ((Point3f)p.get((int)i0)).y;
            double z0 = ((Point3f)p.get((int)i0)).z;
            double x1 = ((Point3f)p.get((int)i1)).x;
            double y1 = ((Point3f)p.get((int)i1)).y;
            double z1 = ((Point3f)p.get((int)i1)).z;
            double x2 = ((Point3f)p.get((int)i2)).x;
            double y2 = ((Point3f)p.get((int)i2)).y;
            double z2 = ((Point3f)p.get((int)i2)).z;
            double a1 = x1 - x0;
            double b1 = y1 - y0;
            double c1 = z1 - z0;
            double a2 = x2 - x0;
            double b2 = y2 - y0;
            double c2 = z2 - z0;
            double d0 = b1 * c2 - b2 * c1;
            double d1 = a2 * c1 - a1 * c2;
            double d2 = a1 * b2 - a2 * b1;
            MeshProperties.subexpr(x0, x1, x2, fg);
            double f1x = fg[0];
            double f2x = fg[1];
            double f3x = fg[2];
            double g0x = fg[3];
            double g1x = fg[4];
            double g2x = fg[5];
            MeshProperties.subexpr(y0, y1, y2, fg);
            double f1y = fg[0];
            double f2y = fg[1];
            double f3y = fg[2];
            double g0y = fg[3];
            double g1y = fg[4];
            double g2y = fg[5];
            MeshProperties.subexpr(z0, z1, z2, fg);
            double f1z = fg[0];
            double f2z = fg[1];
            double f3z = fg[2];
            double g0z = fg[3];
            double g1z = fg[4];
            double g2z = fg[5];
            intg[0] = intg[0] + d0 * f1x;
            intg[1] = intg[1] + d0 * f2x;
            intg[2] = intg[2] + d1 * f2y;
            intg[3] = intg[3] + d2 * f2z;
            intg[4] = intg[4] + d0 * f3x;
            intg[5] = intg[5] + d1 * f3y;
            intg[6] = intg[6] + d2 * f3z;
            intg[7] = intg[7] + d0 * (y0 * g0x + y1 * g1x + y2 * g2x);
            intg[8] = intg[8] + d1 * (z0 * g0y + z1 * g1y + z2 * g2y);
            intg[9] = intg[9] + d2 * (x0 * g0z + x1 * g1z + x2 * g2z);
        }
        for (int i = 0; i < 10; ++i) {
            int n = i;
            intg[n] = intg[n] * mult[i];
        }
        double mass = intg[0];
        cm.x = (float)(intg[1] / mass);
        cm.y = (float)(intg[2] / mass);
        cm.z = (float)(intg[3] / mass);
        inertia[0][0] = intg[5] + intg[6] - mass * (cm.y * cm.y + cm.z * cm.z);
        inertia[1][1] = intg[4] + intg[6] - mass * (cm.z * cm.z + cm.x * cm.x);
        inertia[2][2] = intg[4] + intg[5] - mass * (cm.x * cm.x + cm.y * cm.y);
        inertia[0][1] = -(intg[7] - mass * cm.x * cm.y);
        inertia[1][2] = -(intg[8] - mass * cm.y * cm.z);
        inertia[0][2] = -(intg[9] - mass * cm.z * cm.x);
        return mass;
    }

    static void subexpr(double w0, double w1, double w2, double[] fg) {
        double temp0 = w0 + w1;
        fg[0] = temp0 + w2;
        double temp1 = w0 * w0;
        double temp2 = temp1 + w1 * temp0;
        fg[1] = temp2 + w2 * fg[0];
        fg[2] = w0 * temp1 + w1 * temp2 + w2 * fg[1];
        fg[3] = fg[1] + w0 * (fg[0] + w0);
        fg[4] = fg[1] + w1 * (fg[0] + w1);
        fg[5] = fg[1] + w2 * (fg[0] + w2);
    }

    public static void calculateMinMaxPoint(List mesh, Point3d min, Point3d max) {
        if (mesh == null) {
            return;
        }
        min.z = Double.MAX_VALUE;
        min.y = Double.MAX_VALUE;
        min.x = Double.MAX_VALUE;
        max.z = -1.7976931348623157E308;
        max.y = -1.7976931348623157E308;
        max.x = -1.7976931348623157E308;
        for (int i = 0; i < mesh.size(); ++i) {
            Point3f p = (Point3f)mesh.get(i);
            if ((double)p.x < min.x) {
                min.x = p.x;
            }
            if ((double)p.y < min.y) {
                min.y = p.y;
            }
            if ((double)p.z < min.z) {
                min.z = p.z;
            }
            if ((double)p.x > max.x) {
                max.x = p.x;
            }
            if ((double)p.y > max.y) {
                max.y = p.y;
            }
            if (!((double)p.z > max.z)) continue;
            max.z = p.z;
        }
    }
}

