/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector;

import java.util.stream.Collectors;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import org.scijava.Context;
import org.scijava.Initializable;
import org.scijava.convert.ConvertService;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.UIService;
import sc.fiji.filamentdetector.Calibrations;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.detection.FilteringParameters;
import sc.fiji.filamentdetector.event.ImageNotFoundEvent;
import sc.fiji.filamentdetector.model.Filaments;
import sc.fiji.filamentdetector.model.TrackedFilaments;
import sc.fiji.filamentdetector.tracking.FilamentsTracker;
import sc.fiji.filamentdetector.tracking.FilteringTrackedFilamentsParameters;

public class FilamentWorkflow
implements Initializable {
    @Parameter
    private Context context;
    @Parameter
    private ConvertService convert;
    @Parameter
    private LogService log;
    @Parameter
    private UIService ui;
    @Parameter
    private EventService eventService;
    private final ImageDisplay sourceImage;
    private ImageDisplay imageDisplay;
    private Calibrations calibrations;
    private FilamentDetector filamentsDetector;
    private FilamentsTracker filamentsTracker;
    private Filaments filaments;
    private Filaments filteredFilaments;
    private TrackedFilaments trackedFilaments;
    private TrackedFilaments filteredTrackedFilaments;

    public FilamentWorkflow(Context context, ImageDisplay imd) {
        context.inject((Object)this);
        this.imageDisplay = imd;
        this.sourceImage = imd;
        this.filteredFilaments = this.filaments = new Filaments();
        this.filteredTrackedFilaments = this.trackedFilaments = new TrackedFilaments(context);
    }

    public void initialize() {
        this.calibrations = new Calibrations(this.context, this.getDataset());
    }

    public void setFilamentDetector(FilamentDetector filamentDetector) {
        this.filamentsDetector = filamentDetector;
    }

    public void setFilamentsTracker(FilamentsTracker filamentsTracker) {
        this.filamentsTracker = filamentsTracker;
    }

    private void initDetection() {
        this.filamentsDetector.setDataset(this.getDataset());
        this.filamentsDetector.setImageDisplay(this.imageDisplay);
    }

    public void detectCurrentFrame() {
        this.initDetection();
        this.filamentsDetector.detectCurrentFrame(this.calibrations.getChannelToUseIndex());
        this.filteredFilaments = this.filaments = this.filamentsDetector.getFilaments();
    }

    public void detect() {
        this.initDetection();
        this.filamentsDetector.detect(this.calibrations.getChannelToUseIndex());
        this.filteredFilaments = this.filaments = this.filamentsDetector.getFilaments();
    }

    public void track() {
        this.filamentsTracker.setFilaments(this.getFilaments());
        this.filamentsTracker.track();
        this.filteredTrackedFilaments = this.trackedFilaments = this.filamentsTracker.getTrackedFilaments();
    }

    public Dataset getDataset() {
        try {
            Dataset dataset = (Dataset)this.imageDisplay.getActiveView().getData();
            return dataset;
        }
        catch (NullPointerException e) {
            this.eventService.publish((SciJavaEvent)new ImageNotFoundEvent());
            return null;
        }
    }

    public void setImageDisplay(ImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }

    public ImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    public ImageDisplay getSourceImage() {
        return this.sourceImage;
    }

    public Calibrations getCalibrations() {
        return this.calibrations;
    }

    public FilamentDetector getFilamentDetector() {
        return this.filamentsDetector;
    }

    public FilamentsTracker getFilamentsTracker() {
        return this.filamentsTracker;
    }

    public Filaments getFilaments() {
        return this.filteredFilaments;
    }

    public TrackedFilaments getTrackedFilaments() {
        return this.filteredTrackedFilaments;
    }

    public void filterFilament(FilteringParameters filteringParameters) {
        this.filteredFilaments = !filteringParameters.isDisableFiltering() ? this.filaments.stream().filter(filament -> filament.getLength() <= filteringParameters.getMaxLength()).filter(filament -> filament.getLength() >= filteringParameters.getMinLength()).filter(filament -> filament.getSinuosity() <= filteringParameters.getMaxSinuosity()).filter(filament -> filament.getSinuosity() >= filteringParameters.getMinSinuosity()).collect(Collectors.toCollection(Filaments::new)) : this.filaments;
    }

    public void filterTrackedFilament(FilteringTrackedFilamentsParameters filteringParameters) {
        if (!filteringParameters.isDisableFiltering()) {
            double[] bbox = new double[]{0.0, this.getCalibrations().getSizeX(), 0.0, this.getCalibrations().getSizeY()};
            bbox[0] = bbox[0] + filteringParameters.getBorderLimit();
            bbox[1] = bbox[1] - filteringParameters.getBorderLimit();
            bbox[2] = bbox[2] + filteringParameters.getBorderLimit();
            bbox[3] = bbox[3] - filteringParameters.getBorderLimit();
            this.filteredTrackedFilaments = this.trackedFilaments.stream().filter(trackedFilament -> (double)trackedFilament.size() <= filteringParameters.getMaxSize()).filter(trackedFilament -> (double)trackedFilament.size() >= filteringParameters.getMinSize()).filter(trackedFilament -> trackedFilament.insideBbox(bbox)).collect(Collectors.toCollection(() -> new TrackedFilaments(this.context)));
        } else {
            this.filteredTrackedFilaments = this.trackedFilaments;
        }
    }

    public Context getContext() {
        return this.context;
    }
}

