/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.Metadata;
import io.scif.formats.TIFFFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.translators.FromOMETranslator;
import io.scif.ome.translators.ToOMETranslator;
import io.scif.util.FormatTools;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;
import org.scijava.plugin.Plugin;

public class TIFFTranslator {
    public static final double PRIORITY = 100.0;

    @Plugin(type=FromOMETranslator.class, priority=100.0)
    public static class OMETIFFTranslator
    extends FromOMETranslator<TIFFFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return OMEMetadata.class;
        }

        public Class<? extends Metadata> dest() {
            return TIFFFormat.Metadata.class;
        }

        protected void translateFormatMetadata(OMEMetadata source, TIFFFormat.Metadata dest) {
            OMEXMLMetadata meta = source.getRoot();
            if (meta.getPixelsBinDataCount(0) > 0) {
                FormatTools.calibrate((CalibratedAxis)dest.get(0).getAxis(Axes.X), (double)this.checkValue(meta.getPixelsPhysicalSizeX(0)), (double)0.0);
                FormatTools.calibrate((CalibratedAxis)dest.get(0).getAxis(Axes.Y), (double)this.checkValue(meta.getPixelsPhysicalSizeY(0)), (double)0.0);
                FormatTools.calibrate((CalibratedAxis)dest.get(0).getAxis(Axes.Z), (double)this.checkValue(meta.getPixelsPhysicalSizeZ(0)), (double)0.0);
            }
            if (meta.getImageCount() > 0) {
                dest.setImageDescription(meta.getImageDescription(0));
            }
            if (meta.getExperimentCount() > 0) {
                dest.setExperimenterEmail(meta.getExperimenterEmail(0));
                dest.setExperimenterFirstName(meta.getExperimenterFirstName(0));
                dest.setExperimenterLastName(meta.getExperimenterLastName(0));
                dest.setCreationDate((String)meta.getImageAcquisitionDate(0).getValue());
            }
        }

        private double checkValue(Length l) {
            return l == null ? 1.0 : l.value().doubleValue();
        }
    }

    @Plugin(type=ToOMETranslator.class, priority=100.0)
    public static class TIFFOMETranslator
    extends ToOMETranslator<TIFFFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return TIFFFormat.Metadata.class;
        }

        public Class<? extends Metadata> dest() {
            return OMEMetadata.class;
        }

        protected void translateFormatMetadata(TIFFFormat.Metadata source, OMEMetadata dest) {
            OMEXMLMetadata meta = dest.getRoot();
            CalibratedAxis xAxis = source.get(0).getAxis(Axes.X);
            CalibratedAxis yAxis = source.get(0).getAxis(Axes.Y);
            CalibratedAxis zAxis = source.get(0).getAxis(Axes.Z);
            double physX = xAxis == null ? 1.0 : xAxis.averageScale(0.0, 1.0);
            double physY = yAxis == null ? 1.0 : yAxis.averageScale(0.0, 1.0);
            double physZ = zAxis == null ? 1.0 : zAxis.averageScale(0.0, 1.0);
            meta.setPixelsPhysicalSizeX(new Length((Number)(physX > 0.0 ? physX : 1.0), UNITS.MICROMETER), 0);
            meta.setPixelsPhysicalSizeY(new Length((Number)(physY > 0.0 ? physY : 1.0), UNITS.MICROMETER), 0);
            meta.setPixelsPhysicalSizeZ(new Length((Number)(physZ > 0.0 ? physZ : 1.0), UNITS.MICROMETER), 0);
            meta.setImageDescription(source.getDescription(), 0);
            meta.setExperimenterFirstName(source.getExperimenterFirstName(), 0);
            meta.setExperimenterLastName(source.getExperimenterLastName(), 0);
            meta.setExperimenterEmail(source.getExperimenterEmail(), 0);
            String creationDate = source.getCreationDate();
            if (creationDate != null) {
                meta.setImageAcquisitionDate(new Timestamp(creationDate), 0);
            }
        }
    }
}

