/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.graph.Function1;
import fiji.plugin.trackmate.graph.SortedDepthFirstIterator;
import fiji.plugin.trackmate.graph.TimeDirectedDepthFirstIterator;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import fiji.plugin.trackmate.graph.TimeDirectedSortedDepthFirstIterator;
import fiji.plugin.trackmate.util.AlphanumComparator;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jgrapht.Graph;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.graph.AsUnweightedGraph;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.GraphIterator;

public class TrackModel {
    DefaultListenableGraph<Spot, DefaultWeightedEdge> graph;
    private final MyGraphListener mgl;
    final Set<DefaultWeightedEdge> edgesAdded = new HashSet<DefaultWeightedEdge>();
    final Set<DefaultWeightedEdge> edgesRemoved = new HashSet<DefaultWeightedEdge>();
    final Set<DefaultWeightedEdge> edgesModified = new HashSet<DefaultWeightedEdge>();
    final Set<Integer> tracksUpdated = new HashSet<Integer>();
    private static final Boolean DEFAULT_VISIBILITY = Boolean.TRUE;
    private int IDcounter = 0;
    Map<Integer, Set<DefaultWeightedEdge>> connectedEdgeSets;
    Map<DefaultWeightedEdge, Integer> edgeToID;
    Map<Integer, Set<Spot>> connectedVertexSets;
    Map<Spot, Integer> vertexToID;
    Map<Integer, Boolean> visibility;
    Map<Integer, String> names;
    private final Iterator<String> nameGenerator = new DefaultNameGenerator();

    TrackModel() {
        this((SimpleWeightedGraph<Spot, DefaultWeightedEdge>)new SimpleWeightedGraph(DefaultWeightedEdge.class));
    }

    private TrackModel(SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph) {
        this.mgl = new MyGraphListener();
        this.setGraph(graph);
    }

    void setGraph(SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph) {
        if (null != this.graph) {
            this.graph.removeGraphListener((GraphListener)this.mgl);
        }
        this.graph = new DefaultListenableGraph(graph);
        this.graph.addGraphListener((GraphListener)this.mgl);
        this.init((Graph<Spot, DefaultWeightedEdge>)graph);
    }

    void clear() {
        this.setGraph((SimpleWeightedGraph<Spot, DefaultWeightedEdge>)new SimpleWeightedGraph(DefaultWeightedEdge.class));
    }

    public void from(SimpleWeightedGraph<Spot, DefaultWeightedEdge> lGraph, Map<Integer, Set<Spot>> trackSpots, Map<Integer, Set<DefaultWeightedEdge>> trackEdges, Map<Integer, Boolean> trackVisibility, Map<Integer, String> trackNames) {
        if (null != this.graph) {
            this.graph.removeGraphListener((GraphListener)this.mgl);
        }
        this.graph = new DefaultListenableGraph(lGraph);
        this.graph.addGraphListener((GraphListener)this.mgl);
        this.edgesAdded.clear();
        this.edgesModified.clear();
        this.edgesRemoved.clear();
        this.tracksUpdated.clear();
        this.visibility = trackVisibility;
        this.names = trackNames;
        this.connectedVertexSets = trackSpots;
        this.connectedEdgeSets = trackEdges;
        this.IDcounter = 0;
        this.vertexToID = new HashMap<Spot, Integer>();
        int nameIDCounter = -1;
        int prefixLength = "Track_".length();
        Pattern namePattern = Pattern.compile("^Track_[0-9]+$");
        for (Integer id : trackSpots.keySet()) {
            int nameID;
            for (Spot spot : trackSpots.get(id)) {
                this.vertexToID.put(spot, id);
            }
            if (id > this.IDcounter) {
                this.IDcounter = id;
            }
            if (!namePattern.matcher(this.name(id)).matches() || (nameID = Integer.parseInt(this.name(id).substring(prefixLength))) <= nameIDCounter) continue;
            nameIDCounter = nameID;
        }
        ++this.IDcounter;
        ((DefaultNameGenerator)this.nameGenerator).setNameID(++nameIDCounter);
        this.edgeToID = new HashMap<DefaultWeightedEdge, Integer>();
        for (Integer id : trackEdges.keySet()) {
            for (DefaultWeightedEdge edge : trackEdges.get(id)) {
                this.edgeToID.put(edge, id);
            }
        }
    }

    void addSpot(Spot spotToAdd) {
        this.graph.addVertex((Object)spotToAdd);
    }

    void removeSpot(Spot spotToRemove) {
        this.graph.removeVertex((Object)spotToRemove);
    }

    DefaultWeightedEdge addEdge(Spot source, Spot target, double weight) {
        DefaultWeightedEdge edge;
        if (!this.graph.containsVertex((Object)source)) {
            this.graph.addVertex((Object)source);
        }
        if (!this.graph.containsVertex((Object)target)) {
            this.graph.addVertex((Object)target);
        }
        if ((edge = (DefaultWeightedEdge)this.graph.addEdge((Object)source, (Object)target)) != null) {
            this.graph.setEdgeWeight((Object)edge, weight);
        }
        return edge;
    }

    DefaultWeightedEdge removeEdge(Spot source, Spot target) {
        return (DefaultWeightedEdge)this.graph.removeEdge((Object)source, (Object)target);
    }

    boolean removeEdge(DefaultWeightedEdge edge) {
        return this.graph.removeEdge((Object)edge);
    }

    void setEdgeWeight(DefaultWeightedEdge edge, double weight) {
        this.graph.setEdgeWeight((Object)edge, weight);
        this.edgesModified.add(edge);
    }

    Boolean setVisibility(Integer trackID, boolean visible) {
        return this.visibility.put(trackID, visible);
    }

    public <V> SimpleDirectedWeightedGraph<V, DefaultWeightedEdge> copy(Supplier<V> factory, Function1<Spot, V> function, Map<Spot, V> mappings) {
        SimpleDirectedWeightedGraph copy = new SimpleDirectedWeightedGraph(DefaultWeightedEdge.class);
        Set spots = this.graph.vertexSet();
        Map<Spot, V> map = null == mappings ? new HashMap<Spot, V>(spots.size()) : mappings;
        for (Spot spot : Collections.unmodifiableCollection(spots)) {
            V vertex = factory.get();
            function.compute(spot, vertex);
            map.put(spot, vertex);
            copy.addVertex(vertex);
        }
        for (DefaultWeightedEdge edge : this.graph.edgeSet()) {
            DefaultWeightedEdge newEdge = (DefaultWeightedEdge)copy.addEdge(map.get(this.graph.getEdgeSource((Object)edge)), map.get(this.graph.getEdgeTarget((Object)edge)));
            copy.setEdgeWeight((Object)newEdge, this.graph.getEdgeWeight((Object)edge));
        }
        return copy;
    }

    public boolean containsEdge(Spot source, Spot target) {
        return this.graph.containsEdge((Object)source, (Object)target);
    }

    public DefaultWeightedEdge getEdge(Spot source, Spot target) {
        return (DefaultWeightedEdge)this.graph.getEdge((Object)source, (Object)target);
    }

    public Set<DefaultWeightedEdge> edgesOf(Spot spot) {
        if (this.graph.containsVertex((Object)spot)) {
            return this.graph.edgesOf((Object)spot);
        }
        return Collections.emptySet();
    }

    public Set<DefaultWeightedEdge> edgeSet() {
        return this.graph.edgeSet();
    }

    public Set<Spot> vertexSet() {
        return this.graph.vertexSet();
    }

    public Spot getEdgeSource(DefaultWeightedEdge e) {
        return (Spot)this.graph.getEdgeSource((Object)e);
    }

    public Spot getEdgeTarget(DefaultWeightedEdge e) {
        return (Spot)this.graph.getEdgeTarget((Object)e);
    }

    public double getEdgeWeight(DefaultWeightedEdge edge) {
        return this.graph.getEdgeWeight((Object)edge);
    }

    public boolean isVisible(Integer ID) {
        return this.visibility.get(ID);
    }

    public Set<Integer> trackIDs(boolean visibleOnly) {
        Set<Integer> ids = TMUtils.sortByValue(this.names, AlphanumComparator.instance).keySet();
        if (!visibleOnly) {
            return ids;
        }
        LinkedHashSet<Integer> vids = new LinkedHashSet<Integer>(ids.size());
        for (Integer id : ids) {
            if (!this.visibility.get(id).booleanValue()) continue;
            vids.add(id);
        }
        return vids;
    }

    public Set<Integer> unsortedTrackIDs(boolean visibleOnly) {
        if (!visibleOnly) {
            return this.visibility.keySet();
        }
        LinkedHashSet<Integer> vids = new LinkedHashSet<Integer>(this.visibility.size());
        for (Integer id : this.visibility.keySet()) {
            if (!this.visibility.get(id).booleanValue()) continue;
            vids.add(id);
        }
        return vids;
    }

    public String name(Integer id) {
        return this.names.get(id);
    }

    public void setName(Integer id, String name) {
        this.names.put(id, name);
    }

    public Set<DefaultWeightedEdge> trackEdges(Integer trackID) {
        return this.connectedEdgeSets.get(trackID);
    }

    public Set<Spot> trackSpots(Integer trackID) {
        return this.connectedVertexSets.get(trackID);
    }

    public int nTracks(boolean visibleOnly) {
        if (!visibleOnly) {
            return this.connectedEdgeSets.size();
        }
        int ntracks = 0;
        for (Boolean visible : this.visibility.values()) {
            if (!visible.booleanValue()) continue;
            ++ntracks;
        }
        return ntracks;
    }

    public Integer trackIDOf(DefaultWeightedEdge edge) {
        return this.edgeToID.get(edge);
    }

    public Integer trackIDOf(Spot spot) {
        return this.vertexToID.get(spot);
    }

    private void init(Graph<Spot, DefaultWeightedEdge> lGraph) {
        this.vertexToID = new HashMap<Spot, Integer>();
        this.edgeToID = new HashMap<DefaultWeightedEdge, Integer>();
        this.IDcounter = 0;
        this.visibility = new HashMap<Integer, Boolean>();
        this.names = new HashMap<Integer, String>();
        this.connectedVertexSets = new HashMap<Integer, Set<Spot>>();
        this.connectedEdgeSets = new HashMap<Integer, Set<DefaultWeightedEdge>>();
        this.edgesAdded.clear();
        this.edgesModified.clear();
        this.edgesRemoved.clear();
        this.tracksUpdated.clear();
        Set vertexSet = lGraph.vertexSet();
        if (vertexSet.size() > 0) {
            BreadthFirstIterator i = new BreadthFirstIterator(lGraph);
            i.addTraversalListener((TraversalListener)new MyTraversalListener());
            while (i.hasNext()) {
                i.next();
            }
        }
    }

    public String echo() {
        if (null == this.connectedVertexSets) {
            return "Uninitialized.\n";
        }
        StringBuilder str = new StringBuilder();
        Set<Integer> vid = this.connectedVertexSets.keySet();
        HashSet<Integer> eid = new HashSet<Integer>(this.connectedEdgeSets.keySet());
        for (Integer id : vid) {
            str.append(id + ":\n");
            str.append(" - " + String.valueOf(this.connectedVertexSets.get(id)) + "\n");
            Set<DefaultWeightedEdge> es = this.connectedEdgeSets.get(id);
            if (es == null) {
                str.append(" - no matching edges!\n");
            } else {
                str.append(" - " + String.valueOf(es) + "\n");
            }
            eid.remove(id);
        }
        if (eid.isEmpty()) {
            str.append("No remaining edges ID.\n");
        } else {
            str.append("Found non-matching edge IDs!\n");
            for (Integer id : eid) {
                str.append(id + ":\n");
                str.append(" - " + String.valueOf(this.connectedEdgeSets.get(id)) + "\n");
            }
        }
        return str.toString();
    }

    public GraphIterator<Spot, DefaultWeightedEdge> getDepthFirstIterator(Spot start, boolean directed) {
        if (directed) {
            return new TimeDirectedDepthFirstIterator((Graph<Spot, DefaultWeightedEdge>)this.graph, start);
        }
        return new DepthFirstIterator(this.graph, (Object)start);
    }

    public SortedDepthFirstIterator<Spot, DefaultWeightedEdge> getSortedDepthFirstIterator(Spot start, Comparator<Spot> comparator, boolean directed) {
        if (directed) {
            return new TimeDirectedSortedDepthFirstIterator((Graph<Spot, DefaultWeightedEdge>)this.graph, start, comparator);
        }
        return new SortedDepthFirstIterator<Spot, DefaultWeightedEdge>((Graph<Spot, DefaultWeightedEdge>)this.graph, start, comparator);
    }

    public TimeDirectedNeighborIndex getDirectedNeighborIndex() {
        TimeDirectedNeighborIndex index = new TimeDirectedNeighborIndex((Graph<Spot, DefaultWeightedEdge>)this.graph);
        this.graph.addGraphListener((GraphListener)index);
        return index;
    }

    public List<DefaultWeightedEdge> dijkstraShortestPath(Spot source, Spot target) {
        if (null == this.graph) {
            return null;
        }
        AsUnweightedGraph unWeightedGrah = new AsUnweightedGraph(this.graph);
        DijkstraShortestPath pathFinder = new DijkstraShortestPath((Graph)unWeightedGrah);
        List path = pathFinder.getPath((Object)source, (Object)target).getEdgeList();
        return path;
    }

    private static class DefaultNameGenerator
    implements Iterator<String> {
        private static final String DEFAULT_NAME_PREFIX = "Track_";
        private int nameID = 0;

        private DefaultNameGenerator() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            return DEFAULT_NAME_PREFIX + this.nameID++;
        }

        @Override
        public void remove() {
        }

        public void setNameID(int nameID) {
            this.nameID = nameID;
        }
    }

    private class MyGraphListener
    implements GraphListener<Spot, DefaultWeightedEdge> {
        private MyGraphListener() {
        }

        public void vertexAdded(GraphVertexChangeEvent<Spot> event) {
        }

        public void vertexRemoved(GraphVertexChangeEvent<Spot> event) {
            if (null == TrackModel.this.connectedEdgeSets) {
                return;
            }
            Spot v = (Spot)event.getVertex();
            TrackModel.this.vertexToID.remove(v);
            Integer id = TrackModel.this.vertexToID.get(v);
            if (id != null) {
                Set<Spot> set = TrackModel.this.connectedVertexSets.get(id);
                if (null == set) {
                    return;
                }
                set.remove(v);
                if (set.isEmpty()) {
                    TrackModel.this.connectedEdgeSets.remove(id);
                    TrackModel.this.connectedVertexSets.remove(id);
                    TrackModel.this.names.remove(id);
                    TrackModel.this.visibility.remove(id);
                }
            }
        }

        public void edgeAdded(GraphEdgeChangeEvent<Spot, DefaultWeightedEdge> event) {
            TrackModel.this.edgesAdded.add((DefaultWeightedEdge)event.getEdge());
            DefaultWeightedEdge e = (DefaultWeightedEdge)event.getEdge();
            Spot sv = (Spot)TrackModel.this.graph.getEdgeSource((Object)e);
            Integer sid = TrackModel.this.vertexToID.get(sv);
            Spot tv = (Spot)TrackModel.this.graph.getEdgeTarget((Object)e);
            Integer tid = TrackModel.this.vertexToID.get(tv);
            if (null != tid && null != sid) {
                if (tid.equals(sid)) {
                    Set<DefaultWeightedEdge> ses = TrackModel.this.connectedEdgeSets.get(sid);
                    ses.add(e);
                    TrackModel.this.edgeToID.put(e, sid);
                } else {
                    Integer rid;
                    Integer nid;
                    Set<DefaultWeightedEdge> ses = TrackModel.this.connectedEdgeSets.get(sid);
                    Set<DefaultWeightedEdge> tes = TrackModel.this.connectedEdgeSets.get(tid);
                    HashSet<DefaultWeightedEdge> nes = new HashSet<DefaultWeightedEdge>(ses.size() + tes.size() + 1);
                    nes.addAll(ses);
                    nes.addAll(tes);
                    nes.add(e);
                    Set<Spot> svs = TrackModel.this.connectedVertexSets.get(sid);
                    Set<Spot> tvs = TrackModel.this.connectedVertexSets.get(tid);
                    HashSet<Spot> nvs = new HashSet<Spot>(ses.size() + tes.size());
                    nvs.addAll(svs);
                    nvs.addAll(tvs);
                    if (nvs.size() > tvs.size()) {
                        nid = sid;
                        rid = tid;
                        for (Spot v : tvs) {
                            TrackModel.this.vertexToID.put(v, nid);
                        }
                        for (DefaultWeightedEdge te : tes) {
                            TrackModel.this.edgeToID.put(te, nid);
                        }
                    } else {
                        nid = tid;
                        rid = sid;
                        for (Spot v : svs) {
                            TrackModel.this.vertexToID.put(v, nid);
                        }
                        for (DefaultWeightedEdge se : ses) {
                            TrackModel.this.edgeToID.put(se, nid);
                        }
                    }
                    TrackModel.this.edgeToID.put(e, nid);
                    TrackModel.this.connectedVertexSets.put(nid, nvs);
                    TrackModel.this.connectedVertexSets.remove(rid);
                    TrackModel.this.connectedEdgeSets.put(nid, nes);
                    TrackModel.this.connectedEdgeSets.remove(rid);
                    TrackModel.this.tracksUpdated.add(nid);
                    TrackModel.this.tracksUpdated.remove(rid);
                    Boolean targetVisibility = TrackModel.this.visibility.get(sid) != false || TrackModel.this.visibility.get(tid) != false;
                    TrackModel.this.visibility.put(nid, targetVisibility);
                    TrackModel.this.visibility.remove(rid);
                    TrackModel.this.names.remove(rid);
                }
            } else if (null == sid && null == tid) {
                HashSet<Spot> nvs = new HashSet<Spot>(2);
                nvs.add((Spot)TrackModel.this.graph.getEdgeSource((Object)e));
                nvs.add((Spot)TrackModel.this.graph.getEdgeTarget((Object)e));
                HashSet<DefaultWeightedEdge> nes = new HashSet<DefaultWeightedEdge>(1);
                nes.add(e);
                int nid = TrackModel.this.IDcounter++;
                TrackModel.this.connectedEdgeSets.put(nid, nes);
                TrackModel.this.connectedVertexSets.put(nid, nvs);
                TrackModel.this.vertexToID.put(sv, nid);
                TrackModel.this.vertexToID.put(tv, nid);
                TrackModel.this.edgeToID.put(e, nid);
                TrackModel.this.visibility.put(nid, Boolean.TRUE);
                TrackModel.this.names.put(nid, TrackModel.this.nameGenerator.next());
                TrackModel.this.tracksUpdated.add(nid);
            } else if (null == sid) {
                TrackModel.this.connectedEdgeSets.get(tid).add(e);
                TrackModel.this.edgeToID.put(e, tid);
                TrackModel.this.connectedVertexSets.get(tid).add(sv);
                TrackModel.this.vertexToID.put(sv, tid);
                TrackModel.this.tracksUpdated.add(tid);
            } else if (null == tid) {
                TrackModel.this.connectedEdgeSets.get(sid).add(e);
                TrackModel.this.edgeToID.put(e, sid);
                TrackModel.this.connectedVertexSets.get(sid).add(tv);
                TrackModel.this.vertexToID.put(tv, sid);
                TrackModel.this.tracksUpdated.add(sid);
            }
        }

        public void edgeRemoved(GraphEdgeChangeEvent<Spot, DefaultWeightedEdge> event) {
            TrackModel.this.edgesRemoved.add((DefaultWeightedEdge)event.getEdge());
            DefaultWeightedEdge e = (DefaultWeightedEdge)event.getEdge();
            Integer id = TrackModel.this.edgeToID.get(e);
            if (null == id) {
                throw new RuntimeException("Edge is unkown to this model: " + String.valueOf(e));
            }
            Set<DefaultWeightedEdge> set = TrackModel.this.connectedEdgeSets.get(id);
            if (null == set) {
                throw new RuntimeException("Unknown set ID: " + id);
            }
            boolean removed = set.remove(e);
            if (!removed) {
                throw new RuntimeException("Could not removed edge " + String.valueOf(e) + " from set with ID: " + id);
            }
            TrackModel.this.edgeToID.remove(e);
            if (set.size() == 0) {
                TrackModel.this.connectedEdgeSets.remove(id);
                TrackModel.this.names.remove(id);
                TrackModel.this.visibility.remove(id);
                Set<Spot> vertexSet = TrackModel.this.connectedVertexSets.get(id);
                for (Spot spot : vertexSet) {
                    TrackModel.this.vertexToID.remove(spot);
                }
                TrackModel.this.connectedVertexSets.remove(id);
                TrackModel.this.tracksUpdated.remove(id);
            } else {
                HashSet<Spot> sourceVCS = new HashSet<Spot>();
                HashSet sourceECS = new HashSet();
                Spot source = (Spot)TrackModel.this.graph.getEdgeSource((Object)e);
                BreadthFirstIterator i = new BreadthFirstIterator(TrackModel.this.graph, (Object)source);
                while (i.hasNext()) {
                    Spot sv = (Spot)i.next();
                    sourceVCS.add(sv);
                    sourceECS.addAll(TrackModel.this.graph.edgesOf((Object)sv));
                }
                HashSet<Spot> targetVCS = new HashSet<Spot>();
                HashSet targetECS = new HashSet();
                Spot target = (Spot)TrackModel.this.graph.getEdgeTarget((Object)e);
                BreadthFirstIterator i2 = new BreadthFirstIterator(TrackModel.this.graph, (Object)target);
                while (i2.hasNext()) {
                    Spot sv = (Spot)i2.next();
                    targetVCS.add(sv);
                    targetECS.addAll(TrackModel.this.graph.edgesOf((Object)sv));
                }
                if (targetVCS.equals(sourceVCS)) {
                    TrackModel.this.tracksUpdated.add(id);
                    TrackModel.this.connectedEdgeSets.get(id).remove(e);
                    return;
                }
                if (targetVCS.size() > sourceVCS.size()) {
                    TrackModel.this.connectedEdgeSets.put(id, targetECS);
                    TrackModel.this.connectedVertexSets.put(id, targetVCS);
                    TrackModel.this.tracksUpdated.add(id);
                    if (sourceECS.size() > 0) {
                        int newid = TrackModel.this.IDcounter++;
                        TrackModel.this.connectedEdgeSets.put(newid, sourceECS);
                        for (DefaultWeightedEdge te : sourceECS) {
                            TrackModel.this.edgeToID.put(te, newid);
                        }
                        TrackModel.this.connectedVertexSets.put(newid, sourceVCS);
                        for (Spot tv : sourceVCS) {
                            TrackModel.this.vertexToID.put(tv, newid);
                        }
                        targetVisibility = TrackModel.this.visibility.get(id);
                        TrackModel.this.visibility.put(newid, (Boolean)targetVisibility);
                        TrackModel.this.names.put(newid, TrackModel.this.nameGenerator.next());
                        TrackModel.this.tracksUpdated.add(newid);
                    } else {
                        solitary = (Spot)sourceVCS.iterator().next();
                        TrackModel.this.vertexToID.remove(solitary);
                    }
                } else if (sourceECS.size() > 0) {
                    TrackModel.this.connectedEdgeSets.put(id, sourceECS);
                    TrackModel.this.connectedVertexSets.put(id, sourceVCS);
                    TrackModel.this.tracksUpdated.add(id);
                    if (targetECS.size() > 0) {
                        int newid = TrackModel.this.IDcounter++;
                        TrackModel.this.connectedEdgeSets.put(newid, targetECS);
                        for (DefaultWeightedEdge te : targetECS) {
                            TrackModel.this.edgeToID.put(te, newid);
                        }
                        TrackModel.this.connectedVertexSets.put(newid, targetVCS);
                        for (Spot v : targetVCS) {
                            TrackModel.this.vertexToID.put(v, newid);
                        }
                        targetVisibility = TrackModel.this.visibility.get(id);
                        TrackModel.this.visibility.put(newid, (Boolean)targetVisibility);
                        TrackModel.this.names.put(newid, TrackModel.this.nameGenerator.next());
                        TrackModel.this.tracksUpdated.add(newid);
                    } else {
                        solitary = (Spot)targetVCS.iterator().next();
                        TrackModel.this.vertexToID.remove(solitary);
                    }
                } else {
                    TrackModel.this.connectedEdgeSets.remove(id);
                    TrackModel.this.connectedVertexSets.remove(id);
                    TrackModel.this.names.remove(id);
                    TrackModel.this.visibility.remove(id);
                    TrackModel.this.tracksUpdated.remove(id);
                }
            }
        }
    }

    private class MyTraversalListener
    implements TraversalListener<Spot, DefaultWeightedEdge> {
        private Set<Spot> currentConnectedVertexSet;
        private Set<DefaultWeightedEdge> currentConnectedEdgeSet;
        private Integer ID;

        private MyTraversalListener() {
        }

        public void connectedComponentFinished(ConnectedComponentTraversalEvent event) {
            if (this.currentConnectedVertexSet.size() <= 1 || this.currentConnectedEdgeSet.size() == 0) {
                for (DefaultWeightedEdge e : this.currentConnectedEdgeSet) {
                    TrackModel.this.edgeToID.remove(e);
                }
                for (Spot v : this.currentConnectedVertexSet) {
                    TrackModel.this.vertexToID.remove(v);
                }
                return;
            }
            TrackModel.this.connectedVertexSets.put(this.ID, this.currentConnectedVertexSet);
            TrackModel.this.connectedEdgeSets.put(this.ID, this.currentConnectedEdgeSet);
            TrackModel.this.visibility.put(this.ID, DEFAULT_VISIBILITY);
            TrackModel.this.names.put(this.ID, TrackModel.this.nameGenerator.next());
        }

        public void connectedComponentStarted(ConnectedComponentTraversalEvent e) {
            this.currentConnectedVertexSet = new HashSet<Spot>();
            this.currentConnectedEdgeSet = new HashSet<DefaultWeightedEdge>();
            this.ID = TrackModel.this.IDcounter++;
        }

        public void vertexTraversed(VertexTraversalEvent<Spot> event) {
            Spot v = (Spot)event.getVertex();
            this.currentConnectedVertexSet.add(v);
            TrackModel.this.vertexToID.put(v, this.ID);
        }

        public void edgeTraversed(EdgeTraversalEvent<DefaultWeightedEdge> event) {
            DefaultWeightedEdge e = (DefaultWeightedEdge)event.getEdge();
            this.currentConnectedEdgeSet.add(e);
            TrackModel.this.edgeToID.put(e, this.ID);
        }

        public void vertexFinished(VertexTraversalEvent<Spot> e) {
        }
    }
}

