/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.util.SpotUtil;
import fiji.plugin.trackmate.util.Threads;
import ij.gui.PolygonRoi;
import ij.process.FloatPolygon;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.labeling.ConnectedComponents;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelRegion;
import net.imglib2.roi.labeling.LabelRegions;
import net.imglib2.type.BooleanType;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class MaskUtils {
    private static final double SMOOTH_INTERVAL = 2.0;
    private static final double DOUGLAS_PEUCKER_MAX_DISTANCE = 0.5;

    public static final <T extends RealType<T>> double otsuThreshold(RandomAccessibleInterval<T> img) {
        RealType t = (RealType)img.getType();
        RealType max = (RealType)t.createVariable();
        max.setReal(Double.NEGATIVE_INFINITY);
        RealType min = (RealType)t.createVariable();
        min.setReal(Double.POSITIVE_INFINITY);
        for (RealType pixel : img) {
            if (pixel.compareTo((Object)min) < 0) {
                min.set((Type)pixel);
            }
            if (pixel.compareTo((Object)max) <= 0) continue;
            max.set((Type)pixel);
        }
        Real1dBinMapper mapper = new Real1dBinMapper(min.getRealDouble(), max.getRealDouble(), 256L, false);
        Histogram1d histogram = new Histogram1d(img, (BinMapper1d)mapper);
        long k = MaskUtils.getThreshold(histogram);
        RealType val = (RealType)t.createVariable();
        mapper.getCenterValue(k, val);
        return val.getRealDouble();
    }

    public static final long getThreshold(Histogram1d<?> hist) {
        int k;
        long[] histogram = hist.toLongArray();
        int L = histogram.length;
        long S = 0L;
        long N = 0L;
        for (k = 0; k < L; ++k) {
            S += (long)k * histogram[k];
            N += histogram[k];
        }
        long Sk = 0L;
        long N1 = histogram[0];
        double BCV = 0.0;
        double BCVmax = 0.0;
        int kStar = 0;
        for (k = 1; k < L - 1; ++k) {
            double denom;
            Sk += (long)k * histogram[k];
            if ((denom = (double)(N1 += histogram[k]) * (double)(N - N1)) != 0.0) {
                double num = (double)N1 / (double)N * (double)S - (double)Sk;
                BCV = num * num / denom;
            } else {
                BCV = 0.0;
            }
            if (!(BCV >= BCVmax)) continue;
            BCVmax = BCV;
            kStar = k;
        }
        return kStar;
    }

    public static final <T extends RealType<T>> ImgLabeling<Integer, IntType> toLabeling(RandomAccessible<T> input, Interval interval, double threshold, int numThreads) {
        IntervalView crop = Views.interval(input, (Interval)interval);
        IntervalView in = Views.zeroMin((RandomAccessibleInterval)crop);
        Converter converter = (a, b) -> b.set(a.getRealDouble() > threshold);
        RandomAccessibleInterval bitMask = Converters.convertRAI((RandomAccessibleInterval)in, (Converter)converter, (Type)new BitType());
        ImgFactory factory = Util.getArrayOrCellImgFactory((Dimensions)in, (NativeType)new IntType());
        Img out = factory.create((Dimensions)in);
        ImgLabeling labeling = new ImgLabeling((RandomAccessibleInterval)out);
        ConnectedComponents.StructuringElement se = ConnectedComponents.StructuringElement.FOUR_CONNECTED;
        ExecutorService executorService = numThreads > 1 ? Threads.newFixedThreadPool(numThreads) : Threads.newSingleThreadExecutor();
        ConnectedComponents.labelAllConnectedComponents((RandomAccessible)bitMask, (ImgLabeling)labeling, MaskUtils.labelGenerator(), (ConnectedComponents.StructuringElement)se, (ExecutorService)executorService);
        executorService.shutdown();
        return labeling;
    }

    public static <T extends RealType<T>> List<Spot> fromThreshold(RandomAccessible<T> input, Interval interval, double[] calibration, double threshold, int numThreads) {
        ImgLabeling<Integer, IntType> labeling = MaskUtils.toLabeling(input, interval, threshold, numThreads);
        return MaskUtils.fromLabeling(labeling, interval, calibration);
    }

    public static <R extends IntegerType<R>> List<Spot> fromLabeling(ImgLabeling<Integer, R> labeling, Interval interval, double[] calibration) {
        LabelRegions regions = new LabelRegions(labeling);
        Iterator iterator = regions.iterator();
        ArrayList<Spot> spots = new ArrayList<Spot>(regions.getExistingLabels().size());
        while (iterator.hasNext()) {
            LabelRegion region = (LabelRegion)iterator.next();
            Cursor cursor = region.localizingCursor();
            int[] cursorPos = new int[labeling.numDimensions()];
            long[] sum = new long[3];
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.localize(cursorPos);
                for (int d = 0; d < sum.length; ++d) {
                    int n = d;
                    sum[n] = sum[n] + (long)cursorPos[d];
                }
            }
            double[] pos = new double[3];
            for (int d = 0; d < pos.length; ++d) {
                pos[d] = (double)sum[d] / (double)region.size();
            }
            double x = calibration[0] * ((double)interval.min(0) + pos[0]);
            double y = calibration[1] * ((double)interval.min(1) + pos[1]);
            double z = calibration[2] * ((double)interval.min(2) + pos[2]);
            double volume = region.size();
            for (int d = 0; d < calibration.length; ++d) {
                if (!(calibration[d] > 0.0)) continue;
                volume *= calibration[d];
            }
            double radius = labeling.numDimensions() == 2 ? Math.sqrt(volume / Math.PI) : Math.pow(3.0 * volume / (Math.PI * 4), 0.3333333333333333);
            double quality = region.size();
            spots.add(new Spot(x, y, z, radius, quality));
        }
        return spots;
    }

    public static <T extends RealType<T>, R extends RealType<R>> List<Spot> fromThreshold(RandomAccessible<T> input, Interval interval, double[] calibration, double threshold, int numThreads, RandomAccessibleInterval<R> qualityImage) {
        ImgLabeling<Integer, IntType> labeling = MaskUtils.toLabeling(input, interval, threshold, numThreads);
        IntervalView cropQuality = Views.interval(qualityImage, (Interval)interval);
        IntervalView inQuality = Views.zeroMin((RandomAccessibleInterval)cropQuality);
        RandomAccess raQuality = inQuality.randomAccess((Interval)inQuality);
        LabelRegions regions = new LabelRegions(labeling);
        Iterator iterator = regions.iterator();
        ArrayList<Spot> spots = new ArrayList<Spot>(regions.getExistingLabels().size());
        while (iterator.hasNext()) {
            LabelRegion region = (LabelRegion)iterator.next();
            Cursor cursor = region.localizingCursor();
            int[] cursorPos = new int[labeling.numDimensions()];
            long[] sum = new long[3];
            double quality = Double.NEGATIVE_INFINITY;
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.localize(cursorPos);
                for (int d = 0; d < sum.length; ++d) {
                    int n = d;
                    sum[n] = sum[n] + (long)cursorPos[d];
                }
                raQuality.setPosition((Localizable)cursor);
                double q = ((RealType)raQuality.get()).getRealDouble();
                if (!(q > quality)) continue;
                quality = q;
            }
            double[] pos = new double[3];
            for (int d = 0; d < pos.length; ++d) {
                pos[d] = (double)sum[d] / (double)region.size();
            }
            double x = calibration[0] * ((double)interval.min(0) + pos[0]);
            double y = calibration[1] * ((double)interval.min(1) + pos[1]);
            double z = calibration[2] * ((double)interval.min(2) + pos[2]);
            double volume = region.size();
            for (int d = 0; d < calibration.length; ++d) {
                if (!(calibration[d] > 0.0)) continue;
                volume *= calibration[d];
            }
            double radius = labeling.numDimensions() == 2 ? Math.sqrt(volume / Math.PI) : Math.pow(3.0 * volume / (Math.PI * 4), 0.3333333333333333);
            spots.add(new Spot(x, y, z, radius, quality));
        }
        return spots;
    }

    public static final <T extends RealType<T>, S extends RealType<S>> List<Spot> fromThresholdWithROI(RandomAccessible<T> input, Interval interval, double[] calibration, double threshold, boolean simplify, int numThreads, RandomAccessibleInterval<S> qualityImage) {
        if (input.numDimensions() != 2) {
            throw new IllegalArgumentException("Can only process 2D images with this method, but got " + input.numDimensions() + "D.");
        }
        ImgLabeling<Integer, IntType> labeling = MaskUtils.toLabeling(input, interval, threshold, numThreads);
        return MaskUtils.fromLabelingWithROI(labeling, interval, calibration, simplify, qualityImage);
    }

    public static <R extends IntegerType<R>, S extends RealType<S>> List<Spot> fromLabelingWithROI(ImgLabeling<Integer, R> labeling, Interval interval, double[] calibration, boolean simplify, RandomAccessibleInterval<S> qualityImage) {
        Map<Integer, List<Spot>> map = MaskUtils.fromLabelingWithROIMap(labeling, interval, calibration, simplify, qualityImage);
        ArrayList<Spot> spots = new ArrayList<Spot>();
        for (List<Spot> s : map.values()) {
            spots.addAll(s);
        }
        return spots;
    }

    public static <R extends IntegerType<R>, S extends RealType<S>> Map<Integer, List<Spot>> fromLabelingWithROIMap(ImgLabeling<Integer, R> labeling, Interval interval, double[] calibration, boolean simplify, RandomAccessibleInterval<S> qualityImage) {
        if (labeling.numDimensions() != 2) {
            throw new IllegalArgumentException("Can only process 2D images with this method, but got " + labeling.numDimensions() + "D.");
        }
        LabelRegions regions = new LabelRegions(labeling);
        HashMap<Integer, List<Polygon>> polygonsMap = new HashMap<Integer, List<Polygon>>(regions.getExistingLabels().size());
        for (LabelRegion region : regions) {
            List<Polygon> pp = MaskUtils.maskToPolygons(Views.zeroMin((RandomAccessibleInterval)region));
            for (Polygon polygon : pp) {
                polygon.translate((int)region.min(0), (int)region.min(1));
            }
            Integer label = (Integer)region.getLabel();
            polygonsMap.put(label, pp);
        }
        HashMap<Integer, List<Spot>> output = new HashMap<Integer, List<Spot>>(polygonsMap.size());
        for (Integer label : polygonsMap.keySet()) {
            ArrayList<Spot> spots = new ArrayList<Spot>(polygonsMap.size());
            output.put(label, spots);
            List polygons = (List)polygonsMap.get(label);
            for (Polygon polygon : polygons) {
                double quality;
                PolygonRoi roi = new PolygonRoi(polygon, 2);
                PolygonRoi fRoi = simplify ? MaskUtils.simplify(roi, 2.0, 0.5) : roi;
                if (fRoi.getNCoordinates() < 3 || fRoi.getStatistics().area <= 0.0) continue;
                Polygon fPolygon = fRoi.getPolygon();
                double[] xpoly = new double[fPolygon.npoints];
                double[] ypoly = new double[fPolygon.npoints];
                for (int i = 0; i < fPolygon.npoints; ++i) {
                    xpoly[i] = calibration[0] * ((double)(interval.min(0) + (long)fPolygon.xpoints[i]) - 0.5);
                    ypoly[i] = calibration[1] * ((double)(interval.min(1) + (long)fPolygon.ypoints[i]) - 0.5);
                }
                Spot spot = SpotRoi.createSpot(xpoly, ypoly, -1.0);
                if (null == qualityImage) {
                    quality = fRoi.getStatistics().area;
                } else {
                    String name = "QualityImage";
                    AxisType[] axes = new AxisType[]{Axes.X, Axes.Y};
                    double[] cal = new double[]{calibration[0], calibration[1]};
                    String[] units = new String[]{"unitX", "unitY"};
                    ImgPlus qualityImgPlus = new ImgPlus(ImgPlus.wrapToImg(qualityImage), "QualityImage", axes, cal, units);
                    IterableInterval iterable = SpotUtil.iterable(spot, qualityImgPlus);
                    double max = Double.NEGATIVE_INFINITY;
                    for (RealType s : iterable) {
                        double val = s.getRealDouble();
                        if (!(val > max)) continue;
                        max = val;
                    }
                    quality = max;
                }
                spot.putFeature("QUALITY", quality);
                spots.add(spot);
            }
        }
        return output;
    }

    private static final double distanceSquaredBetweenPoints(double vx, double vy, double wx, double wy) {
        double deltax = vx - wx;
        double deltay = vy - wy;
        return deltax * deltax + deltay * deltay;
    }

    private static final double distanceToSegmentSquared(double px, double py, double vx, double vy, double wx, double wy) {
        double l2 = MaskUtils.distanceSquaredBetweenPoints(vx, vy, wx, wy);
        if (l2 == 0.0) {
            return MaskUtils.distanceSquaredBetweenPoints(px, py, vx, vy);
        }
        double t = ((px - vx) * (wx - vx) + (py - vy) * (wy - vy)) / l2;
        if (t < 0.0) {
            return MaskUtils.distanceSquaredBetweenPoints(px, py, vx, vy);
        }
        if (t > 1.0) {
            return MaskUtils.distanceSquaredBetweenPoints(px, py, wx, wy);
        }
        return MaskUtils.distanceSquaredBetweenPoints(px, py, vx + t * (wx - vx), vy + t * (wy - vy));
    }

    private static final double perpendicularDistance(double px, double py, double vx, double vy, double wx, double wy) {
        return Math.sqrt(MaskUtils.distanceToSegmentSquared(px, py, vx, vy, wx, wy));
    }

    private static final void douglasPeucker(List<double[]> list, int s, int e, double epsilon, List<double[]> resultList) {
        double dmax = 0.0;
        int index = 0;
        int start = s;
        int end = e - 1;
        for (int i = start + 1; i < end; ++i) {
            double wy;
            double wx;
            double vy;
            double vx;
            double py;
            double px = list.get(i)[0];
            double d = MaskUtils.perpendicularDistance(px, py = list.get(i)[1], vx = list.get(start)[0], vy = list.get(start)[1], wx = list.get(end)[0], wy = list.get(end)[1]);
            if (!(d > dmax)) continue;
            index = i;
            dmax = d;
        }
        if (dmax > epsilon) {
            MaskUtils.douglasPeucker(list, s, index, epsilon, resultList);
            MaskUtils.douglasPeucker(list, index, e, epsilon, resultList);
        } else if (end - start > 0) {
            resultList.add(list.get(start));
            resultList.add(list.get(end));
        } else {
            resultList.add(list.get(start));
        }
    }

    public static final List<double[]> douglasPeucker(List<double[]> list, double epsilon) {
        ArrayList<double[]> resultList = new ArrayList<double[]>();
        MaskUtils.douglasPeucker(list, 0, list.size(), epsilon, resultList);
        return resultList;
    }

    public static final PolygonRoi simplify(PolygonRoi roi, double smoothInterval, double epsilon) {
        FloatPolygon fPoly = roi.getInterpolatedPolygon(smoothInterval, true);
        ArrayList<double[]> points = new ArrayList<double[]>(fPoly.npoints);
        for (int i = 0; i < fPoly.npoints; ++i) {
            points.add(new double[]{fPoly.xpoints[i], fPoly.ypoints[i]});
        }
        List<double[]> simplifiedPoints = MaskUtils.douglasPeucker(points, epsilon);
        float[] sX = new float[simplifiedPoints.size()];
        float[] sY = new float[simplifiedPoints.size()];
        for (int i = 0; i < sX.length; ++i) {
            sX[i] = (float)simplifiedPoints.get(i)[0];
            sY[i] = (float)simplifiedPoints.get(i)[1];
        }
        FloatPolygon simplifiedPolygon = new FloatPolygon(sX, sY);
        PolygonRoi fRoi = new PolygonRoi(simplifiedPolygon, 2);
        return fRoi;
    }

    public static final Iterator<Integer> labelGenerator() {
        return new Iterator<Integer>(){
            private int currentVal = 0;

            @Override
            public Integer next() {
                ++this.currentVal;
                return this.currentVal;
            }

            @Override
            public boolean hasNext() {
                return true;
            }
        };
    }

    private static final <T extends BooleanType<T>> List<Polygon> maskToPolygons(RandomAccessibleInterval<T> mask) {
        int w = (int)mask.dimension(0);
        int h = (int)mask.dimension(1);
        RandomAccess ra = mask.randomAccess(mask);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        boolean[] prevRow = new boolean[w + 2];
        boolean[] thisRow = new boolean[w + 2];
        Outline[] outline = new Outline[w + 1];
        for (int y = 0; y <= h; ++y) {
            ra.setPosition(y, 1);
            boolean[] b = prevRow;
            prevRow = thisRow;
            thisRow = b;
            int xAfterLowerRightCorner = -1;
            Outline oAfterLowerRightCorner = null;
            ra.setPosition(0, 0);
            thisRow[1] = y < h ? ((BooleanType)ra.get()).get() : false;
            for (int x = 0; x <= w; ++x) {
                int x1;
                ra.setPosition(x + 1, 0);
                if (y < h && x < w - 1) {
                    thisRow[x + 2] = ((BooleanType)ra.get()).get();
                } else if (x < w - 1) {
                    thisRow[x + 2] = false;
                }
                if (thisRow[x + 1]) {
                    if (!prevRow[x + 1]) {
                        if (outline[x] == null) {
                            if (outline[x + 1] == null) {
                                outline[x + 1] = outline[x] = new Outline();
                                outline[x].append(x + 1, y);
                                outline[x].append(x, y);
                            } else {
                                outline[x] = outline[x + 1];
                                outline[x + 1] = null;
                                outline[x].append(x, y);
                            }
                        } else if (outline[x + 1] == null) {
                            if (x == xAfterLowerRightCorner) {
                                outline[x + 1] = outline[x];
                                outline[x] = oAfterLowerRightCorner;
                                outline[x].append(x, y);
                                outline[x + 1].prepend(x + 1, y);
                            } else {
                                outline[x + 1] = outline[x];
                                outline[x] = null;
                                outline[x + 1].prepend(x + 1, y);
                            }
                        } else if (outline[x + 1] == outline[x]) {
                            if (x < w - 1 && y < h && x != xAfterLowerRightCorner && !thisRow[x + 2] && prevRow[x + 2]) {
                                outline[x] = null;
                                outline[x + 1].prepend(x + 1, y);
                                xAfterLowerRightCorner = x + 1;
                                oAfterLowerRightCorner = outline[x + 1];
                            } else {
                                outline[x + 1] = null;
                                outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                            }
                        } else {
                            outline[x].prepend(outline[x + 1]);
                            for (x1 = 0; x1 <= w; ++x1) {
                                if (x1 == x + 1 || outline[x1] != outline[x + 1]) continue;
                                outline[x1] = outline[x];
                                outline[x + 1] = null;
                                outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                                break;
                            }
                            if (outline[x + 1] != null) {
                                throw new RuntimeException("assertion failed");
                            }
                        }
                    }
                    if (thisRow[x]) continue;
                    if (outline[x] == null) {
                        throw new RuntimeException("assertion failed");
                    }
                    outline[x].append(x, y + 1);
                    continue;
                }
                if (prevRow[x + 1]) {
                    if (outline[x] == null) {
                        if (outline[x + 1] == null) {
                            Outline outline2 = new Outline();
                            outline[x + 1] = outline2;
                            outline[x] = outline2;
                            outline[x].append(x, y);
                            outline[x].append(x + 1, y);
                        } else {
                            outline[x] = outline[x + 1];
                            outline[x + 1] = null;
                            outline[x].prepend(x, y);
                        }
                    } else if (outline[x + 1] == null) {
                        if (x == xAfterLowerRightCorner) {
                            outline[x + 1] = outline[x];
                            outline[x] = oAfterLowerRightCorner;
                            outline[x].prepend(x, y);
                            outline[x + 1].append(x + 1, y);
                        } else {
                            outline[x + 1] = outline[x];
                            outline[x] = null;
                            outline[x + 1].append(x + 1, y);
                        }
                    } else if (outline[x + 1] == outline[x]) {
                        if (x < w - 1 && y < h && x != xAfterLowerRightCorner && thisRow[x + 2] && !prevRow[x + 2]) {
                            outline[x] = null;
                            outline[x + 1].append(x + 1, y);
                            xAfterLowerRightCorner = x + 1;
                            oAfterLowerRightCorner = outline[x + 1];
                        } else {
                            polygons.add(outline[x].getPolygon());
                            outline[x + 1] = null;
                            outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                        }
                    } else if (x < w - 1 && y < h && x != xAfterLowerRightCorner && thisRow[x + 2] && !prevRow[x + 2]) {
                        outline[x].append(x + 1, y);
                        outline[x + 1].prepend(x + 1, y);
                        xAfterLowerRightCorner = x + 1;
                        oAfterLowerRightCorner = outline[x];
                        outline[x] = null;
                    } else {
                        outline[x].append(outline[x + 1]);
                        for (x1 = 0; x1 <= w; ++x1) {
                            if (x1 == x + 1 || outline[x1] != outline[x + 1]) continue;
                            outline[x1] = outline[x];
                            outline[x + 1] = null;
                            outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                            break;
                        }
                        if (outline[x + 1] != null) {
                            throw new RuntimeException("assertion failed");
                        }
                    }
                }
                if (!thisRow[x]) continue;
                if (outline[x] == null) {
                    throw new RuntimeException("assertion failed");
                }
                outline[x].prepend(x, y + 1);
            }
        }
        return polygons;
    }

    private static class Outline {
        private int[] x = new int[this.reserved];
        private int[] y = new int[this.reserved];
        private int first = 5;
        private int last = 5;
        private int reserved = 10;
        private final int GROW = 10;

        private void needs(int neededAtBegin, int neededAtEnd) {
            if (neededAtBegin > this.first || neededAtEnd > this.reserved - this.last) {
                int extraSpace = Math.max(10, Math.abs(this.x[this.last - 1] - this.x[this.first]));
                int newSize = this.reserved + neededAtBegin + neededAtEnd + extraSpace;
                int newFirst = neededAtBegin + extraSpace / 2;
                int[] newX = new int[newSize];
                int[] newY = new int[newSize];
                System.arraycopy(this.x, this.first, newX, newFirst, this.last - this.first);
                System.arraycopy(this.y, this.first, newY, newFirst, this.last - this.first);
                this.x = newX;
                this.y = newY;
                this.last += newFirst - this.first;
                this.first = newFirst;
                this.reserved = newSize;
            }
        }

        public void append(int x, int y) {
            if (this.last - this.first >= 2 && this.collinear(this.x[this.last - 2], this.y[this.last - 2], this.x[this.last - 1], this.y[this.last - 1], x, y)) {
                this.x[this.last - 1] = x;
                this.y[this.last - 1] = y;
            } else {
                this.needs(0, 1);
                this.x[this.last] = x;
                this.y[this.last] = y;
                ++this.last;
            }
        }

        public void prepend(int x, int y) {
            if (this.last - this.first >= 2 && this.collinear(this.x[this.first + 1], this.y[this.first + 1], this.x[this.first], this.y[this.first], x, y)) {
                this.x[this.first] = x;
                this.y[this.first] = y;
            } else {
                this.needs(1, 0);
                --this.first;
                this.x[this.first] = x;
                this.y[this.first] = y;
            }
        }

        public void append(Outline o) {
            int size = this.last - this.first;
            int oSize = o.last - o.first;
            if (size <= o.first && oSize > this.reserved - this.last) {
                System.arraycopy(this.x, this.first, o.x, o.first - size, size);
                System.arraycopy(this.y, this.first, o.y, o.first - size, size);
                this.x = o.x;
                this.y = o.y;
                this.first = o.first - size;
                this.last = o.last;
                this.reserved = o.reserved;
            } else {
                this.needs(0, oSize);
                System.arraycopy(o.x, o.first, this.x, this.last, oSize);
                System.arraycopy(o.y, o.first, this.y, this.last, oSize);
                this.last += oSize;
            }
        }

        public void prepend(Outline o) {
            int size = this.last - this.first;
            int oSize = o.last - o.first;
            if (size <= o.reserved - o.last && oSize > this.first) {
                System.arraycopy(this.x, this.first, o.x, o.last, size);
                System.arraycopy(this.y, this.first, o.y, o.last, size);
                this.x = o.x;
                this.y = o.y;
                this.first = o.first;
                this.last = o.last + size;
                this.reserved = o.reserved;
            } else {
                this.needs(oSize, 0);
                this.first -= oSize;
                System.arraycopy(o.x, o.first, this.x, this.first, oSize);
                System.arraycopy(o.y, o.first, this.y, this.first, oSize);
            }
        }

        public Polygon getPolygon() {
            int j = this.first + 1;
            int i = this.first + 1;
            while (i + 1 < this.last) {
                if (this.collinear(this.x[j - 1], this.y[j - 1], this.x[j], this.y[j], this.x[j + 1], this.y[j + 1])) {
                    --this.last;
                } else {
                    if (i != j) {
                        this.x[i] = this.x[j];
                        this.y[i] = this.y[j];
                    }
                    ++i;
                }
                ++j;
            }
            if (this.collinear(this.x[j - 1], this.y[j - 1], this.x[j], this.y[j], this.x[this.first], this.y[this.first])) {
                --this.last;
            } else {
                this.x[i] = this.x[j];
                this.y[i] = this.y[j];
            }
            if (this.last - this.first > 2 && this.collinear(this.x[this.last - 1], this.y[this.last - 1], this.x[this.first], this.y[this.first], this.x[this.first + 1], this.y[this.first + 1])) {
                ++this.first;
            }
            int count = this.last - this.first;
            int[] xNew = new int[count];
            int[] yNew = new int[count];
            System.arraycopy(this.x, this.first, xNew, 0, count);
            System.arraycopy(this.y, this.first, yNew, 0, count);
            return new Polygon(xNew, yNew, count);
        }

        public boolean collinear(int x1, int y1, int x2, int y2, int x3, int y3) {
            return (x2 - x1) * (y3 - y2) == (y2 - y1) * (x3 - x2);
        }

        public String toString() {
            String res = "[first:" + this.first + ",last:" + this.last + ",reserved:" + this.reserved + ":";
            if (this.last > this.x.length) {
                System.err.println("ERROR!");
            }
            int nmax = 10;
            for (int i = this.first; i < this.last && i < this.x.length; ++i) {
                if (this.last - this.first > nmax && i - this.first > nmax / 2) {
                    i = this.last - nmax / 2;
                    res = res + "...";
                    nmax = this.last - this.first;
                    continue;
                }
                res = res + "(" + this.x[i] + "," + this.y[i] + ")";
            }
            return res + "]";
        }
    }
}

