/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactoryBase;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import fiji.plugin.trackmate.visualization.ManualEdgeColorGenerator;
import fiji.plugin.trackmate.visualization.ManualEdgePerSpotColorGenerator;
import fiji.plugin.trackmate.visualization.ManualSpotColorGenerator;
import fiji.plugin.trackmate.visualization.ManualSpotPerEdgeColorGenerator;
import fiji.plugin.trackmate.visualization.PerEdgeFeatureColorGenerator;
import fiji.plugin.trackmate.visualization.PerSpotFeatureColorGenerator;
import fiji.plugin.trackmate.visualization.PerTrackFeatureColorGenerator;
import fiji.plugin.trackmate.visualization.RandomSpotColorGenerator;
import fiji.plugin.trackmate.visualization.SpotColorGenerator;
import fiji.plugin.trackmate.visualization.SpotColorGeneratorPerEdgeFeature;
import fiji.plugin.trackmate.visualization.SpotColorGeneratorPerTrackFeature;
import fiji.plugin.trackmate.visualization.UniformSpotColorGenerator;
import fiji.plugin.trackmate.visualization.UniformTrackColorGenerator;
import fiji.plugin.trackmate.visualization.WholeTrackFeatureColorGenerator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.util.DoubleArray;

public class FeatureUtils {
    private static final String USE_UNIFORM_COLOR_NAME = "Uniform color";
    public static final String USE_UNIFORM_COLOR_KEY = "UNIFORM_COLOR";
    private static final String USE_RANDOM_COLOR_NAME = "Random color";
    public static final String USE_RANDOM_COLOR_KEY = "RANDOM_COLOR";
    public static final String USE_TRACK_INDEX_COLOR_KEY = "TRACK_INDEX";
    private static final String USE_TRACK_INDEX_COLOR_NAME = "Track index color";
    public static final Model DUMMY_MODEL = new Model();

    public static final Map<String, String> collectFeatureKeys(DisplaySettings.TrackMateObject target, Model model, Settings settings) {
        HashMap<String, String> inverseMap = new HashMap<String, String>();
        switch (target) {
            case SPOTS: {
                if (model != null) {
                    for (String string : model.getFeatureModel().getSpotFeatureNames().keySet()) {
                        inverseMap.put(model.getFeatureModel().getSpotFeatureNames().get(string), string);
                    }
                } else {
                    for (String string : Spot.FEATURE_NAMES.keySet()) {
                        inverseMap.put(Spot.FEATURE_NAMES.get(string), string);
                    }
                }
                if (settings == null) break;
                for (SpotAnalyzerFactoryBase spotAnalyzerFactoryBase : settings.getSpotAnalyzerFactories()) {
                    for (String featureKey : spotAnalyzerFactoryBase.getFeatureNames().keySet()) {
                        inverseMap.put(spotAnalyzerFactoryBase.getFeatureNames().get(featureKey), featureKey);
                    }
                }
                break;
            }
            case EDGES: {
                if (model != null) {
                    for (String string : model.getFeatureModel().getEdgeFeatureNames().keySet()) {
                        inverseMap.put(model.getFeatureModel().getEdgeFeatureNames().get(string), string);
                    }
                }
                if (settings == null) break;
                for (EdgeAnalyzer edgeAnalyzer : settings.getEdgeAnalyzers()) {
                    for (String featureKey : edgeAnalyzer.getFeatureNames().keySet()) {
                        inverseMap.put((String)edgeAnalyzer.getFeatureNames().get(featureKey), featureKey);
                    }
                }
                break;
            }
            case TRACKS: {
                if (model != null) {
                    for (String string : model.getFeatureModel().getTrackFeatureNames().keySet()) {
                        inverseMap.put(model.getFeatureModel().getTrackFeatureNames().get(string), string);
                    }
                }
                if (settings == null) break;
                for (TrackAnalyzer trackAnalyzer : settings.getTrackAnalyzers()) {
                    for (String featureKey : trackAnalyzer.getFeatureNames().keySet()) {
                        inverseMap.put((String)trackAnalyzer.getFeatureNames().get(featureKey), featureKey);
                    }
                }
                break;
            }
            case DEFAULT: {
                inverseMap.put(USE_UNIFORM_COLOR_NAME, USE_UNIFORM_COLOR_KEY);
                inverseMap.put(USE_RANDOM_COLOR_NAME, USE_RANDOM_COLOR_KEY);
                inverseMap.put(USE_TRACK_INDEX_COLOR_NAME, USE_TRACK_INDEX_COLOR_KEY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown object type: " + String.valueOf((Object)target));
            }
        }
        ArrayList featureNameList = new ArrayList(inverseMap.keySet());
        featureNameList.sort(null);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(featureNameList.size());
        for (String featureName : featureNameList) {
            linkedHashMap.put((String)inverseMap.get(featureName), featureName);
        }
        return linkedHashMap;
    }

    public static double[] collectFeatureValues(String featureKey, DisplaySettings.TrackMateObject target, Model model, boolean visibleOnly) {
        FeatureModel fm = model.getFeatureModel();
        switch (target) {
            case DEFAULT: {
                return new double[0];
            }
            case EDGES: {
                DoubleArray val = new DoubleArray();
                for (Integer trackID : model.getTrackModel().trackIDs(visibleOnly)) {
                    for (DefaultWeightedEdge edge : model.getTrackModel().trackEdges(trackID)) {
                        Double ef = fm.getEdgeFeature(edge, featureKey);
                        if (ef == null || ef.isNaN()) continue;
                        val.add((Object)ef);
                    }
                }
                return (double[])val.copyArray();
            }
            case SPOTS: {
                DoubleArray val = new DoubleArray();
                for (Spot spot : model.getSpots().iterable(visibleOnly)) {
                    Double sf = spot.getFeature(featureKey);
                    if (sf == null || sf.isNaN()) continue;
                    val.add((Object)sf);
                }
                return (double[])val.copyArray();
            }
            case TRACKS: {
                DoubleArray val = new DoubleArray();
                for (Integer trackID : model.getTrackModel().trackIDs(visibleOnly)) {
                    Double tf = fm.getTrackFeature(trackID, featureKey);
                    if (tf == null || tf.isNaN()) continue;
                    val.add((Object)tf);
                }
                return (double[])val.copyArray();
            }
        }
        throw new IllegalArgumentException("Unknown object type: " + String.valueOf((Object)target));
    }

    public static final FeatureColorGenerator<Spot> createSpotColorGenerator(Model model, DisplaySettings displaySettings) {
        switch (displaySettings.getSpotColorByType()) {
            case DEFAULT: {
                switch (displaySettings.getSpotColorByFeature()) {
                    case "RANDOM_COLOR": {
                        return new RandomSpotColorGenerator();
                    }
                    case "TRACK_INDEX": {
                        return new SpotColorGeneratorPerTrackFeature(model, USE_TRACK_INDEX_COLOR_KEY, displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), 0.0, 1.0);
                    }
                }
                return new UniformSpotColorGenerator(displaySettings.getSpotUniformColor());
            }
            case EDGES: {
                if (displaySettings.getSpotColorByFeature().equals("MANUAL_EDGE_COLOR")) {
                    return new ManualSpotPerEdgeColorGenerator(model, displaySettings.getMissingValueColor());
                }
                return new SpotColorGeneratorPerEdgeFeature(model, displaySettings.getSpotColorByFeature(), displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getSpotMin(), displaySettings.getSpotMax());
            }
            case SPOTS: {
                if (displaySettings.getSpotColorByFeature().equals("MANUAL_SPOT_COLOR")) {
                    return new ManualSpotColorGenerator(displaySettings.getMissingValueColor());
                }
                return new SpotColorGenerator(displaySettings.getSpotColorByFeature(), displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getSpotMin(), displaySettings.getSpotMax());
            }
            case TRACKS: {
                return new SpotColorGeneratorPerTrackFeature(model, displaySettings.getSpotColorByFeature(), displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getSpotMin(), displaySettings.getSpotMax());
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)displaySettings.getSpotColorByType()));
    }

    public static final FeatureColorGenerator<DefaultWeightedEdge> createTrackColorGenerator(Model model, DisplaySettings displaySettings) {
        switch (displaySettings.getTrackColorByType()) {
            case DEFAULT: {
                switch (displaySettings.getTrackColorByFeature()) {
                    case "RANDOM_COLOR": {
                        return new PerTrackFeatureColorGenerator(model, USE_TRACK_INDEX_COLOR_KEY, displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getTrackMin(), displaySettings.getTrackMax());
                    }
                }
                return new UniformTrackColorGenerator(displaySettings.getTrackUniformColor());
            }
            case EDGES: {
                if (displaySettings.getTrackColorByFeature().equals("MANUAL_EDGE_COLOR")) {
                    return new ManualEdgeColorGenerator(model, displaySettings.getMissingValueColor());
                }
                return new PerEdgeFeatureColorGenerator(model, displaySettings.getTrackColorByFeature(), displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getTrackMin(), displaySettings.getTrackMax());
            }
            case SPOTS: {
                if (displaySettings.getTrackColorByFeature().equals("MANUAL_SPOT_COLOR")) {
                    return new ManualEdgePerSpotColorGenerator(model, displaySettings.getMissingValueColor());
                }
                return new PerSpotFeatureColorGenerator(model, displaySettings.getTrackColorByFeature(), displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getTrackMin(), displaySettings.getTrackMax());
            }
            case TRACKS: {
                return new PerTrackFeatureColorGenerator(model, displaySettings.getTrackColorByFeature(), displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getTrackMin(), displaySettings.getTrackMax());
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)displaySettings.getTrackColorByType()));
    }

    public static final FeatureColorGenerator<Integer> createWholeTrackColorGenerator(Model model, DisplaySettings displaySettings) {
        switch (displaySettings.getTrackColorByType()) {
            case SPOTS: 
            case DEFAULT: {
                return id -> Color.WHITE;
            }
            case EDGES: 
            case TRACKS: {
                return new WholeTrackFeatureColorGenerator(model, displaySettings.getTrackColorByFeature(), displaySettings.getMissingValueColor(), displaySettings.getUndefinedValueColor(), displaySettings.getColormap(), displaySettings.getTrackMin(), displaySettings.getTrackMax());
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)displaySettings.getTrackColorByType()));
    }

    public static final double[] autoMinMax(Model model, DisplaySettings.TrackMateObject type, String feature) {
        switch (type) {
            case DEFAULT: {
                return new double[]{0.0, 0.0};
            }
            case SPOTS: 
            case EDGES: 
            case TRACKS: {
                double[] values = FeatureUtils.collectFeatureValues(feature, type, model, true);
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (double val : values) {
                    if (val < min) {
                        min = val;
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
                return new double[]{min, max};
            }
        }
        throw new IllegalArgumentException("Unexpected TrackMate object type: " + String.valueOf((Object)type));
    }

    public static final int nObjects(Model model, DisplaySettings.TrackMateObject target, boolean visibleOnly) {
        switch (target) {
            case DEFAULT: {
                throw new UnsupportedOperationException("Cannot return the number of objects for type DEFAULT.");
            }
            case EDGES: {
                int nEdges = 0;
                for (Integer trackID : model.getTrackModel().unsortedTrackIDs(visibleOnly)) {
                    nEdges += model.getTrackModel().trackEdges(trackID).size();
                }
                return nEdges;
            }
            case SPOTS: {
                return model.getSpots().getNSpots(visibleOnly);
            }
            case TRACKS: {
                return model.getTrackModel().nTracks(visibleOnly);
            }
        }
        throw new IllegalArgumentException("Unknown TrackMate object: " + String.valueOf((Object)target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Random ran = new Random();
        DUMMY_MODEL.beginUpdate();
        try {
            for (int i = 0; i < 100; ++i) {
                Spot previous = null;
                for (int t = 0; t < 20; ++t) {
                    double x = ran.nextDouble();
                    double y = ran.nextDouble();
                    double z = ran.nextDouble();
                    double r = ran.nextDouble();
                    double q = ran.nextDouble();
                    Spot spot = new Spot(x, y, z, r, q);
                    DUMMY_MODEL.addSpotTo(spot, t);
                    if (previous != null) {
                        DUMMY_MODEL.addEdge(previous, spot, ran.nextDouble());
                    }
                    previous = spot;
                }
            }
        }
        finally {
            DUMMY_MODEL.endUpdate();
        }
    }
}

