/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.util.TMUtils;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StartDialogDescriptor
extends WizardPanelDescriptor {
    private static final String KEY = "Start";
    public static final String PUB1_URL = "https://doi.org/10.1038/s41592-022-01507-1";
    public static final String PUB1_TXT = "Ershov, D., Phan, MS., Pylv\u00e4n\u00e4inen, J.W., Rigaud S.U., et al. TrackMate 7: integrating state-of-the-art segmentation algorithms into tracking pipelines. Nat Methods (2022). https://doi.org/10.1038/s41592-022-01507-1";
    private final Settings settings;
    private final Logger logger;

    public StartDialogDescriptor(Settings settings, Logger logger) {
        super(KEY);
        this.settings = settings;
        this.logger = logger;
        this.targetPanel = new RoiSettingsPanel(settings.imp);
    }

    @Override
    public void aboutToDisplayPanel() {
        String welcomeMessage = "TrackMate v" + TrackMate.PLUGIN_NAME_VERSION + " started on:\n" + TMUtils.getCurrentTimeString() + "\n";
        this.logger.log(welcomeMessage, Logger.BLUE_COLOR);
        this.logger.log("Please note that TrackMate is available through Fiji, and is based on a publication. If you use it successfully for your research please be so kind to cite our work:\n");
        this.logger.log("Ershov, D., Phan, MS., Pylv\u00e4n\u00e4inen, J.W., Rigaud S.U., et al. TrackMate 7: integrating state-of-the-art segmentation algorithms into tracking pipelines. Nat Methods (2022). https://doi.org/10.1038/s41592-022-01507-1\n", Logger.GREEN_COLOR);
        this.logger.log("https://doi.org/10.1038/s41592-022-01507-1\n", Logger.BLUE_COLOR);
        this.logger.log("and / or:\n");
        this.logger.log("Tinevez, JY.; Perry, N. & Schindelin, J. et al. (2017), 'TrackMate: An open and extensible platform for single-particle tracking.', Methods 115: 80-90, PMID 27713081.\n", Logger.GREEN_COLOR);
        this.logger.log("https://www.sciencedirect.com/science/article/pii/S1046202316303346\n", Logger.BLUE_COLOR);
        this.logger.log("\nNumerical feature analyzers:\n", Logger.BLUE_COLOR);
        this.logger.log(this.settings.toStringFeatureAnalyzersInfo());
    }

    @Override
    public void aboutToHidePanel() {
        RoiSettingsPanel panel = (RoiSettingsPanel)this.targetPanel;
        this.settings.setRoi(this.settings.imp.getRoi());
        this.settings.zstart = ((Number)panel.tfZStart.getValue()).intValue();
        this.settings.zend = ((Number)panel.tfZEnd.getValue()).intValue();
        this.settings.tstart = ((Number)panel.tfTStart.getValue()).intValue();
        this.settings.tend = ((Number)panel.tfTEnd.getValue()).intValue();
        this.logger.log("\nImage region of interest:\n", Logger.BLUE_COLOR);
        this.logger.log(this.settings.toStringImageInfo());
        SettingsPersistence.saveLastUsedSettings(this.settings, this.logger);
    }

    private static class RoiSettingsPanel
    extends JPanel {
        private static final long serialVersionUID = -1L;
        private static final NumberFormat DOUBLE_FORMAT = new DecimalFormat("#.###");
        private static final String TOOLTIP = "<html>Pressing this button will make the current <br>ImagePlus the source for TrackMate. If the <br>image has a ROI, it will be used to set the <br>crop rectangle as well.</html>";
        private final JFormattedTextField tfXStart;
        private final JFormattedTextField tfXEnd;
        private final JFormattedTextField tfYStart;
        private final JFormattedTextField tfYEnd;
        private final JFormattedTextField tfZStart;
        private final JFormattedTextField tfZEnd;
        private final JFormattedTextField tfTStart;
        private final JFormattedTextField tfTEnd;

        public RoiSettingsPanel(final ImagePlus imp) {
            this.setPreferredSize(new Dimension(291, 491));
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, 1.0};
            this.setLayout(gridBagLayout);
            JLabel lblCitation = new JLabel("<html>Please note that TrackMate is available through Fiji, and is based on a publication. If you use it successfully for your research please be so kind to cite our work:<p><b>Ershov, D., Phan, MS., Pylv\u00e4n\u00e4inen, J.W., Rigaud S.U. et al., <i>TrackMate 7: integrating state-of-the-art segmentation algorithms into tracking pipelines.</i></b> Nat Methods (2022). https://doi.org/10.1038/s41592-022-01507-1</html>");
            lblCitation.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLblCitation = new GridBagConstraints();
            gbcLblCitation.fill = 1;
            gbcLblCitation.insets = new Insets(5, 5, 5, 5);
            gbcLblCitation.gridwidth = 4;
            gbcLblCitation.gridx = 0;
            gbcLblCitation.gridy = 0;
            this.add((Component)lblCitation, gbcLblCitation);
            JLabel lblLinkPubMed = new JLabel("<html><a href=https://doi.org/10.1038/s41592-022-01507-1>link to paper</a></html>");
            lblLinkPubMed.setFont(Fonts.SMALL_FONT);
            lblLinkPubMed.setCursor(new Cursor(12));
            lblLinkPubMed.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        Desktop.getDesktop().browse(new URI(StartDialogDescriptor.PUB1_URL));
                    }
                    catch (IOException | URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            GridBagConstraints gbcLblLinkPubMed = new GridBagConstraints();
            gbcLblLinkPubMed.anchor = 11;
            gbcLblLinkPubMed.fill = 2;
            gbcLblLinkPubMed.gridwidth = 4;
            gbcLblLinkPubMed.insets = new Insets(0, 10, 5, 5);
            gbcLblLinkPubMed.gridx = 0;
            gbcLblLinkPubMed.gridy = 1;
            this.add((Component)lblLinkPubMed, gbcLblLinkPubMed);
            JLabel lblImageName = new JLabel("Target image: " + imp.getShortTitle());
            lblImageName.setFont(Fonts.BIG_FONT);
            GridBagConstraints gbcLabelImageName = new GridBagConstraints();
            gbcLabelImageName.anchor = 15;
            gbcLabelImageName.fill = 2;
            gbcLabelImageName.insets = new Insets(5, 5, 5, 5);
            gbcLabelImageName.gridwidth = 4;
            gbcLabelImageName.gridx = 0;
            gbcLabelImageName.gridy = 3;
            this.add((Component)lblImageName, gbcLabelImageName);
            JLabel lblCalibrationSettings = new JLabel("Calibration settings:");
            lblCalibrationSettings.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelCalibration = new GridBagConstraints();
            gbcLabelCalibration.anchor = 15;
            gbcLabelCalibration.fill = 2;
            gbcLabelCalibration.insets = new Insets(5, 5, 5, 5);
            gbcLabelCalibration.gridwidth = 4;
            gbcLabelCalibration.gridx = 0;
            gbcLabelCalibration.gridy = 4;
            this.add((Component)lblCalibrationSettings, gbcLabelCalibration);
            JLabel lblPixelWidth = new JLabel("Pixel width:");
            lblPixelWidth.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelPixelWidth = new GridBagConstraints();
            gbcLabelPixelWidth.anchor = 13;
            gbcLabelPixelWidth.insets = new Insets(5, 5, 5, 5);
            gbcLabelPixelWidth.gridwidth = 2;
            gbcLabelPixelWidth.gridx = 0;
            gbcLabelPixelWidth.gridy = 5;
            this.add((Component)lblPixelWidth, gbcLabelPixelWidth);
            JLabel lblPixelWidthVal = new JLabel();
            lblPixelWidthVal.setHorizontalAlignment(0);
            lblPixelWidthVal.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldPixelWidth = new GridBagConstraints();
            gbcTextFieldPixelWidth.fill = 2;
            gbcTextFieldPixelWidth.anchor = 11;
            gbcTextFieldPixelWidth.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldPixelWidth.gridx = 2;
            gbcTextFieldPixelWidth.gridy = 5;
            this.add((Component)lblPixelWidthVal, gbcTextFieldPixelWidth);
            JLabel lblSpatialUnits1 = new JLabel();
            lblSpatialUnits1.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelSpatialUnits = new GridBagConstraints();
            gbcLabelSpatialUnits.anchor = 17;
            gbcLabelSpatialUnits.insets = new Insets(5, 5, 5, 5);
            gbcLabelSpatialUnits.gridx = 3;
            gbcLabelSpatialUnits.gridy = 5;
            this.add((Component)lblSpatialUnits1, gbcLabelSpatialUnits);
            JLabel lblPixelHeight = new JLabel("Pixel height:");
            lblPixelHeight.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelPixelHeight = new GridBagConstraints();
            gbcLabelPixelHeight.anchor = 13;
            gbcLabelPixelHeight.insets = new Insets(5, 5, 5, 5);
            gbcLabelPixelHeight.gridwidth = 2;
            gbcLabelPixelHeight.gridx = 0;
            gbcLabelPixelHeight.gridy = 6;
            this.add((Component)lblPixelHeight, gbcLabelPixelHeight);
            JLabel lblPixelHeightVal = new JLabel();
            lblPixelHeightVal.setHorizontalAlignment(0);
            lblPixelHeightVal.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLblPixelHeight = new GridBagConstraints();
            gbcLblPixelHeight.anchor = 11;
            gbcLblPixelHeight.fill = 2;
            gbcLblPixelHeight.insets = new Insets(5, 5, 5, 5);
            gbcLblPixelHeight.gridx = 2;
            gbcLblPixelHeight.gridy = 6;
            this.add((Component)lblPixelHeightVal, gbcLblPixelHeight);
            JLabel lblTimeInterval = new JLabel("Time interval:");
            lblTimeInterval.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelTimeInterval = new GridBagConstraints();
            gbcLabelTimeInterval.anchor = 13;
            gbcLabelTimeInterval.insets = new Insets(5, 5, 5, 5);
            gbcLabelTimeInterval.gridwidth = 2;
            gbcLabelTimeInterval.gridx = 0;
            gbcLabelTimeInterval.gridy = 8;
            this.add((Component)lblTimeInterval, gbcLabelTimeInterval);
            JLabel lblSpatialUnits2 = new JLabel();
            lblSpatialUnits2.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelTimeUnits = new GridBagConstraints();
            gbcLabelTimeUnits.anchor = 17;
            gbcLabelTimeUnits.insets = new Insets(5, 5, 5, 5);
            gbcLabelTimeUnits.gridx = 3;
            gbcLabelTimeUnits.gridy = 6;
            this.add((Component)lblSpatialUnits2, gbcLabelTimeUnits);
            JLabel lblVoxelDepthVal = new JLabel();
            lblVoxelDepthVal.setHorizontalAlignment(0);
            lblVoxelDepthVal.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLblVoxelDepth = new GridBagConstraints();
            gbcLblVoxelDepth.anchor = 11;
            gbcLblVoxelDepth.fill = 2;
            gbcLblVoxelDepth.insets = new Insets(5, 5, 5, 5);
            gbcLblVoxelDepth.gridx = 2;
            gbcLblVoxelDepth.gridy = 7;
            this.add((Component)lblVoxelDepthVal, gbcLblVoxelDepth);
            JLabel lblVoxelDepth = new JLabel("Voxel depth:");
            lblVoxelDepth.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelVoxelDepth = new GridBagConstraints();
            gbcLabelVoxelDepth.anchor = 13;
            gbcLabelVoxelDepth.insets = new Insets(5, 5, 5, 5);
            gbcLabelVoxelDepth.gridwidth = 2;
            gbcLabelVoxelDepth.gridx = 0;
            gbcLabelVoxelDepth.gridy = 7;
            this.add((Component)lblVoxelDepth, gbcLabelVoxelDepth);
            JLabel lblSpatialUnits3 = new JLabel();
            lblSpatialUnits3.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelUnits3 = new GridBagConstraints();
            gbcLabelUnits3.anchor = 17;
            gbcLabelUnits3.insets = new Insets(5, 5, 5, 5);
            gbcLabelUnits3.gridx = 3;
            gbcLabelUnits3.gridy = 7;
            this.add((Component)lblSpatialUnits3, gbcLabelUnits3);
            JLabel lblTimeUnits = new JLabel();
            lblTimeUnits.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelUnits4 = new GridBagConstraints();
            gbcLabelUnits4.anchor = 17;
            gbcLabelUnits4.insets = new Insets(5, 5, 5, 5);
            gbcLabelUnits4.gridx = 3;
            gbcLabelUnits4.gridy = 8;
            this.add((Component)lblTimeUnits, gbcLabelUnits4);
            JLabel lblTimeIntervalVal = new JLabel();
            lblTimeIntervalVal.setHorizontalAlignment(0);
            lblTimeIntervalVal.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldTimeInterval = new GridBagConstraints();
            gbcTextFieldTimeInterval.anchor = 11;
            gbcTextFieldTimeInterval.fill = 2;
            gbcTextFieldTimeInterval.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldTimeInterval.gridx = 2;
            gbcTextFieldTimeInterval.gridy = 8;
            this.add((Component)lblTimeIntervalVal, gbcTextFieldTimeInterval);
            JLabel lblCropSetting = new JLabel("Crop settings (in pixels, 0-based):");
            lblCropSetting.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelCropSetting = new GridBagConstraints();
            gbcLabelCropSetting.anchor = 15;
            gbcLabelCropSetting.fill = 2;
            gbcLabelCropSetting.insets = new Insets(5, 5, 5, 5);
            gbcLabelCropSetting.gridwidth = 4;
            gbcLabelCropSetting.gridx = 0;
            gbcLabelCropSetting.gridy = 9;
            this.add((Component)lblCropSetting, gbcLabelCropSetting);
            this.tfXStart = new JFormattedTextField((Object)0);
            this.tfXStart.setEnabled(false);
            this.tfXStart.setHorizontalAlignment(0);
            this.tfXStart.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfXStart.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldXStart = new GridBagConstraints();
            gbcTextFieldXStart.fill = 2;
            gbcTextFieldXStart.anchor = 11;
            gbcTextFieldXStart.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldXStart.gridx = 1;
            gbcTextFieldXStart.gridy = 10;
            this.add((Component)this.tfXStart, gbcTextFieldXStart);
            this.tfXEnd = new JFormattedTextField((Object)0);
            this.tfXEnd.setEnabled(false);
            this.tfXEnd.setHorizontalAlignment(0);
            this.tfXEnd.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfXEnd.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldXEnd = new GridBagConstraints();
            gbcTextFieldXEnd.fill = 2;
            gbcTextFieldXEnd.anchor = 11;
            gbcTextFieldXEnd.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldXEnd.gridx = 3;
            gbcTextFieldXEnd.gridy = 10;
            this.add((Component)this.tfXEnd, gbcTextFieldXEnd);
            JLabel jLabelX = new JLabel("X");
            jLabelX.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelX = new GridBagConstraints();
            gbcLabelX.anchor = 13;
            gbcLabelX.insets = new Insets(5, 5, 5, 5);
            gbcLabelX.gridx = 0;
            gbcLabelX.gridy = 10;
            this.add((Component)jLabelX, gbcLabelX);
            JLabel jLabelTo1 = new JLabel("to");
            jLabelTo1.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelTo1 = new GridBagConstraints();
            gbcLabelTo1.insets = new Insets(5, 5, 5, 5);
            gbcLabelTo1.gridx = 2;
            gbcLabelTo1.gridy = 10;
            this.add((Component)jLabelTo1, gbcLabelTo1);
            JLabel jLabelY = new JLabel("Y");
            jLabelY.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelY = new GridBagConstraints();
            gbcLabelY.anchor = 13;
            gbcLabelY.insets = new Insets(5, 5, 5, 5);
            gbcLabelY.gridx = 0;
            gbcLabelY.gridy = 11;
            this.add((Component)jLabelY, gbcLabelY);
            JLabel jLabelTo3 = new JLabel("to");
            jLabelTo3.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelTo3 = new GridBagConstraints();
            gbcLabelTo3.insets = new Insets(5, 5, 5, 5);
            gbcLabelTo3.gridx = 2;
            gbcLabelTo3.gridy = 12;
            this.add((Component)jLabelTo3, gbcLabelTo3);
            this.tfYStart = new JFormattedTextField((Object)0);
            this.tfYStart.setEnabled(false);
            this.tfYStart.setHorizontalAlignment(0);
            this.tfYStart.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfYStart.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldYStart = new GridBagConstraints();
            gbcTextFieldYStart.fill = 2;
            gbcTextFieldYStart.anchor = 11;
            gbcTextFieldYStart.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldYStart.gridx = 1;
            gbcTextFieldYStart.gridy = 11;
            this.add((Component)this.tfYStart, gbcTextFieldYStart);
            JLabel jLabelTo2 = new JLabel("to");
            jLabelTo2.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelTo2 = new GridBagConstraints();
            gbcLabelTo2.insets = new Insets(5, 5, 5, 5);
            gbcLabelTo2.gridx = 2;
            gbcLabelTo2.gridy = 11;
            this.add((Component)jLabelTo2, gbcLabelTo2);
            JLabel jLabelZ = new JLabel("Z");
            jLabelZ.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelZ = new GridBagConstraints();
            gbcLabelZ.anchor = 13;
            gbcLabelZ.insets = new Insets(5, 5, 5, 5);
            gbcLabelZ.gridx = 0;
            gbcLabelZ.gridy = 12;
            this.add((Component)jLabelZ, gbcLabelZ);
            this.tfYEnd = new JFormattedTextField((Object)0);
            this.tfYEnd.setEnabled(false);
            this.tfYEnd.setHorizontalAlignment(0);
            this.tfYEnd.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfYEnd.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldYEnd = new GridBagConstraints();
            gbcTextFieldYEnd.fill = 2;
            gbcTextFieldYEnd.anchor = 11;
            gbcTextFieldYEnd.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldYEnd.gridx = 3;
            gbcTextFieldYEnd.gridy = 11;
            this.add((Component)this.tfYEnd, gbcTextFieldYEnd);
            this.tfZStart = new JFormattedTextField((Object)0);
            GuiUtils.selectAllOnFocus(this.tfZStart);
            this.tfZStart.setHorizontalAlignment(0);
            this.tfZStart.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfZStart.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldZStart = new GridBagConstraints();
            gbcTextFieldZStart.fill = 2;
            gbcTextFieldZStart.anchor = 11;
            gbcTextFieldZStart.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldZStart.gridx = 1;
            gbcTextFieldZStart.gridy = 12;
            this.add((Component)this.tfZStart, gbcTextFieldZStart);
            this.tfZEnd = new JFormattedTextField((Object)0);
            GuiUtils.selectAllOnFocus(this.tfZEnd);
            this.tfZEnd.setHorizontalAlignment(0);
            this.tfZEnd.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfZEnd.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldZEnd = new GridBagConstraints();
            gbcTextFieldZEnd.fill = 2;
            gbcTextFieldZEnd.anchor = 11;
            gbcTextFieldZEnd.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldZEnd.gridx = 3;
            gbcTextFieldZEnd.gridy = 12;
            this.add((Component)this.tfZEnd, gbcTextFieldZEnd);
            this.tfTStart = new JFormattedTextField((Object)0);
            GuiUtils.selectAllOnFocus(this.tfTStart);
            this.tfTStart.setHorizontalAlignment(0);
            this.tfTStart.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfTStart.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldTStart = new GridBagConstraints();
            gbcTextFieldTStart.fill = 2;
            gbcTextFieldTStart.anchor = 11;
            gbcTextFieldTStart.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldTStart.gridx = 1;
            gbcTextFieldTStart.gridy = 13;
            this.add((Component)this.tfTStart, gbcTextFieldTStart);
            JLabel jLabelT = new JLabel("T");
            jLabelT.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelT = new GridBagConstraints();
            gbcLabelT.anchor = 13;
            gbcLabelT.insets = new Insets(5, 5, 5, 5);
            gbcLabelT.gridx = 0;
            gbcLabelT.gridy = 13;
            this.add((Component)jLabelT, gbcLabelT);
            this.tfTEnd = new JFormattedTextField((Object)0);
            GuiUtils.selectAllOnFocus(this.tfTEnd);
            this.tfTEnd.setHorizontalAlignment(0);
            this.tfTEnd.setPreferredSize(Fonts.TEXTFIELD_DIMENSION);
            this.tfTEnd.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcTextFieldTEnd = new GridBagConstraints();
            gbcTextFieldTEnd.fill = 2;
            gbcTextFieldTEnd.anchor = 11;
            gbcTextFieldTEnd.insets = new Insets(5, 5, 5, 5);
            gbcTextFieldTEnd.gridx = 3;
            gbcTextFieldTEnd.gridy = 13;
            this.add((Component)this.tfTEnd, gbcTextFieldTEnd);
            JLabel jLabelTo4 = new JLabel("to");
            jLabelTo4.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLabelTo4 = new GridBagConstraints();
            gbcLabelTo4.insets = new Insets(5, 5, 5, 5);
            gbcLabelTo4.gridx = 2;
            gbcLabelTo4.gridy = 13;
            this.add((Component)jLabelTo4, gbcLabelTo4);
            JButton btnRefreshROI = new JButton("Refresh ROI");
            btnRefreshROI.setToolTipText(TOOLTIP);
            btnRefreshROI.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcButtonRefresh = new GridBagConstraints();
            gbcButtonRefresh.anchor = 18;
            gbcButtonRefresh.insets = new Insets(5, 5, 5, 5);
            gbcButtonRefresh.gridwidth = 4;
            gbcButtonRefresh.gridx = 0;
            gbcButtonRefresh.gridy = 14;
            this.add((Component)btnRefreshROI, gbcButtonRefresh);
            btnRefreshROI.addActionListener(new ActionListener(){
                final /* synthetic */ RoiSettingsPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Roi roi = imp.getRoi();
                    if (null == roi) {
                        roi = new Roi(0, 0, imp.getWidth(), imp.getHeight());
                    }
                    Rectangle boundingRect = roi.getBounds();
                    this.this$0.tfXStart.setValue(boundingRect.x);
                    this.this$0.tfYStart.setValue(boundingRect.y);
                    this.this$0.tfXEnd.setValue(boundingRect.width + boundingRect.x - 1);
                    this.this$0.tfYEnd.setValue(boundingRect.height + boundingRect.y - 1);
                    this.this$0.tfZStart.setValue(0);
                    this.this$0.tfZEnd.setValue(imp.getNSlices() - 1);
                    this.this$0.tfTStart.setValue(0);
                    this.this$0.tfTEnd.setValue(imp.getNFrames() - 1);
                }
            });
            Calibration cal = imp.getCalibration();
            lblPixelWidthVal.setText(DOUBLE_FORMAT.format(cal.pixelWidth));
            lblPixelHeightVal.setText(DOUBLE_FORMAT.format(cal.pixelHeight));
            lblVoxelDepthVal.setText(DOUBLE_FORMAT.format(cal.pixelDepth));
            if (cal.frameInterval == 0.0) {
                cal.frameInterval = 1.0;
                cal.setTimeUnit("frame");
                lblTimeIntervalVal.setText(DOUBLE_FORMAT.format(1.0));
                lblTimeUnits.setText("frame");
            } else {
                lblTimeIntervalVal.setText(DOUBLE_FORMAT.format(cal.frameInterval));
                lblTimeUnits.setText(cal.getTimeUnit());
            }
            lblSpatialUnits1.setText(cal.getXUnit());
            lblSpatialUnits2.setText(cal.getYUnit());
            lblSpatialUnits3.setText(cal.getZUnit());
            btnRefreshROI.doClick();
        }
    }
}

