/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.io;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.graph.ConvexBranchesDecomposition;
import fiji.plugin.trackmate.io.TmXmlReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.imglib2.algorithm.Algorithm;
import net.imglib2.algorithm.Benchmark;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class IcyTrackFormatWriter
implements Algorithm,
Benchmark {
    private static final String BASE_ERROR_MSG = "[ICYTrackFormatWriter] ";
    private static final String ROOT_ELEMENT = "root";
    private static final String TRACK_FILE = "trackfile";
    private static final String TRACK_GROUP = "trackgroup";
    private static final String TRACK = "track";
    private static final String DETECTION = "detection";
    private static final String LINK_LIST = "linklist";
    private static final String LINK = "link";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private final File file;
    private final Model model;
    private long processingTime;
    private String errorMessage;
    private final double[] calibration;
    private final String description;

    public IcyTrackFormatWriter(File file, Model model, double[] calibration) {
        this(file, model, calibration, null);
    }

    public IcyTrackFormatWriter(File file, Model model, double[] calibration, String description) {
        this.file = file;
        this.model = model;
        this.calibration = calibration;
        this.description = description;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean checkInput() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.errorMessage = BASE_ERROR_MSG + e.getMessage();
                return false;
            }
        }
        if (!this.file.canWrite()) {
            this.errorMessage = "[ICYTrackFormatWriter] Cannot write to " + String.valueOf(this.file) + ".\n";
            return false;
        }
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        ConvexBranchesDecomposition splitter = new ConvexBranchesDecomposition(this.model, true, true);
        if (!splitter.checkInput() || !splitter.process()) {
            this.errorMessage = splitter.getErrorMessage();
            return false;
        }
        Element root = new Element(ROOT_ELEMENT);
        Element trackFile = new Element(TRACK_FILE);
        trackFile.setAttribute("version", "1");
        root.addContent((Content)trackFile);
        Element trackGroup = new Element(TRACK_GROUP);
        if (null != this.description && !this.description.isEmpty()) {
            trackGroup.setAttribute(DESCRIPTION_ATTRIBUTE, this.description);
        }
        HashMap<Spot, Integer> beginnings = new HashMap<Spot, Integer>();
        HashMap<Spot, Integer> endings = new HashMap<Spot, Integer>();
        Collection<List<Spot>> branches = splitter.getBranches();
        for (List<Spot> branch : branches) {
            int branchID = branch.hashCode();
            beginnings.put(branch.get(0), branchID);
            endings.put(branch.get(branch.size() - 1), branchID);
            Element track = new Element(TRACK);
            track.setAttribute("id", "" + branchID);
            for (Spot spot : branch) {
                double x = spot.getDoublePosition(0) / this.calibration[0];
                double y = spot.getDoublePosition(1) / this.calibration[1];
                int z = (int)(spot.getDoublePosition(2) / this.calibration[2]);
                int t = spot.getFeature("FRAME").intValue();
                Element detection = new Element(DETECTION);
                detection.setAttribute("t", Integer.toString(t));
                detection.setAttribute("x", "" + x);
                detection.setAttribute("y", "" + y);
                detection.setAttribute("z", Integer.toString(z));
                detection.setAttribute("classname", "plugins.nchenouard.particleTracking.sequenceGenerator.ProfileSpotTrack");
                detection.setAttribute("type", "1");
                track.addContent((Content)detection);
            }
            trackGroup.addContent((Content)track);
        }
        root.addContent((Content)trackGroup);
        Element linklist = new Element(LINK_LIST);
        Collection<List<Spot>> links = splitter.getLinks();
        for (List<Spot> link : links) {
            Spot spotA = link.get(0);
            Spot spotB = link.get(1);
            int from = (Integer)endings.get(spotA);
            int to = (Integer)beginnings.get(spotB);
            Element linkEl = new Element(LINK);
            linkEl.setAttribute("from", "" + from);
            linkEl.setAttribute("to", "" + to);
            linklist.addContent((Content)linkEl);
        }
        root.addContent((Content)linklist);
        Document document = new Document(root);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(document, (OutputStream)new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            this.errorMessage = e.getMessage();
            return false;
        }
        catch (IOException e) {
            this.errorMessage = e.getMessage();
            return false;
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static void main(String[] args) throws JDOMException, IOException {
        double[] calibration;
        File target = new File("/Users/tinevez/Desktop/IcyConverstion.xml");
        File source = new File("/Users/tinevez/Projects/JYTinevez/CelegansLineage/Data/LSM700U/10-03-17-3hours_bis.xml");
        TmXmlReader reader = new TmXmlReader(source);
        Model model = reader.getModel();
        IcyTrackFormatWriter exporter = new IcyTrackFormatWriter(target, model, calibration = IcyTrackFormatWriter.readCalibration(source));
        if (!exporter.checkInput() || !exporter.process()) {
            System.out.println(exporter.getErrorMessage());
        } else {
            System.out.println("Export done in " + exporter.getProcessingTime() + " ms.");
        }
    }

    private static double[] readCalibration(File source) throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder();
        Document document = sb.build(source);
        Element root = document.getRootElement();
        double[] calibration = new double[3];
        Element settings = root.getChild("Settings");
        Element imageData = settings.getChild("ImageData");
        calibration[0] = imageData.getAttribute("pixelwidth").getDoubleValue();
        calibration[1] = imageData.getAttribute("pixelheight").getDoubleValue();
        calibration[2] = imageData.getAttribute("voxeldepth").getDoubleValue();
        return calibration;
    }
}

