/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import java.awt.Component;
import java.awt.Container;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class EverythingDisablerAndReenabler {
    private final Container rootContainerForWhatShouldBeDisabled;
    private final Class<?>[] componentClassesToBeIgnored;
    private final List<WeakReference<Component>> componentsToReenable = new ArrayList<WeakReference<Component>>();
    private boolean disableHasBeenCalled = false;

    public EverythingDisablerAndReenabler(Container rootContainerForWhatShouldBeDisabled, Class<?>[] componentClassesToBeIgnored) {
        if (rootContainerForWhatShouldBeDisabled == null) {
            throw new IllegalArgumentException();
        }
        this.rootContainerForWhatShouldBeDisabled = rootContainerForWhatShouldBeDisabled;
        this.componentClassesToBeIgnored = componentClassesToBeIgnored;
    }

    public void setEnabled(boolean enable) {
        if (enable && this.disableHasBeenCalled) {
            this.reenable();
        } else if (!enable && !this.disableHasBeenCalled) {
            this.disable();
        }
    }

    public void disable() {
        if (this.disableHasBeenCalled) {
            throw new IllegalStateException();
        }
        this.disableHasBeenCalled = true;
        this.componentsToReenable.clear();
        this.disableEverythingInsideThisHierarchically(this.rootContainerForWhatShouldBeDisabled);
    }

    public void reenable() {
        if (!this.disableHasBeenCalled) {
            throw new IllegalStateException();
        }
        this.disableHasBeenCalled = false;
        for (int i = this.componentsToReenable.size() - 1; i >= 0; --i) {
            Optional.ofNullable((Component)this.componentsToReenable.get(i).get()).ifPresent(c -> c.setEnabled(true));
        }
        this.componentsToReenable.clear();
    }

    private void disableEverythingInsideThisHierarchically(Container container) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (component == null) continue;
            if (component instanceof Container) {
                this.disableEverythingInsideThisHierarchically((Container)component);
            }
            if (!component.isEnabled()) continue;
            boolean found = false;
            if (this.componentClassesToBeIgnored != null) {
                for (Class<?> cls : this.componentClassesToBeIgnored) {
                    if (component.getClass() != cls) continue;
                    found = true;
                    break;
                }
            }
            if (found || !component.isEnabled()) continue;
            component.setEnabled(false);
            this.componentsToReenable.add(new WeakReference<Component>(component));
        }
    }
}

