/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;

abstract class NewGeneralEvD<N extends Number>
extends EigenvalueDecomposition<N> {
    protected NewGeneralEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public final N getDeterminant() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().product();
        this.getEigenvalues().visitAll(tmpVisitor);
        return this.scalar().cast((Number)tmpVisitor.get());
    }

    public MatrixStore<N> getInverse() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return null;
    }

    public MatrixStore<N> getInverse(DecompositionStore<N> newPreallocated) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return null;
    }

    @Override
    public final ComplexNumber getTrace() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().sum();
        this.getEigenvalues().visitAll(tmpVisitor);
        return (ComplexNumber)tmpVisitor.get();
    }

    @Override
    public final boolean isHermitian() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    protected boolean checkSolvability() {
        return this.isComputed() && this.isHermitian();
    }

    @Override
    protected boolean doGeneral(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean eigenvaluesOnly) {
        int tmpDiagDim = (int)matrix.countRows();
        DecompositionStore tmpMtrxA = this.makeZero(tmpDiagDim, tmpDiagDim);
        matrix.supplyTo(tmpMtrxA);
        DecompositionStore tmpV = this.makeEye(tmpDiagDim, tmpDiagDim);
        Array1D<ComplexNumber> tmpEigenvalues = tmpMtrxA.computeInPlaceSchur(tmpV, true);
        this.setV(tmpV);
        this.setEigenvalues(tmpEigenvalues);
        DecompositionStore tmpD = this.makeZero(tmpDiagDim, tmpDiagDim);
        for (int ij = 0; ij < tmpDiagDim; ++ij) {
            ComplexNumber tmpValue = (ComplexNumber)tmpEigenvalues.get(ij);
            tmpD.set((long)ij, (long)ij, tmpValue.doubleValue());
            double tmpImaginary = tmpValue.i;
            if (tmpImaginary > PrimitiveMath.ZERO) {
                tmpD.set((long)ij, (long)(ij + 1), tmpImaginary);
                continue;
            }
            if (!(tmpImaginary < PrimitiveMath.ZERO)) continue;
            tmpD.set((long)ij, (long)(ij - 1), tmpImaginary);
        }
        this.setD(tmpD);
        tmpEigenvalues.sortDescending();
        return this.computed(true);
    }

    @Override
    protected boolean doHermitian(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean eigenvaluesOnly) {
        return this.doGeneral(matrix, eigenvaluesOnly);
    }

    @Override
    protected double getDimensionalEpsilon() {
        return (double)this.getD().countRows() * PrimitiveMath.MACHINE_EPSILON;
    }

    @Override
    protected final MatrixStore<N> makeD() {
        return null;
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        return null;
    }

    protected final MatrixStore<N> makeInverse() {
        MatrixStore tmpV = this.getV();
        MatrixStore tmpD = this.getD();
        int tmpDim = (int)tmpD.countRows();
        PhysicalStore tmpMtrx = tmpV.transpose().copy();
        Object tmpZero = this.scalar().zero().get();
        BinaryFunction tmpDivide = this.function().divide();
        for (int i = 0; i < tmpDim; ++i) {
            if (tmpD.isSmall(i, i, PrimitiveMath.ONE)) {
                tmpMtrx.fillRow((long)i, 0L, tmpZero);
                continue;
            }
            tmpMtrx.modifyRow(i, 0L, tmpDivide.second(tmpD.get(i, i)));
        }
        return tmpV.multiply(tmpMtrx);
    }

    @Override
    protected MatrixStore<N> makeV() {
        return null;
    }

    static final class Primitive
    extends NewGeneralEvD<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }
}

