/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.BasicArray;

final class Pivot {
    private boolean myModified = false;
    private final int[] myOrder;
    private int mySign;

    Pivot(int numberOfRows) {
        this.myOrder = BasicArray.makeIncreasingRange(0, numberOfRows);
        this.mySign = 1;
    }

    public void change(int row1, int row2) {
        if (row1 != row2) {
            int tmpRow = this.myOrder[row1];
            this.myOrder[row1] = this.myOrder[row2];
            this.myOrder[row2] = tmpRow;
            this.mySign = -this.mySign;
            this.myModified = true;
        }
    }

    public int[] getOrder() {
        return this.myOrder;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public int signum() {
        return this.mySign;
    }
}

