/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.operation.MultiplyBoth;

public interface ElementsConsumer<N extends Number>
extends Mutate2D.Receiver<N>,
Mutate2D.BiModifiable<N>,
Mutate2D.Modifiable<N> {
    public void fillByMultiplying(Access1D<N> var1, Access1D<N> var2);

    public ElementsConsumer<N> regionByColumns(int ... var1);

    public ElementsConsumer<N> regionByLimits(int var1, int var2);

    public ElementsConsumer<N> regionByOffsets(int var1, int var2);

    public ElementsConsumer<N> regionByRows(int ... var1);

    public ElementsConsumer<N> regionByTransposing();

    public static class TransposedRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;

        protected TransposedRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier) {
            super(multiplier, base.countColumns(), base.countRows());
            this.myBase = base;
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add(col, row, addend);
        }

        @Override
        public void add(long row, long col, Number addend) {
            this.myBase.add(col, row, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countRows();
        }

        @Override
        public long countRows() {
            return this.myBase.countColumns();
        }

        @Override
        public void fillColumn(long row, long col, N value) {
            this.myBase.fillRow(col, row, value);
        }

        @Override
        public void fillColumn(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillRow(col, row, supplier);
        }

        @Override
        public void fillDiagonal(long row, long col, N value) {
            this.myBase.fillDiagonal(col, row, value);
        }

        @Override
        public void fillDiagonal(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillRow(col, row, supplier);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(col, row, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne(col, row, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillOne(col, row, supplier);
        }

        @Override
        public void fillRow(long row, long col, N value) {
            this.myBase.fillDiagonal(col, row, value);
        }

        @Override
        public void fillRow(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillDiagonal(col, row, supplier);
        }

        @Override
        public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyRow(col, row, modifier);
        }

        @Override
        public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyDiagonal(col, row, modifier);
        }

        @Override
        public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
            this.myBase.modifyMatching(left, function);
        }

        @Override
        public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
            this.myBase.modifyMatching(function, right);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(col, row, modifier);
        }

        @Override
        public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyColumn(col, row, modifier);
        }

        @Override
        public ElementsConsumer<N> regionByTransposing() {
            return this.myBase;
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set(col, row, value);
        }

        @Override
        public void set(long row, long col, Number value) {
            this.myBase.set(col, row, value);
        }
    }

    public static class RowsRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int[] myRows;

        protected RowsRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int ... rows) {
            super(multiplier, rows.length, base.countColumns());
            this.myBase = base;
            this.myRows = rows;
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add((long)this.myRows[(int)row], col, addend);
        }

        @Override
        public void add(long row, long col, Number addend) {
            this.myBase.add((long)this.myRows[(int)row], col, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countColumns();
        }

        @Override
        public long countRows() {
            return this.myRows.length;
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(this.myRows[(int)row], col, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne((long)this.myRows[(int)row], col, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillOne((long)this.myRows[(int)row], col, supplier);
        }

        @Override
        public void fillRow(long row, long col, Access1D<N> values) {
            this.myBase.fillRow((long)this.myRows[(int)row], col, values);
        }

        @Override
        public void fillRow(long row, long col, N value) {
            this.myBase.fillRow((long)this.myRows[(int)row], col, value);
        }

        @Override
        public void fillRow(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillRow((long)this.myRows[(int)row], col, supplier);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(this.myRows[(int)row], col, modifier);
        }

        @Override
        public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyRow(this.myRows[(int)row], col, modifier);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set((long)this.myRows[(int)row], col, value);
        }

        @Override
        public void set(long row, long col, Number value) {
            this.myBase.set((long)this.myRows[(int)row], col, value);
        }
    }

    public static class OffsetRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int myRowOffset;
        private final int myColumnOffset;

        protected OffsetRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int rowOffset, int columnOffset) {
            super(multiplier, base.countRows() - (long)rowOffset, base.countColumns() - (long)columnOffset);
            this.myBase = base;
            this.myRowOffset = rowOffset;
            this.myColumnOffset = columnOffset;
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add((long)this.myRowOffset + row, (long)this.myColumnOffset + col, addend);
        }

        @Override
        public void add(long row, long col, Number addend) {
            this.myBase.add((long)this.myRowOffset + row, (long)this.myColumnOffset + col, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countColumns() - (long)this.myColumnOffset;
        }

        @Override
        public long countRows() {
            return this.myBase.countRows() - (long)this.myRowOffset;
        }

        @Override
        public void fillAll(N value) {
            long tmpCountColumns = this.myBase.countColumns();
            for (long j = (long)this.myColumnOffset; j < tmpCountColumns; ++j) {
                this.myBase.fillColumn((long)this.myRowOffset, j, value);
            }
        }

        @Override
        public void fillAll(NullaryFunction<N> supplier) {
            long tmpCountColumns = this.myBase.countColumns();
            for (long j = (long)this.myColumnOffset; j < tmpCountColumns; ++j) {
                this.myBase.fillColumn((long)this.myRowOffset, j, supplier);
            }
        }

        @Override
        public void fillColumn(long row, long col, N value) {
            this.myBase.fillColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillColumn(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public void fillDiagonal(long row, long col, N value) {
            this.myBase.fillDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillDiagonal(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public void fillRow(long row, long col, N value) {
            this.myBase.fillRow((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillRow(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillRow((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public void modifyAll(UnaryFunction<N> modifier) {
            for (long j = (long)this.myColumnOffset; j < this.myBase.countColumns(); ++j) {
                this.myBase.modifyColumn(this.myRowOffset, j, modifier);
            }
        }

        @Override
        public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyRow((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void set(long row, long col, Number value) {
            this.myBase.set((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }
    }

    public static class LimitRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int myRowLimit;
        private final int myColumnLimit;

        protected LimitRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int rowLimit, int columnLimit) {
            super(multiplier, rowLimit, columnLimit);
            this.myBase = base;
            this.myRowLimit = rowLimit;
            this.myColumnLimit = columnLimit;
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add(row, col, addend);
        }

        @Override
        public void add(long row, long col, Number addend) {
            this.myBase.add(row, col, addend);
        }

        @Override
        public long countColumns() {
            return this.myColumnLimit;
        }

        @Override
        public long countRows() {
            return this.myRowLimit;
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(row, col, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne(row, col, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillOne(row, col, supplier);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(row, col, modifier);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set(row, col, value);
        }

        @Override
        public void set(long row, long col, Number value) {
            this.myBase.set(row, col, value);
        }
    }

    public static interface FillByMultiplying<N extends Number> {
        public void invoke(ElementsConsumer<N> var1, Access1D<N> var2, int var3, Access1D<N> var4);
    }

    public static abstract class ConsumerRegion<N extends Number>
    implements ElementsConsumer<N> {
        private final FillByMultiplying<N> myMultiplier;

        private ConsumerRegion() {
            this(null, 0L, 0L);
        }

        protected ConsumerRegion(FillByMultiplying<N> multiplier, long rows, long columns) {
            this.myMultiplier = multiplier instanceof PrimitiveDenseStore.PrimitiveMultiplyBoth ? MultiplyBoth.getPrimitive(rows, columns) : (multiplier instanceof GenericDenseStore.GenericMultiplyBoth ? MultiplyBoth.getGeneric(rows, columns) : (multiplier instanceof BigDenseStore.BigMultiplyBoth ? MultiplyBoth.getBig(rows, columns) : multiplier));
        }

        @Override
        public final void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
            this.myMultiplier.invoke(this, left, (int)(left.count() / this.countRows()), right);
        }

        @Override
        public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
            long tmpLimit = FunctionUtils.min(left.count(), this.count());
            for (long i = 0L; i < tmpLimit; ++i) {
                this.modifyOne(i, function.first(left.get(i)));
            }
        }

        @Override
        public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
            long tmpLimit = FunctionUtils.min(this.count(), right.count());
            for (long i = 0L; i < tmpLimit; ++i) {
                this.modifyOne(i, function.second(right.get(i)));
            }
        }

        @Override
        public final ElementsConsumer<N> regionByColumns(int ... columns) {
            return new ColumnsRegion<N>(this, this.myMultiplier, columns);
        }

        @Override
        public final ElementsConsumer<N> regionByLimits(int rowLimit, int columnLimit) {
            return new LimitRegion<N>(this, this.myMultiplier, rowLimit, columnLimit);
        }

        @Override
        public final ElementsConsumer<N> regionByOffsets(int rowOffset, int columnOffset) {
            return new OffsetRegion<N>(this, this.myMultiplier, rowOffset, columnOffset);
        }

        @Override
        public final ElementsConsumer<N> regionByRows(int ... rows) {
            return new RowsRegion<N>(this, this.myMultiplier, rows);
        }

        @Override
        public ElementsConsumer<N> regionByTransposing() {
            return new TransposedRegion<N>(this, this.myMultiplier);
        }

        public String toString() {
            return super.toString() + " " + this.countRows() + " x " + this.countColumns();
        }
    }

    public static class ColumnsRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int[] myColumns;

        protected ColumnsRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int ... columns) {
            super(multiplier, base.countRows(), columns.length);
            this.myBase = base;
            this.myColumns = columns;
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add(row, (long)this.myColumns[(int)col], addend);
        }

        @Override
        public void add(long row, long col, Number addend) {
            this.myBase.add(row, (long)this.myColumns[(int)col], addend);
        }

        @Override
        public long countColumns() {
            return this.myColumns.length;
        }

        @Override
        public long countRows() {
            return this.myBase.countRows();
        }

        @Override
        public void fillColumn(long row, long col, Access1D<N> values) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)col], values);
        }

        @Override
        public void fillColumn(long row, long col, N value) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)col], value);
        }

        @Override
        public void fillColumn(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)col], supplier);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(row, this.myColumns[(int)col], values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne(row, (long)this.myColumns[(int)col], value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<N> supplier) {
            this.myBase.fillOne(row, (long)this.myColumns[(int)col], supplier);
        }

        @Override
        public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyColumn(row, this.myColumns[(int)col], modifier);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(row, this.myColumns[(int)col], modifier);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set(row, (long)this.myColumns[(int)col], value);
        }

        @Override
        public void set(long row, long col, Number value) {
            this.myBase.set(row, (long)this.myColumns[(int)col], value);
        }
    }
}

