/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data;

import java.io.File;
import java.io.OutputStream;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePointsPattern;
import mpicbg.spim.data.sequence.ViewSetup;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class SpimDataExample {
    public static void main(String[] args) throws Exception {
        String xmlFilename = ClassLoader.getSystemResource("example_timepointpattern.xml").getPath();
        XmlIoSpimData io = new XmlIoSpimData();
        SpimData spimData = (SpimData)io.load(xmlFilename);
        System.out.println("Num Timepoints: " + ((SequenceDescription)spimData.getSequenceDescription()).getTimePoints().size());
        if (((SequenceDescription)spimData.getSequenceDescription()).getTimePoints() instanceof TimePointsPattern) {
            System.out.println(((TimePointsPattern)((SequenceDescription)spimData.getSequenceDescription()).getTimePoints()).getPattern());
        }
        for (TimePoint t : ((SequenceDescription)spimData.getSequenceDescription()).getTimePoints().getTimePointsOrdered()) {
            System.out.println("\nTimepoint: " + t.getId());
            for (ViewSetup setup : ((SequenceDescription)spimData.getSequenceDescription()).getViewSetupsOrdered()) {
                System.out.println("Setup: " + setup.getId());
                if (setup.hasName()) {
                    System.out.println(setup.getName());
                }
                System.out.println(spimData.getViewRegistrations().getViewRegistration(t.getId(), setup.getId()).getModel());
            }
        }
        io.save(spimData, "example_new.xml");
        Document doc = new Document(io.toXml(spimData, new File(".")));
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (OutputStream)System.out);
    }
}

