/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.SpimDataIOException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.XmlIoSingleton;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.XmlIoAbstractSequenceDescription;
import mpicbg.spim.data.registration.XmlIoViewRegistrations;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlIoAbstractSpimData<S extends AbstractSequenceDescription<?, ?, ?>, T extends AbstractSpimData<S>>
extends XmlIoSingleton<T> {
    private final XmlIoAbstractSequenceDescription<?, S> xmlIoSequenceDescription;
    private final XmlIoViewRegistrations xmlIoViewRegistrations;

    public XmlIoAbstractSpimData(Class<T> klass, XmlIoAbstractSequenceDescription<?, S> xmlIoSequenceDescription, XmlIoViewRegistrations xmlIoViewRegistrations) {
        super("SpimData", klass);
        this.xmlIoSequenceDescription = xmlIoSequenceDescription;
        this.xmlIoViewRegistrations = xmlIoViewRegistrations;
        this.handledTags.add(xmlIoSequenceDescription.getTag());
        this.handledTags.add(xmlIoViewRegistrations.getTag());
        this.handledTags.add("BasePath");
    }

    public T load(String xmlFilename) throws SpimDataException {
        try {
            File file = new File(xmlFilename);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            return this.load(reader, file.toURI());
        }
        catch (IOException e) {
            throw new SpimDataIOException(e);
        }
    }

    public T load(Reader xmlReader, URI xmlURI) throws SpimDataException {
        Document doc;
        SAXBuilder sax = new SAXBuilder();
        try {
            doc = sax.build(xmlReader);
        }
        catch (Exception e) {
            throw new SpimDataIOException(e);
        }
        Element root = doc.getRootElement();
        if (!Objects.equals(root.getName(), "SpimData")) {
            throw new RuntimeException("expected <SpimData> root element. wrong file?");
        }
        return this.fromXml(root, xmlURI);
    }

    public void save(T spimData, String xmlFilename) throws SpimDataException {
        try (FileWriter writer = new FileWriter(xmlFilename);){
            this.save(spimData, writer, new File(xmlFilename).toURI());
        }
        catch (IOException e) {
            throw new SpimDataIOException(e);
        }
    }

    public void save(T spimData, Writer xmlWriter, URI xmlURI) throws SpimDataException {
        URI basePathURI = XmlIoAbstractSpimData.getParent(xmlURI);
        Document doc = new Document(this.toXml(spimData, basePathURI));
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        try {
            xout.output(doc, xmlWriter);
        }
        catch (IOException e) {
            throw new SpimDataIOException(e);
        }
    }

    public String getVersion(Element root) {
        String version;
        String versionAttr = root.getAttributeValue("version");
        if (versionAttr.isEmpty()) {
            System.out.println("<SpimData> does not specify \"version\" attribute.");
            System.out.println("assuming \"0.2\"");
            version = "0.2";
        } else {
            version = versionAttr;
        }
        return version;
    }

    public T fromXml(Element root, File xmlFile) throws SpimDataException {
        return this.fromXml(root, xmlFile.toURI());
    }

    public T fromXml(Element root, URI xmlURI) throws SpimDataException {
        AbstractSpimData spimData = (AbstractSpimData)super.fromXml(root);
        URI basePathURI = this.loadBasePathURI(root, xmlURI);
        spimData.setBasePathURI(basePathURI);
        Element elem = root.getChild(this.xmlIoSequenceDescription.getTag());
        if (elem == null) {
            throw new SpimDataIOException("no <" + this.xmlIoSequenceDescription.getTag() + "> element found.");
        }
        spimData.setSequenceDescription(this.xmlIoSequenceDescription.fromXml(elem, basePathURI));
        elem = root.getChild(this.xmlIoViewRegistrations.getTag());
        if (elem == null) {
            throw new SpimDataIOException("no <" + this.xmlIoViewRegistrations.getTag() + "> element found.");
        }
        spimData.setViewRegistrations(this.xmlIoViewRegistrations.fromXml(elem));
        return (T)spimData;
    }

    protected URI loadBasePathURI(Element root, URI xmlURI) throws SpimDataIOException {
        URI parent = XmlIoAbstractSpimData.getParent(xmlURI);
        return XmlHelpers.loadPathURI(root, "BasePath", ".", parent);
    }

    private static URI getParent(URI uri) throws SpimDataIOException {
        try {
            String uriPath = uri.getPath();
            int parentSlash = uriPath.lastIndexOf("/", uriPath.length() - 2);
            if (parentSlash < 0) {
                throw new SpimDataIOException("URI is already at the root");
            }
            String parentPath = uriPath.substring(0, parentSlash + 1);
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), parentPath, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new SpimDataIOException(e);
        }
    }

    public Element toXml(T spimData, File xmlFileDirectory) throws SpimDataException {
        return this.toXml(spimData, xmlFileDirectory.toURI());
    }

    public Element toXml(T spimData, URI xmlParentURI) throws SpimDataException {
        Element root = super.toXml();
        root.setAttribute("version", "0.2");
        root.addContent((Content)XmlHelpers.pathElementURI("BasePath", ((AbstractSpimData)spimData).getBasePathURI(), xmlParentURI));
        root.addContent((Content)this.xmlIoSequenceDescription.toXml(((AbstractSpimData)spimData).getSequenceDescription(), ((AbstractSpimData)spimData).getBasePathURI()));
        root.addContent((Content)this.xmlIoViewRegistrations.toXml(((AbstractSpimData)spimData).getViewRegistrations()));
        return root;
    }
}

