/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.Tile;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;

public class SequenceDescription
extends AbstractSequenceDescription<ViewSetup, ViewDescription, ImgLoader> {
    public SequenceDescription(TimePoints timepoints, Map<Integer, ViewSetup> setups) {
        this(timepoints, setups, null, null);
    }

    public SequenceDescription(TimePoints timepoints, Map<Integer, ViewSetup> setups, ImgLoader imgLoader) {
        this(timepoints, setups, imgLoader, (MissingViews)null);
    }

    public SequenceDescription(TimePoints timepoints, Map<Integer, ViewSetup> setups, ImgLoader imgLoader, MissingViews missingViews) {
        super(timepoints, setups, imgLoader, missingViews);
    }

    public SequenceDescription(TimePoints timepoints, Collection<ViewSetup> setups) {
        this(timepoints, Entity.idMap(setups));
    }

    public SequenceDescription(TimePoints timepoints, Collection<ViewSetup> setups, ImgLoader imgLoader) {
        this(timepoints, Entity.idMap(setups), imgLoader);
    }

    public SequenceDescription(TimePoints timepoints, Collection<ViewSetup> setups, ImgLoader imgLoader, MissingViews missingViews) {
        super(timepoints, Entity.idMap(setups), imgLoader, missingViews);
    }

    public ViewDescription getViewDescription(int timepointId, int setupId) {
        return (ViewDescription)this.getViewDescriptions().get(new ViewId(timepointId, setupId));
    }

    public ViewDescription getViewDescription(ViewId view) {
        return (ViewDescription)this.getViewDescriptions().get(view);
    }

    public Map<Integer, Tile> getAllTiles() {
        HashMap<Integer, Tile> tiles = new HashMap<Integer, Tile>();
        for (ViewSetup setup : this.getViewSetups().values()) {
            Tile t = setup.getTile();
            tiles.put(t.getId(), t);
        }
        return tiles;
    }

    public List<Tile> getAllTilesOrdered() {
        return Entity.sortById(new ArrayList<Tile>(this.getAllTiles().values()));
    }

    public Map<Integer, Channel> getAllChannels() {
        HashMap<Integer, Channel> channels = new HashMap<Integer, Channel>();
        for (ViewSetup setup : this.getViewSetups().values()) {
            Channel c = setup.getChannel();
            channels.put(c.getId(), c);
        }
        return channels;
    }

    public List<Channel> getAllChannelsOrdered() {
        return Entity.sortById(new ArrayList<Channel>(this.getAllChannels().values()));
    }

    public Map<Integer, Illumination> getAllIlluminations() {
        HashMap<Integer, Illumination> illuminations = new HashMap<Integer, Illumination>();
        for (ViewSetup setup : this.getViewSetups().values()) {
            Illumination c = setup.getIllumination();
            illuminations.put(c.getId(), c);
        }
        return illuminations;
    }

    public List<Illumination> getAllIlluminationsOrdered() {
        return Entity.sortById(new ArrayList<Illumination>(this.getAllIlluminations().values()));
    }

    public Map<Integer, Angle> getAllAngles() {
        HashMap<Integer, Angle> angles = new HashMap<Integer, Angle>();
        for (ViewSetup setup : this.getViewSetups().values()) {
            Angle c = setup.getAngle();
            angles.put(c.getId(), c);
        }
        return angles;
    }

    public List<Angle> getAllAnglesOrdered() {
        return Entity.sortById(new ArrayList<Angle>(this.getAllAngles().values()));
    }

    @Override
    protected ViewDescription createViewDescription(int timepointId, int setupId) {
        return new ViewDescription(timepointId, setupId, true, this);
    }

    protected SequenceDescription() {
    }
}

