/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.util.LinAlgHelpers;

public class HomographyTransform2D
implements InvertibleRealTransform {
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m02 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m20 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;
    protected double i00 = 1.0;
    protected double i01 = 0.0;
    protected double i02 = 0.0;
    protected double i10 = 0.0;
    protected double i11 = 1.0;
    protected double i12 = 0.0;
    protected double i20 = 0.0;
    protected double i21 = 0.0;
    protected double i22 = 1.0;

    public void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.invert();
    }

    private final void invert() {
        double det = LinAlgHelpers.det3x3((double)this.m00, (double)this.m01, (double)this.m02, (double)this.m10, (double)this.m11, (double)this.m12, (double)this.m20, (double)this.m21, (double)this.m22);
        this.i00 = (this.m11 * this.m22 - this.m12 * this.m21) / det;
        this.i01 = (this.m02 * this.m21 - this.m01 * this.m22) / det;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) / det;
        this.i10 = (this.m12 * this.m20 - this.m10 * this.m22) / det;
        this.i11 = (this.m00 * this.m22 - this.m02 * this.m20) / det;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) / det;
        this.i20 = (this.m10 * this.m21 - this.m11 * this.m20) / det;
        this.i21 = (this.m01 * this.m20 - this.m00 * this.m21) / det;
        this.i22 = (this.m00 * this.m11 - this.m01 * this.m10) / det;
    }

    @Override
    public final void apply(double[] source, double[] target) {
        assert (source.length >= 2 && source.length >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.m20 * source[0] + this.m21 * source[1] + this.m22;
        double t0 = this.m00 * source[0] + this.m01 * source[1] + this.m02;
        double t1 = this.m10 * source[0] + this.m11 * source[1] + this.m12;
        target[0] = t0 / s;
        target[1] = t1 / s;
    }

    @Override
    public final void apply(float[] source, float[] target) {
        assert (source.length >= 2 && source.length >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.m20 * (double)source[0] + this.m21 * (double)source[1] + this.m22;
        double t0 = this.m00 * (double)source[0] + this.m01 * (double)source[1] + this.m02;
        double t1 = this.m10 * (double)source[0] + this.m11 * (double)source[1] + this.m12;
        target[0] = (float)(t0 / s);
        target[1] = (float)(t1 / s);
    }

    @Override
    public final void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= 2 && source.numDimensions() >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.m20 * source.getDoublePosition(0) + this.m21 * source.getDoublePosition(1) + this.m22;
        double t0 = this.m00 * source.getDoublePosition(0) + this.m01 * source.getDoublePosition(1) + this.m02;
        double t1 = this.m10 * source.getDoublePosition(0) + this.m11 * source.getDoublePosition(1) + this.m12;
        target.setPosition(t0 / s, 0);
        target.setPosition(t1 / s, 1);
    }

    @Override
    public final void applyInverse(double[] source, double[] target) {
        assert (source.length >= 2 && source.length >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.i20 * target[0] + this.i21 * target[1] + this.i22;
        double t0 = this.i00 * target[0] + this.i01 * target[1] + this.i02;
        double t1 = this.i10 * target[0] + this.i11 * target[1] + this.i12;
        source[0] = t0 / s;
        source[1] = t1 / s;
    }

    @Override
    public final void applyInverse(float[] source, float[] target) {
        assert (source.length >= 2 && source.length >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.i20 * (double)target[0] + this.i21 * (double)target[1] + this.i22;
        double t0 = this.i00 * (double)target[0] + this.i01 * (double)target[1] + this.i02;
        double t1 = this.i10 * (double)target[0] + this.i11 * (double)target[1] + this.i12;
        source[0] = (float)(t0 / s);
        source[1] = (float)(t1 / s);
    }

    @Override
    public final void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= 2 && source.numDimensions() >= 2) : "2d homographies can be applied to 2d points only.";
        double s = this.i20 * target.getDoublePosition(0) + this.i21 * target.getDoublePosition(1) + this.i22;
        double t0 = this.i00 * target.getDoublePosition(0) + this.i01 * target.getDoublePosition(1) + this.i02;
        double t1 = this.i10 * target.getDoublePosition(0) + this.i11 * target.getDoublePosition(1) + this.i12;
        source.setPosition(t0 / s, 0);
        source.setPosition(t1 / s, 1);
    }

    public final void set(HomographyTransform2D m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.i00 = m.i00;
        this.i01 = m.i01;
        this.i02 = m.i02;
        this.i10 = m.i10;
        this.i11 = m.i11;
        this.i12 = m.i12;
        this.i20 = m.i20;
        this.i21 = m.i21;
        this.i22 = m.i22;
    }

    @Override
    public HomographyTransform2D copy() {
        HomographyTransform2D m = new HomographyTransform2D();
        m.m00 = this.m00;
        m.m01 = this.m01;
        m.m02 = this.m02;
        m.m10 = this.m10;
        m.m11 = this.m11;
        m.m12 = this.m12;
        m.m20 = this.m20;
        m.m21 = this.m21;
        m.m22 = this.m22;
        m.i00 = this.i00;
        m.i01 = this.i01;
        m.i02 = this.i02;
        m.i10 = this.i10;
        m.i11 = this.i11;
        m.i12 = this.i12;
        m.i20 = this.i20;
        m.i21 = this.i21;
        m.i22 = this.i22;
        return m;
    }

    public String toString() {
        return "[[ " + this.m00 + " " + this.m01 + " " + this.m02 + " ], [ " + this.m10 + " " + this.m11 + " " + this.m12 + " ], [ " + this.m20 + " " + this.m21 + " " + this.m22 + " ]]";
    }

    @Override
    public final HomographyTransform2D inverse() {
        HomographyTransform2D m = new HomographyTransform2D();
        m.m00 = this.i00;
        m.m01 = this.i01;
        m.m02 = this.i02;
        m.m10 = this.i00;
        m.m11 = this.i11;
        m.m12 = this.i12;
        m.m20 = this.i20;
        m.m21 = this.i21;
        m.m22 = this.i22;
        m.i00 = this.m00;
        m.i01 = this.m01;
        m.i02 = this.m02;
        m.i10 = this.m00;
        m.i11 = this.m11;
        m.i12 = this.m12;
        m.i20 = this.m20;
        m.i21 = this.m21;
        m.i22 = this.m22;
        return m;
    }

    @Override
    public int numSourceDimensions() {
        return 2;
    }

    @Override
    public int numTargetDimensions() {
        return 2;
    }
}

