/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;

public class PolarToCartesianTransform2D
implements InvertibleRealTransform {
    private final InverseRealTransform inverse = new InverseRealTransform(this);

    private static double x(double r, double t) {
        return r * Math.cos(t);
    }

    private static double y(double r, double t) {
        return r * Math.sin(t);
    }

    private static double r(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    private static double t(double x, double y) {
        return Math.atan2(y, x);
    }

    @Override
    public int numSourceDimensions() {
        return 2;
    }

    @Override
    public int numTargetDimensions() {
        return 2;
    }

    @Override
    public void apply(double[] source, double[] target) {
        double r = source[0];
        double t = source[1];
        target[0] = PolarToCartesianTransform2D.x(r, t);
        target[1] = PolarToCartesianTransform2D.y(r, t);
    }

    @Override
    public void apply(float[] source, float[] target) {
        double r = source[0];
        double t = source[1];
        target[0] = (float)PolarToCartesianTransform2D.x(r, t);
        target[1] = (float)PolarToCartesianTransform2D.y(r, t);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        double r = source.getDoublePosition(0);
        double t = source.getDoublePosition(1);
        target.setPosition(PolarToCartesianTransform2D.x(r, t), 0);
        target.setPosition(PolarToCartesianTransform2D.y(r, t), 1);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        double x = target[0];
        double y = target[1];
        source[0] = PolarToCartesianTransform2D.r(x, y);
        source[1] = PolarToCartesianTransform2D.t(x, y);
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        double x = target[0];
        double y = target[1];
        source[0] = (float)PolarToCartesianTransform2D.r(x, y);
        source[1] = (float)PolarToCartesianTransform2D.t(x, y);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        double x = target.getDoublePosition(0);
        double y = target.getDoublePosition(1);
        source.setPosition(PolarToCartesianTransform2D.r(x, y), 0);
        source.setPosition(PolarToCartesianTransform2D.t(x, y), 1);
    }

    @Override
    public InvertibleRealTransform inverse() {
        return this.inverse;
    }

    @Override
    public PolarToCartesianTransform2D copy() {
        return this;
    }
}

