/*
 * Decompiled with CFR 0.152.
 */
package util;

public class FibonacciHeap<T extends Comparable<T>>
implements Comparable<T> {
    private Node<T> root = new Node<Object>(null, null, null);
    private Node<T> min;
    int count;

    public void add(T key, Object object) {
        Node<T> node = new Node<T>(key, object, this.root);
        if (this.min == null || this.min.key.compareTo(key) > 0) {
            this.min = node;
        }
        this.root.insertChild(node);
        ++this.count;
    }

    public Object pop() {
        if (this.min == null) {
            return null;
        }
        Node node = this.min.firstChild;
        while (node != null) {
            Node next = node.next;
            node.previous = null;
            node.next = null;
            node.parent = null;
            this.root.firstChild.insert(node);
            node = next;
        }
        Node<T> ret = this.min;
        if (this.root.firstChild == this.min) {
            this.root.firstChild = this.min.next;
            if (this.min.next != null) {
                this.min.next.previous = null;
            }
        } else {
            if (this.min.next != null) {
                this.min.next.previous = this.min.previous;
            }
            if (this.min.previous != null) {
                this.min.previous.next = this.min.next;
            }
        }
        if (this.root.firstChild != null) {
            this.consolidate();
        } else {
            this.min = null;
        }
        --this.count;
        return ret.object;
    }

    public boolean hasMore() {
        return this.root.firstChild != null;
    }

    @Override
    public int compareTo(T other) {
        return this.min == null ? 1 : this.min.key.compareTo(other);
    }

    private final Node<T> link(Node<T> a, Node<T> b) {
        if (a.key.compareTo(b.key) > 0) {
            return this.link(b, a);
        }
        b.extract();
        b.parent = a;
        a.insertChild(b);
        return a;
    }

    private final void insert(Node<T>[] list, Node<T> node) {
        if (list[node.degree] == null) {
            list[node.degree] = node;
        } else {
            int oldDegree = node.degree;
            node = this.link(node, list[oldDegree]);
            list[oldDegree] = null;
            this.insert(list, node);
        }
    }

    private final void consolidate() {
        int maxDegree = 1;
        for (int i = 1; i <= this.count; i *= 2) {
            ++maxDegree;
        }
        Node[] list = new Node[maxDegree];
        Node n = this.root.firstChild;
        while (n != null) {
            Node next = n.next;
            n.extract();
            n.parent = this.root;
            this.insert(list, n);
            n = next;
        }
        Node last = null;
        this.root.firstChild = null;
        for (int i = 0; i < maxDegree; ++i) {
            if (list[i] == null) continue;
            if (last == null) {
                last = this.root.firstChild = list[i];
                last.next = null;
                last.previous = null;
                this.min = last;
                continue;
            }
            last.next = list[i];
            list[i].previous = last;
            last = list[i];
            last.next = null;
            if (this.min.key.compareTo(last.key) <= 0) continue;
            this.min = last;
        }
    }

    public static void main(String[] args) {
        int i;
        FibonacciHeap<Double> heap = new FibonacciHeap<Double>();
        double[] prios = new double[]{9.0, -5.0, Math.PI, 132.0, 15.223, 900000.0, 1997.0, 0.001, 0.0012, 0.0};
        for (i = 0; i < prios.length; ++i) {
            Double p = new Double(prios[i]);
            heap.add(p, p);
        }
        i = 0;
        while (heap.hasMore()) {
            System.out.println("Extract " + ++i + ": " + (Double)heap.pop());
        }
    }

    private static class Node<T extends Comparable<T>> {
        T key;
        Object object;
        Node<T> next;
        Node<T> previous;
        Node<T> parent;
        Node<T> firstChild;
        int degree;
        boolean marked;

        public Node(T key, Object object, Node<T> parent) {
            this.key = key;
            this.object = object;
            this.parent = parent;
        }

        void insert(Node<T> node) {
            if (node.next != null || node.previous != null || node.parent != null && node.parent != this.parent || this.previous != null) {
                throw new RuntimeException("node not new: " + node.next + ", " + node.previous + ", " + node.parent + ", " + this.previous);
            }
            node.next = this;
            this.previous = node;
            node.parent = this.parent;
            this.parent.firstChild = node;
        }

        void insertChild(Node<T> node) {
            if (this.firstChild == null) {
                this.firstChild = node;
                this.degree = node.degree + 1;
            } else {
                this.firstChild.insert(node);
                if (node.degree + 1 > this.degree) {
                    this.degree = node.degree + 1;
                }
            }
        }

        final void extract() {
            if (this.parent != null && this.parent.firstChild == this) {
                this.parent.firstChild = this.next;
            }
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            this.parent = null;
            this.next = null;
            this.previous = null;
        }

        public void print(String label) {
            this.print(label, "");
        }

        public void print(String label, String indent) {
            System.out.println(indent + label + ": " + this.key + ", " + this.object);
            int i = 1;
            Node<T> n = this.firstChild;
            while (n != null) {
                n.print(label + ":" + i++, indent + "    ");
                n = n.next;
            }
        }
    }
}

