/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.RunnableAction;

public class Actions {
    private final InputMap inputMap;
    private final ActionMap actionMap;
    private final String[] keyConfigContexts;
    protected KeyStrokeAdder.Factory keyConfig;
    protected KeyStrokeAdder keyStrokeAdder;

    public Actions(KeyStrokeAdder.Factory keyConfig, String ... keyConfigContexts) {
        this(new InputMap(), new ActionMap(), keyConfig, keyConfigContexts);
    }

    public Actions(InputMap inputMap, ActionMap actionMap, KeyStrokeAdder.Factory keyConfig, String ... keyConfigContexts) {
        this.actionMap = actionMap;
        this.inputMap = inputMap;
        this.keyConfig = keyConfig != null ? keyConfig : new InputTriggerConfig();
        this.keyConfigContexts = keyConfigContexts;
        this.keyStrokeAdder = this.keyConfig.keyStrokeAdder(inputMap, keyConfigContexts);
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public void install(InputActionBindings inputActionBindings, String name) {
        inputActionBindings.addActionMap(name, this.actionMap);
        inputActionBindings.addInputMap(name, this.inputMap, new String[0]);
    }

    public void runnableAction(Runnable runnable, String name, String ... defaultKeyStrokes) {
        this.namedAction(new RunnableAction(name, runnable), defaultKeyStrokes);
    }

    public void namedAction(AbstractNamedAction action, String ... defaultKeyStrokes) {
        this.keyStrokeAdder.put(action.name(), defaultKeyStrokes);
        action.put(this.actionMap);
    }

    public void updateKeyConfig(InputTriggerConfig keyConfig) {
        this.updateKeyConfig(keyConfig, true);
    }

    public void updateKeyConfig(InputTriggerConfig keyConfig, boolean clearAll) {
        KeyStroke[] inputs;
        this.keyConfig = keyConfig;
        HashMap<Object, List> unassigned = new HashMap<Object, List>();
        if (!clearAll && (inputs = this.inputMap.keys()) != null) {
            HashSet<String> contexts = new HashSet<String>(Arrays.asList(this.keyConfigContexts));
            KeyStroke[] keyStrokeArray = inputs;
            int n = keyStrokeArray.length;
            for (int i = 0; i < n; ++i) {
                KeyStroke input = keyStrokeArray[i];
                Object actionKey = this.inputMap.get(input);
                if (actionKey instanceof String && !keyConfig.getInputs((String)actionKey, contexts).isEmpty()) continue;
                unassigned.computeIfAbsent(actionKey, k -> new ArrayList()).add(input);
            }
        }
        this.keyStrokeAdder = keyConfig.keyStrokeAdder(this.inputMap, this.keyConfigContexts);
        this.inputMap.clear();
        Object[] keys = this.actionMap.keys();
        if (keys != null) {
            for (Object o : keys) {
                if (unassigned.containsKey(o)) continue;
                this.keyStrokeAdder.put((String)o);
            }
        }
        unassigned.forEach((actionMapKey, keyStrokes) -> keyStrokes.forEach(keyStroke -> this.inputMap.put((KeyStroke)keyStroke, actionMapKey)));
    }
}

