/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.draw.event.FigureSelectionListener;

public abstract class AbstractSelectedAction
extends AbstractAction
implements Disposable {
    @Nullable
    private DrawingEditor editor;
    @Nullable
    private transient DrawingView activeView;
    @Nullable
    private EventHandler eventHandler = new EventHandler();

    public AbstractSelectedAction(DrawingEditor editor) {
        this.setEditor(editor);
    }

    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        this.setEditor(null);
    }

    public void setEditor(@Nullable DrawingEditor editor) {
        if (this.eventHandler != null) {
            this.unregisterEventHandler();
        }
        this.editor = editor;
        if (editor != null && this.eventHandler != null) {
            this.registerEventHandler();
            this.updateEnabledState();
        }
    }

    @Nullable
    public DrawingEditor getEditor() {
        return this.editor;
    }

    @Nullable
    protected DrawingView getView() {
        return this.editor == null ? null : this.editor.getActiveView();
    }

    @Nullable
    protected Drawing getDrawing() {
        return this.getView() == null ? null : this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.getDrawing().fireUndoableEditHappened(edit);
    }

    public void setUpdateEnabledState(boolean newValue) {
        if (this.eventHandler != null != newValue) {
            if (newValue) {
                this.eventHandler = new EventHandler();
                this.registerEventHandler();
            } else {
                this.unregisterEventHandler();
                this.eventHandler = null;
            }
        }
        if (newValue) {
            this.updateEnabledState();
        }
    }

    public boolean isUpdatEnabledState() {
        return this.eventHandler != null;
    }

    private void unregisterEventHandler() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
        }
        if (this.activeView != null) {
            this.activeView.removeFigureSelectionListener(this.eventHandler);
            this.activeView.removePropertyChangeListener(this.eventHandler);
            this.activeView = null;
        }
    }

    private void registerEventHandler() {
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(new WeakPropertyChangeListener(this.eventHandler));
            if (this.activeView != null) {
                this.activeView.removeFigureSelectionListener(this.eventHandler);
                this.activeView.removePropertyChangeListener(this.eventHandler);
            }
            this.activeView = this.editor.getActiveView();
            if (this.activeView != null) {
                this.activeView.addFigureSelectionListener(this.eventHandler);
                this.activeView.addPropertyChangeListener(this.eventHandler);
            }
        }
    }

    private class EventHandler
    implements PropertyChangeListener,
    FigureSelectionListener,
    Serializable {
        private EventHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "activeView") {
                if (AbstractSelectedAction.this.activeView != null) {
                    AbstractSelectedAction.this.activeView.removeFigureSelectionListener(this);
                    AbstractSelectedAction.this.activeView.removePropertyChangeListener(this);
                }
                if (evt.getNewValue() != null) {
                    AbstractSelectedAction.this.activeView = (DrawingView)evt.getNewValue();
                    AbstractSelectedAction.this.activeView.addFigureSelectionListener(this);
                    AbstractSelectedAction.this.activeView.addPropertyChangeListener(this);
                }
                AbstractSelectedAction.this.updateEnabledState();
            } else if (evt.getPropertyName().equals("enabled")) {
                AbstractSelectedAction.this.updateEnabledState();
            }
        }

        public String toString() {
            return AbstractSelectedAction.this + " " + this.getClass() + "@" + this.hashCode();
        }

        @Override
        public void selectionChanged(FigureSelectionEvent evt) {
            AbstractSelectedAction.this.updateEnabledState();
        }
    }
}

