/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.TransformEdit;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AlignAction
extends AbstractSelectedAction {
    protected ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");

    public AlignAction(DrawingEditor editor) {
        super(editor);
        this.updateEnabledState();
    }

    @Override
    public void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 1);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CompositeEdit edit = new CompositeEdit(this.labels.getString("edit.align.text"));
        this.fireUndoableEditHappened(edit);
        this.alignFigures(this.getView().getSelectedFigures(), this.getSelectionBounds());
        this.fireUndoableEditHappened(edit);
    }

    protected abstract void alignFigures(Collection var1, Rectangle2D.Double var2);

    protected Rectangle2D.Double getSelectionBounds() {
        Rectangle2D.Double bounds = null;
        for (Figure f : this.getView().getSelectedFigures()) {
            if (bounds == null) {
                bounds = f.getBounds();
                continue;
            }
            bounds.add(f.getBounds());
        }
        return bounds;
    }

    public static class Horizontal
    extends AlignAction {
        public Horizontal(DrawingEditor editor) {
            super(editor);
            this.labels.configureAction(this, "edit.alignHorizontal");
        }

        public Horizontal(DrawingEditor editor, ResourceBundleUtil labels) {
            super(editor);
            labels.configureAction(this, "edit.alignHorizontal");
        }

        @Override
        protected void alignFigures(Collection selectedFigures, Rectangle2D.Double selectionBounds) {
            double x = selectionBounds.x + selectionBounds.width / 2.0;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(x - b.x - b.width / 2.0, 0.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened(new TransformEdit(f, tx));
            }
        }
    }

    public static class Vertical
    extends AlignAction {
        public Vertical(DrawingEditor editor) {
            super(editor);
            this.labels.configureAction(this, "edit.alignVertical");
        }

        public Vertical(DrawingEditor editor, ResourceBundleUtil labels) {
            super(editor);
            labels.configureAction(this, "edit.alignVertical");
        }

        @Override
        protected void alignFigures(Collection selectedFigures, Rectangle2D.Double selectionBounds) {
            double y = selectionBounds.y + selectionBounds.height / 2.0;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, y - b.y - b.height / 2.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened(new TransformEdit(f, tx));
            }
        }
    }

    public static class South
    extends AlignAction {
        public South(DrawingEditor editor) {
            super(editor);
            this.labels.configureAction(this, "edit.alignSouth");
        }

        public South(DrawingEditor editor, ResourceBundleUtil labels) {
            super(editor);
            labels.configureAction(this, "edit.alignSouth");
        }

        @Override
        protected void alignFigures(Collection selectedFigures, Rectangle2D.Double selectionBounds) {
            double y = selectionBounds.y + selectionBounds.height;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, y - b.y - b.height);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened(new TransformEdit(f, tx));
            }
        }
    }

    public static class West
    extends AlignAction {
        public West(DrawingEditor editor) {
            super(editor);
            this.labels.configureAction(this, "edit.alignWest");
        }

        public West(DrawingEditor editor, ResourceBundleUtil labels) {
            super(editor);
            labels.configureAction(this, "edit.alignWest");
        }

        @Override
        protected void alignFigures(Collection selectedFigures, Rectangle2D.Double selectionBounds) {
            double x = selectionBounds.x;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(x - b.x, 0.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened(new TransformEdit(f, tx));
            }
        }
    }

    public static class East
    extends AlignAction {
        public East(DrawingEditor editor) {
            super(editor);
            this.labels.configureAction(this, "edit.alignEast");
        }

        public East(DrawingEditor editor, ResourceBundleUtil labels) {
            super(editor);
            labels.configureAction(this, "edit.alignEast");
        }

        @Override
        protected void alignFigures(Collection selectedFigures, Rectangle2D.Double selectionBounds) {
            double x = selectionBounds.x + selectionBounds.width;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(x - b.x - b.width, 0.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened(new TransformEdit(f, tx));
            }
        }
    }

    public static class North
    extends AlignAction {
        public North(DrawingEditor editor) {
            super(editor);
            this.labels.configureAction(this, "edit.alignNorth");
        }

        public North(DrawingEditor editor, ResourceBundleUtil labels) {
            super(editor);
            labels.configureAction(this, "edit.alignNorth");
        }

        @Override
        protected void alignFigures(Collection selectedFigures, Rectangle2D.Double selectionBounds) {
            double y = selectionBounds.y;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, y - b.y);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened(new TransformEdit(f, tx));
            }
        }
    }
}

