/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.handle;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TriangleFigure;
import org.jhotdraw.draw.event.AttributeChangeEdit;
import org.jhotdraw.draw.handle.AbstractHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.HandleAttributeKeys;
import org.jhotdraw.geom.Geom;

public class OrientationHandle
extends AbstractHandle {
    private Rectangle centerBox;
    private AttributeKeys.Orientation oldValue;
    private AttributeKeys.Orientation newValue;

    public OrientationHandle(TriangleFigure owner) {
        super(owner);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        return false;
    }

    private Point2D.Double getLocation() {
        Point2D.Double p;
        Figure owner = this.getOwner();
        Rectangle2D.Double r = owner.getBounds();
        double offset = this.getHandlesize();
        switch (owner.get(AttributeKeys.ORIENTATION)) {
            default: {
                p = new Point2D.Double(r.x + r.width / 2.0, r.y + offset);
                break;
            }
            case NORTH_EAST: {
                p = new Point2D.Double(r.x + r.width - offset, r.y + offset);
                break;
            }
            case EAST: {
                p = new Point2D.Double(r.x + r.width - offset, r.y + r.height / 2.0);
                break;
            }
            case SOUTH_EAST: {
                p = new Point2D.Double(r.x + r.width - offset, r.y + r.height - offset);
                break;
            }
            case SOUTH: {
                p = new Point2D.Double(r.x + r.width / 2.0, r.y + r.height - offset);
                break;
            }
            case SOUTH_WEST: {
                p = new Point2D.Double(r.x + offset, r.y + r.height - offset);
                break;
            }
            case WEST: {
                p = new Point2D.Double(r.x + offset, r.y + r.height / 2.0);
                break;
            }
            case NORTH_WEST: {
                p = new Point2D.Double(r.x + offset, r.y + offset);
            }
        }
        return p;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Point p = this.view.drawingToView(this.getLocation());
        Rectangle r = new Rectangle(p);
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.oldValue = this.getOwner().get(AttributeKeys.ORIENTATION);
        this.centerBox = this.view.drawingToView(this.getOwner().getBounds());
        this.centerBox.grow(this.centerBox.width / -3, this.centerBox.height / -3);
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Rectangle leadRect = new Rectangle(lead);
        switch (Geom.outcode(this.centerBox, leadRect)) {
            default: {
                this.newValue = AttributeKeys.Orientation.NORTH;
                break;
            }
            case 6: {
                this.newValue = AttributeKeys.Orientation.NORTH_EAST;
                break;
            }
            case 4: {
                this.newValue = AttributeKeys.Orientation.EAST;
                break;
            }
            case 12: {
                this.newValue = AttributeKeys.Orientation.SOUTH_EAST;
                break;
            }
            case 8: {
                this.newValue = AttributeKeys.Orientation.SOUTH;
                break;
            }
            case 9: {
                this.newValue = AttributeKeys.Orientation.SOUTH_WEST;
                break;
            }
            case 1: {
                this.newValue = AttributeKeys.Orientation.WEST;
                break;
            }
            case 3: {
                this.newValue = AttributeKeys.Orientation.NORTH_WEST;
            }
        }
        this.getOwner().willChange();
        this.getOwner().set(AttributeKeys.ORIENTATION, this.newValue);
        this.getOwner().changed();
        this.updateBounds();
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR));
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        if (this.newValue != this.oldValue) {
            this.fireUndoableEditHappened(new AttributeChangeEdit<AttributeKeys.Orientation>(this.getOwner(), AttributeKeys.ORIENTATION, this.oldValue, this.newValue));
        }
    }
}

