/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Point2D;
import org.jhotdraw.geom.Geom;

public class Shapes {
    private Shapes() {
    }

    public static boolean outlineContains(Shape shape, Point2D.Double p, double tolerance) {
        double[] coords = new double[6];
        double prevX = 0.0;
        double prevY = 0.0;
        double moveX = 0.0;
        double moveY = 0.0;
        FlatteningPathIterator i = new FlatteningPathIterator(shape.getPathIterator(new AffineTransform(), tolerance), tolerance);
        while (!i.isDone()) {
            switch (i.currentSegment(coords)) {
                case 4: {
                    if (!Geom.lineContainsPoint(prevX, prevY, moveX, moveY, p.x, p.y, tolerance)) break;
                    return true;
                }
                case 3: {
                    break;
                }
                case 1: {
                    if (!Geom.lineContainsPoint(prevX, prevY, coords[0], coords[1], p.x, p.y, tolerance)) break;
                    return true;
                }
                case 0: {
                    moveX = coords[0];
                    moveY = coords[1];
                    break;
                }
                case 2: {
                    break;
                }
            }
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        return false;
    }
}

