/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.histogram.arbitrary;

import mpicbg.imglib.algorithm.histogram.HistogramBin;
import mpicbg.imglib.algorithm.histogram.HistogramBinFactory;
import mpicbg.imglib.algorithm.histogram.HistogramKey;
import mpicbg.imglib.type.numeric.RealType;

public class RealHistogramBinFactory<T extends RealType<T>>
implements HistogramBinFactory<T> {
    private final double width;
    private final double offset;

    public RealHistogramBinFactory(double w, double d) {
        this.width = w;
        this.offset = d;
    }

    private double mapToCenter(double val) {
        double r = Math.floor((val - this.offset) / this.width) + 0.5;
        return r * this.width + this.offset;
    }

    private T centerType(T type) {
        double center = this.mapToCenter(type.getRealDouble());
        RealType out = (RealType)type.createVariable();
        out.setReal(center);
        return (T)out;
    }

    @Override
    public HistogramBin<T> createBin(T type) {
        T center = this.centerType(type);
        return new RealHistogramBin(this, center, this.createKey(center));
    }

    @Override
    public HistogramKey<T> createKey(T type) {
        T center = this.centerType(type);
        int hc = new Double(center.getRealDouble()).hashCode();
        HistogramKey<T> key = new HistogramKey<T>(hc, center, this);
        return key;
    }

    @Override
    public boolean equivalent(T type1, T type2) {
        return this.mapToCenter(type1.getRealDouble()) == this.mapToCenter(type2.getRealDouble());
    }

    public static class RealHistogramBin
    extends HistogramBin<T> {
        final /* synthetic */ RealHistogramBinFactory this$0;

        public RealHistogramBin(T t, HistogramKey<T> k) {
            this.this$0 = this$0;
            super(t, k);
        }

        @Override
        public T getLowerBound() {
            RealType lower = (RealType)((RealType)this.getCenter()).createVariable();
            lower.setReal(((RealType)this.getCenter()).getRealDouble() - this.this$0.width / 2.0);
            return lower;
        }

        @Override
        public T getUpperBound() {
            RealType upper = (RealType)((RealType)this.getCenter()).createVariable();
            upper.setReal(((RealType)this.getCenter()).getRealDouble() - this.this$0.width / 2.0);
            return upper;
        }

        @Override
        public double getNorm() {
            return this.this$0.width;
        }
    }
}

