/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.linear;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolator;
import mpicbg.imglib.interpolation.linear.LinearInterpolator1D;
import mpicbg.imglib.interpolation.linear.LinearInterpolator2D;
import mpicbg.imglib.interpolation.linear.LinearInterpolator2DRealType;
import mpicbg.imglib.interpolation.linear.LinearInterpolator3D;
import mpicbg.imglib.interpolation.linear.LinearInterpolator3DRealType;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class LinearInterpolatorFactory<T extends RealType<T>>
extends InterpolatorFactory<T> {
    public LinearInterpolatorFactory(OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(outOfBoundsStrategyFactory);
    }

    @Override
    public LinearInterpolator<T> createInterpolator(Image<T> img) {
        if (img.getNumDimensions() == 1) {
            return new LinearInterpolator1D<T>(img, this, this.outOfBoundsStrategyFactory);
        }
        if (img.getNumDimensions() == 2) {
            if (RealType.class.isInstance(img.createType())) {
                return new LinearInterpolator2DRealType<T>(img, this, this.outOfBoundsStrategyFactory);
            }
            return new LinearInterpolator2D<T>(img, this, this.outOfBoundsStrategyFactory);
        }
        if (img.getNumDimensions() == 3) {
            if (RealType.class.isInstance(img.createType())) {
                return new LinearInterpolator3DRealType<T>(img, this, this.outOfBoundsStrategyFactory);
            }
            return new LinearInterpolator3D<T>(img, this, this.outOfBoundsStrategyFactory);
        }
        return new LinearInterpolator<T>(img, this, this.outOfBoundsStrategyFactory);
    }
}

