/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.util.Arrays;

public class BoundingBox {
    protected int[] min;
    protected int[] max;

    public BoundingBox(int dimensions) {
        this.min = new int[dimensions];
        this.max = new int[dimensions];
        Arrays.fill(this.max, Integer.MIN_VALUE);
        Arrays.fill(this.min, Integer.MAX_VALUE);
    }

    public int getDimensions() {
        return this.min.length;
    }

    public void getExtents(int[] destMin, int[] destMax) {
        if (destMin != null) {
            System.arraycopy(this.min, 0, destMin, 0, this.min.length);
        }
        if (destMax != null) {
            System.arraycopy(this.max, 0, destMax, 0, this.max.length);
        }
    }

    public void update(int[] coordinates) {
        for (int i = 0; i < this.min.length; ++i) {
            if (coordinates[i] < this.min[i]) {
                this.min[i] = coordinates[i];
            }
            if (coordinates[i] < this.max[i]) continue;
            this.max[i] = coordinates[i] + 1;
        }
    }
}

