/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.real;

import mpicbg.imglib.algorithm.Precision;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.RealTypeImpl;

public class FloatType
extends RealTypeImpl<FloatType>
implements RealType<FloatType> {
    final DirectAccessContainer<FloatType, ? extends FloatAccess> storage;
    FloatAccess b;

    public FloatType(DirectAccessContainer<FloatType, ? extends FloatAccess> floatStorage) {
        this.storage = floatStorage;
    }

    public FloatType(float value) {
        this.storage = null;
        this.b = new FloatArray(1);
        this.set(value);
    }

    public FloatType() {
        this(0.0f);
    }

    @Override
    public DirectAccessContainer<FloatType, ? extends FloatAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<FloatType, FloatAccess> container = storageFactory.createFloatInstance(dim, 1);
        FloatType linkedType = new FloatType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    @Override
    public FloatType duplicateTypeOnSameDirectAccessContainer() {
        return new FloatType(this.storage);
    }

    public float get() {
        return this.b.getValue(this.i);
    }

    @Override
    public void set(float f) {
        this.b.setValue(this.i, f);
    }

    @Override
    public float getRealFloat() {
        return this.get();
    }

    @Override
    public double getRealDouble() {
        return this.get();
    }

    @Override
    public void setReal(float real) {
        this.set(real);
    }

    @Override
    public void setReal(double real) {
        this.set((float)real);
    }

    @Override
    public Precision.PrecisionReal getPreferredRealPrecision() {
        return Precision.PrecisionReal.Float;
    }

    @Override
    public double getMaxValue() {
        return 3.4028234663852886E38;
    }

    @Override
    public double getMinValue() {
        return -3.4028234663852886E38;
    }

    @Override
    public double getMinIncrement() {
        return 1.4E-45f;
    }

    @Override
    public void mul(float c) {
        this.set(this.get() * c);
    }

    @Override
    public void mul(double c) {
        this.set((float)((double)this.get() * c));
    }

    @Override
    public void add(FloatType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(FloatType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(FloatType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(FloatType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public int compareTo(FloatType c) {
        float b;
        float a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(FloatType c) {
        this.set(c.get());
    }

    @Override
    public void setOne() {
        this.set(1.0f);
    }

    @Override
    public void setZero() {
        this.set(0.0f);
    }

    @Override
    public void inc() {
        float a = this.get();
        this.set(a += 1.0f);
    }

    @Override
    public void dec() {
        float a = this.get();
        this.set(a -= 1.0f);
    }

    public FloatType[] createArray1D(int size1) {
        return new FloatType[size1];
    }

    public FloatType[][] createArray2D(int size1, int size2) {
        return new FloatType[size1][size2];
    }

    public FloatType[][][] createArray3D(int size1, int size2, int size3) {
        return new FloatType[size1][size2][size3];
    }

    @Override
    public FloatType createVariable() {
        return new FloatType(0.0f);
    }

    @Override
    public FloatType copy() {
        return new FloatType(this.get());
    }
}

