/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.analysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.TreeMap;
import javax.swing.JFrame;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import script.imglib.algorithm.fn.AlgorithmUtil;
import script.imglib.analysis.ChartUtils;

public class Histogram<T extends RealType<T>>
extends TreeMap<Double, Integer> {
    private static final long serialVersionUID = 1L;
    private final Image<T> img;
    private final double min;
    private final double max;
    private final double increment;

    public Histogram(Object fn) throws Exception {
        this(fn, 256);
    }

    public Histogram(Object fn, Number nBins) throws Exception {
        this(fn, nBins.intValue());
    }

    public Histogram(Object fn, int nBins) throws Exception {
        this.img = AlgorithmUtil.wrap(fn);
        Display<T> display = this.img.getDisplay();
        display.setMinMax();
        this.min = display.getMin();
        this.max = display.getMax();
        this.increment = this.process(this.img, nBins, this.min, this.max);
    }

    public Histogram(Object fn, int nBins, double min, double max) throws Exception {
        this.img = AlgorithmUtil.wrap(fn);
        this.min = min;
        this.max = max;
        this.increment = this.process(this.img, nBins, min, max);
    }

    private final double process(Image<T> img, int nBins, double min, double max) throws Exception {
        double range = max - min;
        double increment = range / (double)nBins;
        int[] bins = new int[nBins];
        if (0.0 == range) {
            bins[0] = img.size();
        } else {
            Cursor<T> c = img.createCursor();
            int N = nBins - 1;
            while (c.hasNext()) {
                c.fwd();
                int v = (int)((((RealType)c.getType()).getRealDouble() - min) / range * (double)N);
                if (v < 0) {
                    v = 0;
                } else if (v > N) {
                    v = N;
                }
                int n = v;
                bins[n] = bins[n] + 1;
            }
            c.close();
        }
        for (int i = 0; i < bins.length; ++i) {
            this.put(min + (double)i * increment, bins[i]);
        }
        return increment;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getIncrement() {
        return this.increment;
    }

    public Image<T> getImage() {
        return this.img;
    }

    public Image<RGBALegacyType> asImage() {
        return ChartUtils.asImage(this.asChart(false));
    }

    public JFreeChart asChart() {
        return this.asChart(false);
    }

    public JFreeChart asChart(boolean show) {
        double[] d = new double[this.size()];
        int i = 0;
        for (Number num : this.values()) {
            d[i++] = num.doubleValue();
        }
        HistogramDataset hd = new HistogramDataset();
        hd.setType(HistogramType.RELATIVE_FREQUENCY);
        String title = "Histogram";
        hd.addSeries((Comparable)((Object)title), d, d.length);
        JFreeChart chart = ChartFactory.createHistogram((String)title, (String)"", (String)"", (IntervalXYDataset)hd, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        Histogram.setTheme(chart);
        if (show) {
            JFrame frame = new JFrame(title);
            frame.getContentPane().add((Component)new ChartPanel(chart));
            frame.pack();
            frame.setVisible(true);
        }
        return chart;
    }

    private static final void setTheme(JFreeChart chart) {
        XYPlot plot = (XYPlot)chart.getPlot();
        XYBarRenderer r = (XYBarRenderer)plot.getRenderer();
        StandardXYBarPainter bp = new StandardXYBarPainter();
        r.setBarPainter((XYBarPainter)bp);
        r.setSeriesOutlinePaint(0, (Paint)Color.lightGray);
        r.setShadowVisible(false);
        r.setDrawBarOutline(false);
        Histogram.setBackgroundDefault(chart);
    }

    private static final void setBackgroundDefault(JFreeChart chart) {
        BasicStroke gridStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 1.0f}, 0.0f);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setRangeGridlineStroke((Stroke)gridStroke);
        plot.setDomainGridlineStroke((Stroke)gridStroke);
        plot.setBackgroundPaint((Paint)new Color(235, 235, 235));
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setOutlineVisible(false);
        plot.getDomainAxis().setAxisLineVisible(false);
        plot.getRangeAxis().setAxisLineVisible(false);
        plot.getDomainAxis().setLabelPaint((Paint)Color.gray);
        plot.getRangeAxis().setLabelPaint((Paint)Color.gray);
        plot.getDomainAxis().setTickLabelPaint((Paint)Color.gray);
        plot.getRangeAxis().setTickLabelPaint((Paint)Color.gray);
        chart.getTitle().setPaint((Paint)Color.gray);
    }
}

