/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img;

import ij.ImagePlus;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.converter.Converter;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.CalibrationUtils;
import net.imglib2.img.imageplus.ByteImagePlus;
import net.imglib2.img.imageplus.FloatImagePlus;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.img.imageplus.IntImagePlus;
import net.imglib2.img.imageplus.ShortImagePlus;
import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;

public class ImagePlusAdapter {
    public static <T extends NumericType<T> & NativeType<T>> ImagePlusImg<T, ?> wrap(ImagePlus imp) {
        return ImagePlusAdapter.wrapLocal(imp);
    }

    public static ImagePlusImg wrapReal(ImagePlus imp) {
        return ImagePlusAdapter.wrapLocalReal(imp);
    }

    public static ImagePlusImg wrapNumeric(ImagePlus imp) {
        return ImagePlusAdapter.wrapLocal(imp);
    }

    public static <T extends NumericType<T> & NativeType<T>> ImgPlus<T> wrapImgPlus(ImagePlus imp) {
        ImagePlusImg<T, ?> img = ImagePlusAdapter.wrap(imp);
        return new ImgPlus(img, imp.getTitle(), CalibrationUtils.getNonTrivialAxes(imp));
    }

    protected static ImagePlusImg<?, ?> wrapLocal(ImagePlus imp) {
        switch (imp.getType()) {
            case 0: {
                return ImagePlusAdapter.wrapByte(imp);
            }
            case 1: {
                return ImagePlusAdapter.wrapShort(imp);
            }
            case 2: {
                return ImagePlusAdapter.wrapFloat(imp);
            }
            case 4: {
                return ImagePlusAdapter.wrapRGBA(imp);
            }
        }
        throw new RuntimeException("Only 8, 16, 32-bit and RGB supported!");
    }

    protected static ImagePlusImg<?, ?> wrapLocalReal(ImagePlus imp) {
        switch (imp.getType()) {
            case 0: {
                return ImagePlusAdapter.wrapByte(imp);
            }
            case 1: {
                return ImagePlusAdapter.wrapShort(imp);
            }
            case 2: {
                return ImagePlusAdapter.wrapFloat(imp);
            }
        }
        throw new RuntimeException("Only 8, 16 and 32-bit supported!");
    }

    protected static <T extends NumericType<T> & NativeType<T>> void setAxesFromImagePlus(ImgPlus<T> image, ImagePlus imp) {
        int currentDim = 2;
        if (imp.getNChannels() > 1) {
            ((CalibratedAxis)image.axis(currentDim)).setType(Axes.CHANNEL);
            ++currentDim;
        }
        if (imp.getNSlices() > 1) {
            ((CalibratedAxis)image.axis(currentDim)).setType(Axes.Z);
            ++currentDim;
        }
        if (imp.getNFrames() > 1) {
            ((CalibratedAxis)image.axis(currentDim)).setType(Axes.TIME);
        }
    }

    public static ByteImagePlus<UnsignedByteType> wrapByte(ImagePlus imp) {
        if (imp.getType() != 0) {
            return null;
        }
        ByteImagePlus<UnsignedByteType> container = new ByteImagePlus<UnsignedByteType>(imp);
        UnsignedByteType linkedType = new UnsignedByteType(container);
        container.setLinkedType((NativeType)linkedType);
        return container;
    }

    public static ShortImagePlus<UnsignedShortType> wrapShort(ImagePlus imp) {
        if (imp.getType() != 1) {
            return null;
        }
        ShortImagePlus<UnsignedShortType> container = new ShortImagePlus<UnsignedShortType>(imp);
        UnsignedShortType linkedType = new UnsignedShortType(container);
        container.setLinkedType((NativeType)linkedType);
        return container;
    }

    public static IntImagePlus<UnsignedIntType> wrapInt(ImagePlus imp) {
        if (imp.getType() != 4) {
            return null;
        }
        IntImagePlus<UnsignedIntType> container = new IntImagePlus<UnsignedIntType>(imp);
        UnsignedIntType linkedType = new UnsignedIntType(container);
        container.setLinkedType((NativeType)linkedType);
        return container;
    }

    public static IntImagePlus<ARGBType> wrapRGBA(ImagePlus imp) {
        if (imp.getType() != 4) {
            return null;
        }
        IntImagePlus<ARGBType> container = new IntImagePlus<ARGBType>(imp);
        ARGBType linkedType = new ARGBType(container);
        container.setLinkedType((NativeType)linkedType);
        return container;
    }

    public static FloatImagePlus<FloatType> wrapFloat(ImagePlus imp) {
        if (imp.getType() != 2) {
            return null;
        }
        FloatImagePlus<FloatType> container = new FloatImagePlus<FloatType>(imp);
        FloatType linkedType = new FloatType(container);
        container.setLinkedType((NativeType)linkedType);
        return container;
    }

    public static Img<FloatType> convertFloat(ImagePlus imp) {
        switch (imp.getType()) {
            case 0: {
                return ImagePlusAdapter.convertToFloat(ImagePlusAdapter.wrapByte(imp), new NumberToFloatConverter());
            }
            case 1: {
                return ImagePlusAdapter.convertToFloat(ImagePlusAdapter.wrapShort(imp), new NumberToFloatConverter());
            }
            case 2: {
                return ImagePlusAdapter.wrapFloat(imp);
            }
            case 4: {
                return ImagePlusAdapter.convertToFloat(ImagePlusAdapter.wrapRGBA(imp), new ARGBtoFloatConverter());
            }
        }
        throw new RuntimeException("Only 8, 16, 32-bit and RGB supported!");
    }

    protected static <T extends Type<T>> Img<FloatType> convertToFloat(Img<T> input, Converter<T, FloatType> c) {
        PlanarImg output = new ImagePlusImgFactory<FloatType>(new FloatType()).create((Dimensions)input);
        Cursor in = input.cursor();
        PlanarCursor out = output.cursor();
        while (in.hasNext()) {
            in.fwd();
            out.fwd();
            c.convert(in.get(), out.get());
        }
        return output;
    }

    private static class NumberToFloatConverter<T extends ComplexType<T>>
    implements Converter<T, FloatType> {
        private NumberToFloatConverter() {
        }

        public void convert(T input, FloatType output) {
            output.setReal(input.getRealFloat());
        }
    }

    private static class ARGBtoFloatConverter
    implements Converter<ARGBType, FloatType> {
        private ARGBtoFloatConverter() {
        }

        public void convert(ARGBType input, FloatType output) {
            int v = input.get();
            output.setReal((double)(v >> 24 & 0xFF) * ((double)(v >> 16 & 0xFF) * 0.299 + (double)(v >> 8 & 0xFF) * 0.587 + (double)(v & 0xFF) * 0.144));
        }
    }
}

