/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import java.io.PrintWriter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.TraceClassVisitor;
import org.renjin.compiler.ByteCodeVisitor;
import org.renjin.compiler.ConstantGeneratingVisitor;
import org.renjin.compiler.GenerationContext;
import org.renjin.compiler.StaticFieldSexpPool;
import org.renjin.compiler.ThunkMap;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.expressions.IRThunk;
import org.renjin.compiler.ir.tac.statements.Statement;

public class ThunkCompiler
implements Opcodes {
    private IRThunk thunk;
    private ClassWriter cw;
    private ClassVisitor cv;
    private GenerationContext generationContext;

    public static byte[] compile(String className, ThunkMap thunkMap, IRThunk thunk) {
        return new ThunkCompiler(thunkMap, className).doCompile(thunk);
    }

    public ThunkCompiler(ThunkMap thunkMap, String className) {
        this.generationContext = new GenerationContext(className, new StaticFieldSexpPool(className), thunkMap);
    }

    public byte[] doCompile(IRThunk thunk) {
        this.thunk = thunk;
        this.startClass();
        this.writeStaticDoEval();
        this.writeConstructor();
        this.writeSexp();
        this.generationContext.getSexpPool().writeFields(this.cv);
        this.writeClassEnd();
        return this.cw.toByteArray();
    }

    private void startClass() {
        this.cw = new ClassWriter(2);
        this.cv = new TraceClassVisitor((ClassVisitor)this.cw, new PrintWriter(System.out));
        this.cv.visit(50, 33, this.generationContext.getClassName(), null, "org/renjin/sexp/Promise", null);
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, this.generationContext.getClassName(), "createSexp", "()Lorg/renjin/sexp/SEXP;");
        mv.visitMethodInsn(183, "org/renjin/sexp/Promise", "<init>", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;Lorg/renjin/sexp/SEXP;)V");
        this.generationContext.getSexpPool().writeConstructorBody(mv);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeStaticDoEval() {
        MethodVisitor mv = this.cv.visitMethod(9, "doEval", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;)Lorg/renjin/sexp/SEXP;", null, null);
        mv.visitCode();
        this.writeDoEvalBody(mv);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeSexp() {
        MethodVisitor mv = this.cv.visitMethod(10, "createSexp", "()Lorg/renjin/sexp;", null, null);
        mv.visitCode();
        ConstantGeneratingVisitor cgv = new ConstantGeneratingVisitor(mv);
        this.thunk.getSExpression().accept(cgv);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeDoEvalBody(MethodVisitor mv) {
        IRBody body2 = this.thunk.getBody();
        this.generationContext.setContextLdc(0);
        this.generationContext.setEnvironmentLdc(1);
        ByteCodeVisitor visitor = new ByteCodeVisitor(this.generationContext, mv);
        ControlFlowGraph cfg = new ControlFlowGraph(body2);
        for (BasicBlock bb : cfg.getBasicBlocks()) {
            System.out.println(bb.statementsToString());
            visitor.startBasicBlock(bb);
            for (Statement stmt : bb.getStatements()) {
                stmt.accept(visitor);
            }
        }
    }

    private void writeClassEnd() {
        this.cv.visitEnd();
    }
}

