/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import com.google.common.base.Strings;
import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

class Combiner {
    private boolean recursive;
    private CombinedBuilder builder;

    public Combiner(boolean recursive2, CombinedBuilder builder) {
        this.recursive = recursive2;
        this.builder = builder;
    }

    public Combiner add(Iterable<NamedValue> list2) {
        return this.add("", list2);
    }

    public Combiner add(String parentPrefix, Iterable<? extends NamedValue> list2) {
        for (NamedValue namedValue : list2) {
            String prefix = this.combinePrefixes(parentPrefix, Strings.nullToEmpty((String)namedValue.getName()));
            SEXP value = namedValue.getValue();
            if (value instanceof FunctionCall) {
                this.builder.add(prefix, value);
                continue;
            }
            if (value instanceof AtomicVector || value instanceof ExpressionVector) {
                this.builder.addElements(prefix, (Vector)value);
                continue;
            }
            if (value instanceof ListVector) {
                if (this.recursive) {
                    this.add(prefix, ((ListVector)value).namedValues());
                    continue;
                }
                this.builder.addElements(prefix, (ListVector)value);
                continue;
            }
            if (value instanceof PairList) {
                if (this.recursive) {
                    this.add(prefix, ((PairList)value).nodes());
                    continue;
                }
                this.builder.addElements(prefix, ((PairList)value).toVector());
                continue;
            }
            this.builder.add(prefix, value);
        }
        return this;
    }

    private String combinePrefixes(String a, String b) {
        assert (a != null);
        assert (b != null);
        if (!a.isEmpty() && !b.isEmpty()) {
            return a + "." + b;
        }
        if (!Strings.isNullOrEmpty((String)a)) {
            return a;
        }
        return b;
    }

    public Vector build() {
        return this.builder.build();
    }
}

