/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.primitives.combine.LazyBuilder;
import org.renjin.primitives.combine.MaterializedBuilder;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

class Inspector
extends SexpVisitor<Vector.Type> {
    public static final int DEFERRED_THRESHOLD = 2000;
    public static final int DEFERRED_ARGUMENT_LIMIT = 200;
    private boolean recursive = false;
    private int vectorCount = 0;
    private int elementCount = 0;
    private Vector.Type resultType = Null.VECTOR_TYPE;

    Inspector(boolean recursive2) {
        this.recursive = recursive2;
    }

    @Override
    public void visit(DoubleVector vector2) {
        this.resultType = Vector.Type.widest(this.resultType, vector2);
        this.elementCount += vector2.length();
        ++this.vectorCount;
    }

    @Override
    public void visit(IntVector vector2) {
        this.resultType = Vector.Type.widest(this.resultType, vector2);
        this.elementCount += vector2.length();
        ++this.vectorCount;
    }

    @Override
    public void visit(LogicalVector vector2) {
        this.resultType = Vector.Type.widest(this.resultType, vector2);
        this.elementCount += vector2.length();
        ++this.vectorCount;
    }

    @Override
    public void visit(Null nullExpression) {
    }

    @Override
    public void visit(StringVector vector2) {
        this.resultType = Vector.Type.widest(this.resultType, vector2);
        this.elementCount += vector2.length();
        ++this.vectorCount;
    }

    @Override
    public void visit(ComplexVector vector2) {
        this.resultType = Vector.Type.widest(this.resultType, vector2);
        this.elementCount += vector2.length();
        ++this.vectorCount;
    }

    @Override
    public void visit(RawVector vector2) {
        this.resultType = Vector.Type.widest(this.resultType, vector2);
        this.elementCount += vector2.length();
        ++this.vectorCount;
    }

    @Override
    public void visit(ListVector list2) {
        if (this.recursive) {
            this.acceptAll(list2);
        } else {
            this.resultType = Vector.Type.widest(this.resultType, list2);
            this.elementCount += list2.length();
            ++this.vectorCount;
        }
    }

    @Override
    protected void unhandled(SEXP exp2) {
        this.resultType = Vector.Type.widest(this.resultType, ListVector.VECTOR_TYPE);
        ++this.elementCount;
        ++this.vectorCount;
    }

    public CombinedBuilder newBuilder() {
        if ((this.resultType == DoubleVector.VECTOR_TYPE || this.resultType == IntVector.VECTOR_TYPE || this.resultType == StringVector.VECTOR_TYPE) && this.elementCount > 2000 && this.vectorCount <= 200) {
            return new LazyBuilder(this.resultType, this.vectorCount);
        }
        return new MaterializedBuilder(this.resultType);
    }

    @Override
    public Vector.Type getResult() {
        return this.resultType;
    }
}

