/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.eval.Calls;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.primitives.S3;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.sequence.RepIntVector;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;
import org.renjin.util.NamesBuilder;

public class RepFunction
extends SpecialFunction {
    public RepFunction() {
        super("rep");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        SEXP result;
        PairList arguments = call2.getArguments();
        if (arguments == Null.INSTANCE) {
            context.setInvisibleFlag();
            return Null.INSTANCE;
        }
        ArgumentIterator argIt = new ArgumentIterator(context, rho, arguments);
        PairList.Node firstArgNode = argIt.nextNode();
        SEXP firstArg = context.evaluate(firstArgNode.getValue(), rho);
        if (firstArg.isObject() && (result = S3.tryDispatchFromPrimitive(context, rho, call2, "rep", firstArg, arguments)) != null) {
            return result;
        }
        PairList.Builder evaled = new PairList.Builder();
        evaled.add(firstArgNode.getRawTag(), firstArg);
        while (argIt.hasNext()) {
            PairList.Node node = argIt.nextNode();
            evaled.add(node.getRawTag(), context.evaluate(node.getValue(), rho));
        }
        PairList.Builder formals2 = new PairList.Builder();
        formals2.add("x", (SEXP)Symbol.MISSING_ARG);
        formals2.add("times", (SEXP)Symbol.MISSING_ARG);
        formals2.add("length.out", (SEXP)Symbol.MISSING_ARG);
        formals2.add("each", (SEXP)Symbol.MISSING_ARG);
        PairList matched = Calls.matchArguments(formals2.build(), evaled.build(), true);
        SEXP x = matched.findByTag(Symbol.get("x"));
        SEXP times2 = matched.findByTag(Symbol.get("times"));
        SEXP lengthOut = matched.findByTag(Symbol.get("length.out"));
        SEXP each = matched.findByTag(Symbol.get("each"));
        return this.rep((Vector)x, times2 == Symbol.MISSING_ARG ? new IntArrayVector(1) : (Vector)times2, lengthOut == Symbol.MISSING_ARG ? Integer.MIN_VALUE : ((Vector)lengthOut).getElementAsInt(0), each == Symbol.MISSING_ARG ? Integer.MIN_VALUE : ((Vector)each).getElementAsInt(0));
    }

    private Vector rep(Vector x, Vector times2, int lengthOut, int each) {
        int resultLength;
        if (times2.length() == 1) {
            resultLength = x.length() * times2.getElementAsInt(0);
        } else {
            resultLength = 0;
            for (int i = 0; i != x.length(); ++i) {
                resultLength += times2.getElementAsInt(i);
            }
        }
        if (!IntVector.isNA(each)) {
            resultLength = x.length() * each;
        } else {
            each = 1;
        }
        if (!IntVector.isNA(lengthOut)) {
            if (lengthOut < 0) {
                throw new EvalException("invalid 'length.out' argument", new Object[0]);
            }
            resultLength = lengthOut;
        }
        if (times2.length() > 1 && each > 1) {
            throw new EvalException("invalid 'times' argument", new Object[0]);
        }
        if (x instanceof DoubleVector && times2.length() == 1 && (x instanceof DeferredComputation || resultLength > 100)) {
            return new RepDoubleVector(x, resultLength, each);
        }
        if (x instanceof IntVector && times2.length() == 1 && (x instanceof DeferredComputation || resultLength > 100)) {
            return new RepIntVector(x, resultLength, each);
        }
        Vector.Builder result = x.newBuilderWithInitialCapacity(resultLength);
        NamesBuilder names2 = NamesBuilder.withInitialCapacity(resultLength);
        int result_i = 0;
        if (times2.length() == 1) {
            for (int i = 0; i != resultLength; ++i) {
                int x_i = i / each % x.length();
                result.setFrom(result_i++, x, x_i);
                names2.add(x.getName(x_i));
            }
        } else {
            for (int x_i = 0; x_i != x.length(); ++x_i) {
                for (int j = 0; j < times2.getElementAsInt(x_i); ++j) {
                    result.setFrom(result_i++, x, x_i);
                    names2.add(x.getName(x_i));
                }
            }
        }
        if (x.getAttributes().hasNames()) {
            result.setAttribute(Symbols.NAMES, (SEXP)names2.buildEvenIfEmpty(resultLength));
        }
        return result.build();
    }
}

