/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;

public class HyperGeometric {
    private static double afc(int i) {
        double value;
        double[] al = new double[]{0.0, 0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.1780538303479458, 4.787491742782046, 6.579251212010101, 8.525161361065415};
        if (i < 0) {
            return -1.0;
        }
        if (i <= 7) {
            value = al[i + 1];
        } else {
            double di = i;
            value = (di + 0.5) * Math.log(di) - di + 0.08333333333333 / di - 0.00277777777777 / di / di / di + 0.9189385332;
        }
        return value;
    }

    public static class Random_hyper_geometric {
        static final double con = 57.56462733;
        static final double deltal = 0.0078;
        static final double deltau = 0.0034;
        static final double scale = 1.0E25;
        static int nn1;
        static int nn2;
        static int kk;
        static int i;
        static int ix;
        static boolean reject;
        static boolean setup1;
        static boolean setup2;
        static double e;
        static double f;
        static double g;
        static double p;
        static double r;
        static double t;
        static double u;
        static double v;
        static double y;
        static double de;
        static double dg;
        static double dr;
        static double ds;
        static double dt;
        static double gl;
        static double gu;
        static double nk;
        static double nm;
        static double ub;
        static double xk;
        static double xm;
        static double xn;
        static double y1;
        static double ym;
        static double yn;
        static double yk;
        static double alv;
        static int ks;
        static int n1s;
        static int n2s;
        static int k;
        static int m;
        static int minjx;
        static int maxjx;
        static int n1;
        static int n2;
        static double a;
        static double d;
        static double s;
        static double w;
        static double tn;
        static double xl;
        static double xr;
        static double kl;
        static double kr;
        static double lamdl;
        static double lamdr;
        static double p1;
        static double p2;
        static double p3;

        public static double rhyper(Session context, double nn1in, double nn2in, double kkin) {
            if (!(DoubleVector.isFinite(nn1in) && DoubleVector.isFinite(nn2in) && DoubleVector.isFinite(kkin))) {
                return Double.NaN;
            }
            nn1 = (int)Math.floor(nn1in + 0.5);
            nn2 = (int)Math.floor(nn2in + 0.5);
            kk = (int)Math.floor(kkin + 0.5);
            if (nn1 < 0 || nn2 < 0 || kk < 0 || kk > nn1 + nn2) {
                return Double.NaN;
            }
            reject = true;
            if (nn1 != n1s || nn2 != n2s) {
                setup1 = true;
                setup2 = true;
            } else if (kk != ks) {
                setup1 = false;
                setup2 = true;
            } else {
                setup1 = false;
                setup2 = false;
            }
            if (setup1) {
                n1s = nn1;
                n2s = nn2;
                tn = nn1 + nn2;
                if (nn1 <= nn2) {
                    n1 = nn1;
                    n2 = nn2;
                } else {
                    n1 = nn2;
                    n2 = nn1;
                }
            }
            if (setup2) {
                ks = kk;
                k = (double)(kk + kk) >= tn ? (int)(tn - (double)kk) : kk;
            }
            if (setup1 || setup2) {
                m = (int)(((double)k + 1.0) * ((double)n1 + 1.0) / (tn + 2.0));
                minjx = Math.max(0, k - n2);
                maxjx = Math.min(n1, k);
            }
            if (minjx == maxjx) {
                ix = maxjx;
                if ((double)(kk + kk) >= tn) {
                    ix = nn1 > nn2 ? kk - nn2 + ix : nn1 - ix;
                } else if (nn1 > nn2) {
                    ix = kk - ix;
                }
                return ix;
            }
            if (m - minjx < 10) {
                if (setup1 || setup2) {
                    w = k < n2 ? Math.exp(57.56462733 + HyperGeometric.afc(Random_hyper_geometric.n2) + HyperGeometric.afc(Random_hyper_geometric.n1 + Random_hyper_geometric.n2 - Random_hyper_geometric.k) - HyperGeometric.afc(Random_hyper_geometric.n2 - Random_hyper_geometric.k) - HyperGeometric.afc(Random_hyper_geometric.n1 + Random_hyper_geometric.n2)) : Math.exp(57.56462733 + HyperGeometric.afc(Random_hyper_geometric.n1) + HyperGeometric.afc(Random_hyper_geometric.k) - HyperGeometric.afc(Random_hyper_geometric.k - Random_hyper_geometric.n2) - HyperGeometric.afc(Random_hyper_geometric.n1 + Random_hyper_geometric.n2));
                }
            } else {
                if (setup1 || setup2) {
                    s = Math.sqrt((tn - (double)k) * (double)k * (double)n1 * (double)n2 / (tn - 1.0) / tn / tn);
                    d = (double)((int)(1.5 * s)) + 0.5;
                    xl = (double)m - d + 0.5;
                    xr = (double)m + d + 0.5;
                    a = HyperGeometric.afc(Random_hyper_geometric.m) + HyperGeometric.afc(Random_hyper_geometric.n1 - Random_hyper_geometric.m) + HyperGeometric.afc(Random_hyper_geometric.k - Random_hyper_geometric.m) + HyperGeometric.afc(Random_hyper_geometric.n2 - Random_hyper_geometric.k + Random_hyper_geometric.m);
                    kl = Math.exp(a - HyperGeometric.afc((int)Random_hyper_geometric.xl) - HyperGeometric.afc((int)((double)Random_hyper_geometric.n1 - Random_hyper_geometric.xl)) - HyperGeometric.afc((int)((double)Random_hyper_geometric.k - Random_hyper_geometric.xl)) - HyperGeometric.afc((int)((double)(Random_hyper_geometric.n2 - Random_hyper_geometric.k) + Random_hyper_geometric.xl)));
                    kr = Math.exp(a - HyperGeometric.afc((int)(Random_hyper_geometric.xr - 1.0)) - HyperGeometric.afc((int)((double)Random_hyper_geometric.n1 - Random_hyper_geometric.xr + 1.0)) - HyperGeometric.afc((int)((double)Random_hyper_geometric.k - Random_hyper_geometric.xr + 1.0)) - HyperGeometric.afc((int)((double)(Random_hyper_geometric.n2 - Random_hyper_geometric.k) + Random_hyper_geometric.xr - 1.0)));
                    lamdl = -Math.log(xl * ((double)(n2 - k) + xl) / ((double)n1 - xl + 1.0) / ((double)k - xl + 1.0));
                    lamdr = -Math.log(((double)n1 - xr + 1.0) * ((double)k - xr + 1.0) / xr / ((double)(n2 - k) + xr));
                    p1 = d + d;
                    p2 = p1 + kl / lamdl;
                    p3 = p2 + kr / lamdr;
                }
                Random_hyper_geometric.L30(context);
                if ((double)(kk + kk) >= tn) {
                    ix = nn1 > nn2 ? kk - nn2 + ix : nn1 - ix;
                } else if (nn1 > nn2) {
                    ix = kk - ix;
                }
                return ix;
            }
            Random_hyper_geometric.L10(context);
            Random_hyper_geometric.L20(context);
            return ix;
        }

        public static void L10(Session context) {
            p = w;
            ix = minjx;
            u = context.rng.unif_rand() * 1.0E25;
            Random_hyper_geometric.L20(context);
        }

        public static void L20(Session context) {
            if (u > p) {
                u -= p;
                p *= (double)((n1 - ix) * (k - ix));
                p = p / (double)(++ix) / (double)(n2 - k + ix);
                if (ix > maxjx) {
                    Random_hyper_geometric.L10(context);
                }
                Random_hyper_geometric.L20(context);
            }
        }

        public static void L30(Session context) {
            u = context.rng.unif_rand() * p3;
            v = context.rng.unif_rand();
            if (u < p1) {
                ix = (int)(xl + u);
            } else if (u <= p2) {
                ix = (int)(xl + Math.log(v) / lamdl);
                if (ix < minjx) {
                    Random_hyper_geometric.L30(context);
                }
                v = v * (u - p1) * lamdl;
            } else {
                ix = (int)(xr - Math.log(v) / lamdr);
                if (ix > maxjx) {
                    Random_hyper_geometric.L30(context);
                }
                v = v * (u - p2) * lamdr;
            }
            if (m < 100 || ix <= 50) {
                f = 1.0;
                if (m < ix) {
                    for (i = m + 1; i <= ix; ++i) {
                        f = f * (double)(n1 - i + 1) * (double)(k - i + 1) / (double)(n2 - k + i) / (double)i;
                    }
                } else if (m > ix) {
                    for (i = ix + 1; i <= m; ++i) {
                        f = f * (double)i * (double)(n2 - k + i) / (double)(n1 - i + 1) / (double)(k - i + 1);
                    }
                }
                if (v <= f) {
                    reject = false;
                }
            } else {
                y = ix;
                y1 = y + 1.0;
                ym = y - (double)m;
                yn = (double)n1 - y + 1.0;
                yk = (double)k - y + 1.0;
                nk = (double)(n2 - k) + y1;
                r = -ym / y1;
                s = ym / yn;
                t = ym / yk;
                e = -ym / nk;
                g = yn * yk / (y1 * nk) - 1.0;
                dg = 1.0;
                if (g < 0.0) {
                    dg = 1.0 + g;
                }
                gu = g * (1.0 + g * (-0.5 + g / 3.0));
                gl = gu - 0.25 * (g * g * g * g) / dg;
                xm = (double)m + 0.5;
                xn = (double)(n1 - m) + 0.5;
                xk = (double)(k - m) + 0.5;
                nm = (double)(n2 - k) + xm;
                ub = y * gu - (double)m * gl + 0.0034 + xm * r * (1.0 + r * (-0.5 + r / 3.0)) + xn * s * (1.0 + s * (-0.5 + s / 3.0)) + xk * t * (1.0 + t * (-0.5 + t / 3.0)) + nm * e * (1.0 + e * (-0.5 + e / 3.0));
                alv = Math.log(v);
                if (alv > ub) {
                    reject = true;
                } else {
                    dr = xm * (r * r * r * r);
                    if (r < 0.0) {
                        dr /= 1.0 + r;
                    }
                    ds = xn * (s * s * s * s);
                    if (s < 0.0) {
                        ds /= 1.0 + s;
                    }
                    dt = xk * (t * t * t * t);
                    if (t < 0.0) {
                        dt /= 1.0 + t;
                    }
                    de = nm * (e * e * e * e);
                    if (e < 0.0) {
                        de /= 1.0 + e;
                    }
                    reject = alv < ub - 0.25 * (dr + ds + dt + de) + (y + (double)m) * (gl - gu) - 0.0078 ? false : !(alv <= a - HyperGeometric.afc(Random_hyper_geometric.ix) - HyperGeometric.afc(Random_hyper_geometric.n1 - Random_hyper_geometric.ix) - HyperGeometric.afc(Random_hyper_geometric.k - Random_hyper_geometric.ix) - HyperGeometric.afc(Random_hyper_geometric.n2 - Random_hyper_geometric.k + Random_hyper_geometric.ix));
                }
            }
            if (reject) {
                Random_hyper_geometric.L30(context);
            }
        }

        static {
            ks = -1;
            n1s = -1;
            n2s = -1;
        }
    }
}

