/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.stats.internals.distributions.Gamma;
import org.renjin.stats.internals.distributions.Poisson;

public class NegativeBinom {
    public static double rnbinom(Session context, double size, double prob) {
        if (Double.isInfinite(size) || Double.isInfinite(prob) || size <= 0.0 || prob <= 0.0 || prob > 1.0) {
            return Double.NaN;
        }
        return prob == 1.0 ? 0.0 : Poisson.rpois(context, Gamma.rgamma(context, size, (1.0 - prob) / prob));
    }

    public static double rnbinom_mu(Session context, double size, double mu) {
        if (Double.isInfinite(size) || Double.isInfinite(mu) || size <= 0.0 || mu < 0.0) {
            return Double.NaN;
        }
        return mu == 0.0 ? 0.0 : Poisson.rpois(context, Gamma.rgamma(context, size, mu / size));
    }
}

