/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.scijava.script.ScriptLanguage;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.JTextAreaWriter;

public class ErrorParser {
    private static final Color COLOR = Color.RED;
    private TreeSet<Integer> errorLines;
    private int lineOffset;
    private boolean enabled;
    private final EditorPane editorPane;
    private JTextAreaWriter writer;
    private int lengthOfJTextAreaWriter;
    private ErrorStripNotifyingParser notifyingParser;
    private boolean parsingSucceeded;

    public ErrorParser(EditorPane editorPane) {
        this.editorPane = editorPane;
        this.lineOffset = 0;
    }

    public void gotoPreviousError() {
        if (!this.isCaretMovable()) {
            try {
                int caretLine = this.editorPane.getCaretLineNumber();
                this.gotoLine(this.errorLines.lower(caretLine));
            }
            catch (NullPointerException ignored) {
                this.gotoLine(this.errorLines.last());
            }
        }
    }

    public void gotoNextError() {
        if (this.isCaretMovable()) {
            try {
                int caretLine = this.editorPane.getCaretLineNumber();
                this.gotoLine(this.errorLines.higher(caretLine));
            }
            catch (NullPointerException ignored) {
                this.gotoLine(this.errorLines.first());
            }
        }
    }

    public void reset() {
        if (this.notifyingParser != null) {
            this.editorPane.removeParser((Parser)this.notifyingParser);
            this.editorPane.removeAllLineHighlights();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLineOffset(int zeroBasedlineOffset) {
        this.lineOffset = zeroBasedlineOffset;
    }

    public void setSelectedCodeExecution(boolean selectedExecution) {
        if (selectedExecution) {
            int p1;
            int p0 = Math.min(this.editorPane.getCaret().getDot(), this.editorPane.getCaret().getMark());
            if (p0 != (p1 = Math.max(this.editorPane.getCaret().getDot(), this.editorPane.getCaret().getMark()))) {
                try {
                    this.lineOffset = this.editorPane.getLineOfOffset(p0);
                }
                catch (BadLocationException ignored) {
                    this.lineOffset = -1;
                }
            } else {
                this.lineOffset = -1;
            }
        } else {
            this.lineOffset = 0;
        }
    }

    public void setWriter(JTextAreaWriter writer) {
        this.writer = writer;
        this.lengthOfJTextAreaWriter = writer.textArea.getText().length();
    }

    public void parse() {
        if (this.writer == null) {
            throw new IllegalArgumentException("Writer is null");
        }
        this.parse(this.writer.textArea.getText().substring(this.lengthOfJTextAreaWriter));
    }

    public void parse(Throwable t) {
        if (!this.enabled) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        this.parse(sw.toString());
    }

    private boolean isImageJMacro() {
        ScriptLanguage lang = this.editorPane.getCurrentLanguage();
        if (lang == null) {
            return false;
        }
        String name = lang.getLanguageName();
        return name.equals("ImageJ Macro") || name.equals("IJ1 Macro");
    }

    public boolean isLogDetailed() {
        if (!this.isImageJMacro()) {
            return this.parsingSucceeded;
        }
        for (Window win : Window.getWindows()) {
            if (win == null || !(win instanceof Dialog) || !"Macro Error".equals(((Dialog)win).getTitle())) continue;
            return true;
        }
        return this.parsingSucceeded;
    }

    private boolean isCaretMovable() {
        if (this.errorLines == null || this.errorLines.isEmpty()) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)this.editorPane));
            return false;
        }
        return true;
    }

    private void gotoLine(int lineNumber) {
        try {
            this.editorPane.setCaretPosition(this.editorPane.getLineStartOffset(lineNumber));
            Rectangle rect = this.editorPane.modelToView(this.editorPane.getCaretPosition());
            this.editorPane.scrollRectToVisible(rect);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.editorPane.requestFocusInWindow();
        }
    }

    private void parse(String errorLog) {
        ScriptLanguage lang = this.editorPane.getCurrentLanguage();
        if (lang == null) {
            this.abort();
            return;
        }
        boolean isIJM = this.isImageJMacro();
        if (isIJM) {
            this.abort("Execution errors handled by the Macro Interpreter. Use the Interpreter's Debug option for error tracking", false);
            return;
        }
        if (!this.enabled) {
            this.abort("Execution errors are not highlighted when auto-imports are active", true);
            return;
        }
        if (this.lineOffset == -1) {
            this.abort("Code selection unknown: Erros are not highlighted in the Editor", true);
            return;
        }
        boolean isJava = "Java".equals(lang.getLanguageName());
        String fileName = this.editorPane.getFileName();
        if (isJava && fileName == null) {
            this.abort();
            return;
        }
        if ("Scala".equals(lang.getLanguageName())) {
            this.lineOffset += 10;
        } else if ("R".equals(lang.getLanguageName())) {
            ++this.lineOffset;
        }
        this.errorLines = new TreeSet();
        StringTokenizer tokenizer = new StringTokenizer(errorLog, "\n");
        if (isJava) {
            while (tokenizer.hasMoreTokens()) {
                this.parseJava(fileName, tokenizer.nextToken(), this.errorLines);
            }
        } else {
            while (tokenizer.hasMoreTokens()) {
                this.parseNonJava(tokenizer.nextToken(), this.errorLines);
            }
        }
        if (!this.errorLines.isEmpty()) {
            this.notifyingParser = new ErrorStripNotifyingParser();
            this.editorPane.addParser((Parser)this.notifyingParser);
            this.editorPane.forceReparsing((Parser)this.notifyingParser);
            this.gotoLine(this.errorLines.first());
        }
        this.parsingSucceeded = true;
    }

    private void parseNonJava(String lineText, Collection<Integer> errorLines) {
        if (lineText.indexOf(":classloader:") > -1 || lineText.indexOf(".org.python.") > -1 || lineText.indexOf(".codehaus.groovy.") > -1 || lineText.indexOf(".tools.nsc.") > -1 || lineText.indexOf("at bsh.") > -1 || lineText.indexOf("$Recompilation$") > -1) {
            return;
        }
        int extensionIdx = this.extensionIdx(lineText);
        int lineIdx = lineText.toLowerCase().indexOf("line");
        if (lineIdx < 0 && extensionIdx < 0 && this.filenameIdx(lineText) < 0) {
            return;
        }
        this.extractLineIndicesFromFilteredTextLines(lineText, errorLines);
    }

    private void extractLineIndicesFromFilteredTextLines(String lineText, Collection<Integer> errorLines) {
        Pattern pattern = Pattern.compile(":(\\d+)|line\\D*(\\d+)", 2);
        Matcher matcher = pattern.matcher(lineText);
        if (matcher.find()) {
            try {
                String firstGroup = matcher.group(1);
                String lastGroup = matcher.group(matcher.groupCount());
                String group = firstGroup == null ? lastGroup : firstGroup;
                int lineNumber = Integer.valueOf(group.trim());
                if (lineNumber > 0) {
                    errorLines.add(lineNumber - 1 + this.lineOffset);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    private int extensionIdx(String line) {
        int dotIndex = -1;
        for (String extension : this.editorPane.getCurrentLanguage().getExtensions()) {
            dotIndex = line.indexOf("." + extension);
            if (dotIndex <= -1) continue;
            return dotIndex;
        }
        return -1;
    }

    private int filenameIdx(String line) {
        int index = line.indexOf(this.editorPane.getFileName());
        if (index == -1) {
            index = line.indexOf(" Script");
        }
        return index;
    }

    private void parseJava(String filename, String line, Collection<Integer> errorLines) {
        int colon = line.indexOf(filename);
        if (colon <= 0) {
            return;
        }
        int next = line.indexOf(58, (colon += filename.length()) + 1);
        if (next < colon + 2) {
            return;
        }
        try {
            int lineNumber = Integer.parseInt(line.substring(colon + 1, next));
            if (lineNumber > 0) {
                errorLines.add(lineNumber - 1 + this.lineOffset);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void abort() {
        this.parsingSucceeded = false;
    }

    private void abort(String msg, boolean offsetNotice) {
        this.abort();
        if (this.writer != null) {
            String finalMsg = "[INFO] " + msg + "\n";
            if (offsetNotice) {
                finalMsg = finalMsg + "[INFO] Reported error line(s) may not match line numbers in the editor\n";
            }
            this.writer.textArea.insert(finalMsg, this.lengthOfJTextAreaWriter);
        }
        this.errorLines = null;
    }

    private Color highlightColor() {
        Color c1 = this.editorPane.getCurrentLineHighlightColor();
        Color c2 = this.editorPane.getBackground() == null ? COLOR : this.editorPane.getBackground();
        return ErrorParser.averageColors(c1, c2);
    }

    protected static Color averageColors(Color c1, Color c2) {
        int r = (int)Math.sqrt((Math.pow(c1.getRed(), 2.0) + Math.pow(c2.getRed(), 2.0)) / 2.0);
        int g = (int)Math.sqrt((Math.pow(c1.getGreen(), 2.0) + Math.pow(c2.getGreen(), 2.0)) / 2.0);
        int b = (int)Math.sqrt((Math.pow(c1.getBlue(), 2.0) + Math.pow(c2.getGreen(), 2.0)) / 2.0);
        return new Color(r, g, b, c1.getAlpha());
    }

    public static void main(String[] args) throws Exception {
        String groovy = "\tat Script1.run(Script1.groovy:51)";
        String python = "File \"New_.py\", line 51, in <module>";
        String ruby = "<main> at Batch_Convert.rb:51";
        String scala = " at line number 51 at column number 18";
        String beanshell = "or class name: Systesm : at Line: 51 : in file: ";
        String javascript = "\tat jdk.nashorn.internal.scripts.Script$15$Greeting.:program(Greeting.js:51)";
        Arrays.asList("\tat Script1.run(Script1.groovy:51)", "File \"New_.py\", line 51, in <module>", "<main> at Batch_Convert.rb:51", " at line number 51 at column number 18", "or class name: Systesm : at Line: 51 : in file: ", "\tat jdk.nashorn.internal.scripts.Script$15$Greeting.:program(Greeting.js:51)").forEach(lang -> {
            ErrorParser parser = new ErrorParser(new EditorPane());
            TreeSet<Integer> errorLines = new TreeSet<Integer>();
            parser.extractLineIndicesFromFilteredTextLines((String)lang, (Collection<Integer>)errorLines);
            assert (errorLines.first() == 50);
            System.out.println((errorLines.first() == 50) + ": <<" + lang + ">> ");
        });
    }

    class ErrorNotice
    extends DefaultParserNotice {
        public ErrorNotice(Parser parser, int line) {
            super(parser, "Run Error: Line " + (line + 1), line);
            this.setColor(COLOR);
            this.setLevel(ParserNotice.Level.ERROR);
            this.setShowInEditor(true);
        }
    }

    class ErrorStripNotifyingParser
    extends AbstractParser {
        private final DefaultParseResult result = new DefaultParseResult((Parser)this);
        private final boolean highlightAbnoxiously = true;

        public boolean isEnabled() {
            return ErrorParser.this.enabled && ErrorParser.this.errorLines != null;
        }

        public ParseResult parse(RSyntaxDocument doc, String style) {
            Element root = doc.getDefaultRootElement();
            int lineCount = root.getElementCount();
            this.result.clearNotices();
            this.result.setParsedLines(0, lineCount - 1);
            if (this.isEnabled() && !"text/plain".equals(style)) {
                ErrorParser.this.errorLines.forEach(line -> this.result.addNotice((ParserNotice)new ErrorNotice((Parser)this, (int)line)));
                Color c = ErrorParser.this.highlightColor();
                ErrorParser.this.errorLines.forEach(line -> {
                    try {
                        ErrorParser.this.editorPane.addLineHighlight((int)line, c);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                });
            }
            return this.result;
        }
    }
}

