/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.cal;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ChannelDisplayProperties {
    private ColorModel colorModel;
    private double minValue;
    private double maxValue;
    private double minThreshold;
    private double maxThreshold;
    private int lutUpdateMode;
    private boolean displayedGray;
    private boolean displayedInOverlay;

    public ChannelDisplayProperties() {
        byte[] lut = new byte[256];
        for (int i = 0; i < 256; ++i) {
            lut[i] = (byte)i;
        }
        this.colorModel = new IndexColorModel(8, 256, lut, lut, lut);
        this.minValue = 0.0;
        this.maxValue = 255.0;
        this.minThreshold = -808080.0;
        this.maxThreshold = -808080.0;
        this.displayedGray = false;
        this.displayedInOverlay = true;
        this.lutUpdateMode = 0;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public void setMaxThreshold(double maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public void setMinThreshold(double minThreshold) {
        this.minThreshold = minThreshold;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public boolean isDisplayedGray() {
        return this.displayedGray;
    }

    public void setDisplayedGray(boolean displayGray) {
        this.displayedGray = displayGray;
    }

    public boolean isDisplayedInOverlay() {
        return this.displayedInOverlay;
    }

    public void setDisplayedInOverlay(boolean displayedInOverlay) {
        this.displayedInOverlay = displayedInOverlay;
    }

    public int getLutUpdateMode() {
        return this.lutUpdateMode;
    }

    public void setLutUpdateMode(int lutUpdateMode) {
        this.lutUpdateMode = lutUpdateMode;
    }

    public static IndexColorModel createModelFromColor(Color color) {
        byte[] rLut = new byte[256];
        byte[] gLut = new byte[256];
        byte[] bLut = new byte[256];
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double rIncr = (double)red / 255.0;
        double gIncr = (double)green / 255.0;
        double bIncr = (double)blue / 255.0;
        for (int i = 0; i < 256; ++i) {
            rLut[i] = (byte)((double)i * rIncr);
            gLut[i] = (byte)((double)i * gIncr);
            bLut[i] = (byte)((double)i * bIncr);
        }
        return new IndexColorModel(8, 256, rLut, gLut, bLut);
    }

    public ChannelDisplayProperties copy() {
        ChannelDisplayProperties ccp = new ChannelDisplayProperties();
        ccp.setColorModel(this.getColorModel());
        ccp.setMinValue(this.getMinValue());
        ccp.setMaxValue(this.getMaxValue());
        ccp.setMinThreshold(this.getMinThreshold());
        ccp.setMaxThreshold(this.getMaxThreshold());
        ccp.setLutUpdateMode(this.getLutUpdateMode());
        ccp.setDisplayedGray(this.isDisplayedGray());
        ccp.setDisplayedInOverlay(this.isDisplayedInOverlay());
        return ccp;
    }
}

