/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.TiffDecoder;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import sc.fiji.i5d.Image5D;
import sc.fiji.i5d.cal.ChannelCalibration;
import sc.fiji.i5d.cal.ChannelDisplayProperties;

public class Open_Image5D
implements PlugIn {
    public static final int tagLUT = 0x4C5554;
    public static final int tagCB = 4400706;
    public static final int tagTHR = 5523538;
    public static final int tagGRA = 4674113;
    public static final int tagOVL = 5199436;
    public static final int tagLBL = 0x4C424C;
    public static final int tagCAL = 4407628;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String arg) {
        IJ.register(Open_Image5D.class);
        if (IJ.versionLessThan((String)"1.35c")) {
            return;
        }
        OpenDialog od = new OpenDialog("Open Image5D", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name != null) {
            TiffDecoder td = new TiffDecoder(directory, name);
            if (IJ.debugMode) {
                td.enableDebugging();
            }
            FileInfo[] info = null;
            try {
                info = td.getTiffInfo();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg == null || msg.equals("")) {
                    msg = "" + e;
                }
                IJ.error((String)"TiffDecoder", (String)msg);
                return;
            }
            if (info == null) {
                return;
            }
            switch (info[0].fileType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 11: {
                    break;
                }
                default: {
                    IJ.error((String)"Unsupported image type.");
                    return;
                }
            }
            ImagePlus imp = null;
            if (info.length > 1) {
                imp = new Opener().openTiffStack(info);
            } else {
                FileOpener fo = new FileOpener(info[0]);
                imp = fo.open(false);
            }
            if (imp != null) {
                int tLength;
                String title = imp.getTitle();
                int nChannels = imp.getNChannels();
                int nSlices = imp.getNSlices();
                int nFrames = imp.getNFrames();
                Image5D i5d = new Image5D(title, imp.getImageStack(), nChannels, nSlices, nFrames);
                i5d.setCalibration(imp.getCalibration().copy());
                boolean[] hasLUT = new boolean[nChannels];
                String description = info[0].description;
                if (description != null && description.length() >= 7 && description.startsWith("ImageJ")) {
                    Properties props = new Properties();
                    ByteArrayInputStream is = new ByteArrayInputStream(description.getBytes());
                    try {
                        props.load(is);
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        IJ.error((String)("Exception reading properties: " + e.getMessage()));
                    }
                    if (props.getProperty("Image5D", null) != null) {
                        int c;
                        int[] metaDataTypes = info[0].metaDataTypes;
                        byte[][] metaData = info[0].metaData;
                        ChannelCalibration[] chCalibration = new ChannelCalibration[nChannels];
                        ChannelDisplayProperties[] chDispProps = new ChannelDisplayProperties[nChannels];
                        for (c = 1; c <= nChannels; ++c) {
                            chCalibration[c - 1] = new ChannelCalibration();
                            chDispProps[c - 1] = new ChannelDisplayProperties();
                        }
                        if (metaDataTypes != null) {
                            for (int n = 0; n < metaDataTypes.length; ++n) {
                                try {
                                    int tag = metaDataTypes[n];
                                    ByteArrayInputStream bs = new ByteArrayInputStream(metaData[n]);
                                    DataInputStream ds = new DataInputStream(bs);
                                    switch (tag) {
                                        case 0x4C5554: {
                                            int channel;
                                            int entryType = ds.readInt();
                                            switch (entryType) {
                                                case 1: {
                                                    channel = ds.readInt();
                                                    if (channel >= 1) {
                                                        if (channel > nChannels) break;
                                                        byte[] rLut = new byte[256];
                                                        byte[] gLut = new byte[256];
                                                        byte[] bLut = new byte[256];
                                                        ds.read(rLut);
                                                        ds.read(gLut);
                                                        ds.read(bLut);
                                                        chDispProps[channel - 1].setColorModel(new IndexColorModel(8, 256, rLut, gLut, bLut));
                                                        hasLUT[channel - 1] = true;
                                                    } else {
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                        case 4400706: {
                                            int channel;
                                            int entryType = ds.readInt();
                                            switch (entryType) {
                                                case 1: {
                                                    channel = ds.readInt();
                                                    if (channel >= 1) {
                                                        if (channel > nChannels) break;
                                                        chDispProps[channel - 1].setMinValue(ds.readDouble());
                                                        chDispProps[channel - 1].setMaxValue(ds.readDouble());
                                                    } else {
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                        case 5523538: {
                                            int channel;
                                            int entryType = ds.readInt();
                                            switch (entryType) {
                                                case 1: {
                                                    channel = ds.readInt();
                                                    if (channel >= 1) {
                                                        if (channel > nChannels) break;
                                                        chDispProps[channel - 1].setMinThreshold(ds.readDouble());
                                                        chDispProps[channel - 1].setMaxThreshold(ds.readDouble());
                                                        chDispProps[channel - 1].setLutUpdateMode(ds.readInt());
                                                    } else {
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                        case 4674113: {
                                            int channel;
                                            int entryType = ds.readInt();
                                            switch (entryType) {
                                                case 1: {
                                                    channel = ds.readInt();
                                                    if (channel >= 1) {
                                                        if (channel > nChannels) break;
                                                        chDispProps[channel - 1].setDisplayedGray(ds.readBoolean());
                                                    } else {
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                        case 5199436: {
                                            int channel;
                                            int entryType = ds.readInt();
                                            switch (entryType) {
                                                case 1: {
                                                    channel = ds.readInt();
                                                    if (channel >= 1) {
                                                        if (channel > nChannels) break;
                                                        chDispProps[channel - 1].setDisplayedInOverlay(ds.readBoolean());
                                                    } else {
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                        case 0x4C424C: {
                                            int channel;
                                            int entryType = ds.readInt();
                                            switch (entryType) {
                                                case 1: {
                                                    channel = ds.readInt();
                                                    if (channel >= 1) {
                                                        if (channel > nChannels) break;
                                                        byte[] temp = new byte[metaData[n].length - 8];
                                                        ds.read(temp);
                                                        chCalibration[channel - 1].setLabel(new String(temp));
                                                    } else {
                                                        break;
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                        case 4407628: {
                                            int channel;
                                            int entryType = ds.readInt();
                                            switch (entryType) {
                                                case 1: {
                                                    channel = ds.readInt();
                                                    if (channel < 1 || channel > nChannels) break;
                                                    int funct = ds.readInt();
                                                    int num = ds.readInt();
                                                    double[] coeff = new double[num];
                                                    for (int i = 0; i < num; ++i) {
                                                        coeff[i] = ds.readDouble();
                                                    }
                                                    boolean zeroClip = ds.readBoolean();
                                                    byte[] temp = new byte[metaData[n].length - 16 - num * 8 - 1];
                                                    ds.read(temp);
                                                    chCalibration[channel - 1].setFunction(funct, coeff, new String(temp), zeroClip);
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    bs.close();
                                    continue;
                                }
                                catch (IOException e) {
                                    IJ.log((String)("Exception reading metadata entry: " + n + " tag: " + metaDataTypes[n] + "\n" + e.getMessage()));
                                }
                            }
                            for (c = 1; c <= nChannels; ++c) {
                                i5d.setChannelCalibration(c, chCalibration[c - 1]);
                                i5d.setChannelDisplayProperties(c, chDispProps[c - 1]);
                                i5d.restoreChannelProperties(c);
                            }
                        }
                    }
                }
                for (int c = 0; c < nChannels; ++c) {
                    if (hasLUT[c]) continue;
                    i5d.setChannelColorModel(c + 1, ChannelDisplayProperties.createModelFromColor(Color.getHSBColor(1.0f / (float)nChannels * (float)c, 1.0f, 1.0f)));
                }
                title = i5d.getTitle();
                if (title.substring((tLength = title.length()) - 4, tLength).equalsIgnoreCase(".tif")) {
                    title = title.substring(0, tLength - 4);
                } else if (title.substring(tLength - 5, tLength).equalsIgnoreCase(".tiff")) {
                    title = title.substring(0, tLength - 5);
                }
                i5d.setTitle(title);
                i5d.setCurrentPosition(0, 0, 0, 0, 0);
                i5d.show();
            }
        }
    }
}

