/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.Objects;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.universe.metadata.AbstractN5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.IntensityMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialModifiable;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.TransformUtils;

public class N5SingleScaleMetadata
extends AbstractN5SpatialDatasetMetadata
implements SpatialModifiable<N5SingleScaleMetadata> {
    private final AffineTransform3D transform;
    private final String unit;
    private final double[] downsamplingFactors;
    private final double[] pixelResolution;
    private final double[] offset;
    private final Double minIntensity;
    private final Double maxIntensity;
    private final boolean isLabelMultiset;

    public N5SingleScaleMetadata(String path, AffineTransform3D transform, double[] downsamplingFactors, double[] pixelResolution, double[] offset, String unit, DatasetAttributes attributes) {
        this(path, transform, downsamplingFactors, pixelResolution, offset, unit, attributes, null, null, false);
    }

    public N5SingleScaleMetadata(String path, AffineTransform3D transform, double[] downsamplingFactors, double[] pixelResolution, double[] offset, String unit, DatasetAttributes attributes, boolean isLabelMultiset) {
        this(path, transform, downsamplingFactors, pixelResolution, offset, unit, attributes, null, null, isLabelMultiset);
    }

    public N5SingleScaleMetadata(String path, AffineTransform3D transform, double[] downsamplingFactors, double[] pixelResolution, double[] offset, String unit, DatasetAttributes attributes, Double minIntensity, Double maxIntensity, boolean isLabelMultiset) {
        super(path, attributes);
        Objects.requireNonNull(path);
        Objects.requireNonNull(transform);
        Objects.requireNonNull(downsamplingFactors);
        Objects.requireNonNull(pixelResolution);
        Objects.requireNonNull(offset);
        this.transform = transform;
        this.downsamplingFactors = downsamplingFactors;
        this.pixelResolution = pixelResolution;
        this.offset = offset;
        Double defaultMaxIntensity = attributes != null ? IntensityMetadata.maxForDataType(attributes.getDataType()) : new Double(255.0);
        this.minIntensity = minIntensity != null ? minIntensity : 0.0;
        this.maxIntensity = maxIntensity != null ? maxIntensity : defaultMaxIntensity;
        this.isLabelMultiset = isLabelMultiset;
        this.unit = unit == null ? "pixel" : unit;
    }

    @Override
    public AffineGet spatialTransform() {
        return this.transform.copy();
    }

    @Override
    public String unit() {
        return this.unit;
    }

    @Override
    public double minIntensity() {
        return this.minIntensity;
    }

    @Override
    public double maxIntensity() {
        return this.maxIntensity;
    }

    public double[] getPixelResolution() {
        return this.pixelResolution;
    }

    public double[] getOffset() {
        return this.offset;
    }

    public double[] getDownsamplingFactors() {
        return this.downsamplingFactors;
    }

    public boolean isLabelMultiset() {
        return this.isLabelMultiset;
    }

    @Override
    public N5SingleScaleMetadata modifySpatialTransform(String newPath, AffineGet relativeTransformation) {
        int nd = relativeTransformation.numDimensions();
        AffineGet transform = nd == 4 ? TransformUtils.subAffine(relativeTransformation, new int[]{0, 1, 2}) : (nd == 2 ? TransformUtils.superAffine(relativeTransformation, 3, new int[]{0, 1}) : relativeTransformation);
        AffineTransform3D newTransform = new AffineTransform3D();
        newTransform.preConcatenate(this.spatialTransform());
        newTransform.preConcatenate(transform);
        double[] newScale = new double[nd];
        double[] newTranslation = new double[nd];
        int j = 0;
        for (int i = 0; i < nd; ++i) {
            if (nd <= 3) {
                newScale[i] = newTransform.get(j, j);
                newTranslation[i] = newTransform.get(j, nd);
            } else {
                newScale[i] = 1.0;
                newTranslation[i] = 0.0;
            }
            ++j;
        }
        return new N5SingleScaleMetadata(newPath, newTransform, this.downsamplingFactors, newScale, newTranslation, this.unit, this.getAttributes(), this.minIntensity, this.maxIntensity, this.isLabelMultiset);
    }
}

