/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractCoordinateTransform;

public class ThinPlateSplineCoordinateTransform
extends AbstractCoordinateTransform<ThinplateSplineTransform> {
    public static final String TYPE = "thin-plate-spline";
    protected int numDimensions;
    protected double[][] movingPoints;
    protected double[][] targetPoints;
    protected double[][] affine;
    protected double[] translation;
    protected double[] weights;
    protected transient ThinplateSplineTransform tps;

    public ThinPlateSplineCoordinateTransform(double[][] movingPoints, double[][] targetPoints) {
        this("", null, null, movingPoints, targetPoints);
    }

    public ThinPlateSplineCoordinateTransform(String input, String output, double[][] movingPoints, double[][] targetPoints) {
        this("", input, output, movingPoints, targetPoints);
    }

    public ThinPlateSplineCoordinateTransform(String name, String input, String output, double[][] movingPoints, double[][] targetPoints) {
        super(TYPE, name, input, output);
        this.movingPoints = movingPoints;
        this.targetPoints = targetPoints;
        this.tps = new ThinplateSplineTransform(movingPoints, targetPoints);
        this.numDimensions = movingPoints.length;
    }

    public ThinPlateSplineCoordinateTransform(ThinplateSplineTransform tps) {
        this("", null, null, tps);
    }

    public ThinPlateSplineCoordinateTransform(String input, String output, ThinplateSplineTransform tps) {
        this("", input, output, tps);
    }

    public ThinPlateSplineCoordinateTransform(String name, String input, String output, ThinplateSplineTransform tps) {
        this(name, input, output, tps.getKernelTransform());
    }

    public ThinPlateSplineCoordinateTransform(ThinPlateR2LogRSplineKernelTransform tps) {
        this("", null, null, tps);
    }

    public ThinPlateSplineCoordinateTransform(String input, String output, ThinPlateR2LogRSplineKernelTransform tps) {
        this("", input, output, tps);
    }

    public ThinPlateSplineCoordinateTransform(String name, String input, String output, ThinPlateR2LogRSplineKernelTransform tps) {
        super(TYPE, name, input, output);
        this.movingPoints = tps.getSourceLandmarks();
        this.affine = tps.getAffine();
        this.translation = tps.getTranslation();
        this.weights = tps.getKnotWeights();
        this.tps = new ThinplateSplineTransform(tps);
        this.numDimensions = this.tps.numSourceDimensions();
    }

    @Override
    public ThinplateSplineTransform getTransform() {
        if (this.tps == null) {
            if (this.targetPoints != null) {
                this.tps = new ThinplateSplineTransform(this.movingPoints, this.targetPoints);
            } else if (this.weights != null) {
                this.tps = new ThinplateSplineTransform(new ThinPlateR2LogRSplineKernelTransform(this.movingPoints, this.affine, this.translation, this.weights));
            }
        }
        return this.tps;
    }
}

