/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.Variance.class, label="Haralick: Variance")
public class DefaultVariance<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.Variance {
    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        int nrGreyLevel = matrix.length;
        double mean = 0.0;
        for (int i = 0; i < nrGreyLevel; ++i) {
            for (int j = 0; j < nrGreyLevel; ++j) {
                mean += matrix[i][j];
            }
        }
        mean /= (double)(nrGreyLevel * nrGreyLevel);
        double result = 0.0;
        for (int i = 0; i < nrGreyLevel; ++i) {
            for (int j = 0; j < nrGreyLevel; ++j) {
                result += ((double)i - mean) * ((double)i - mean) * matrix[i][j];
            }
        }
        output.set(result);
    }
}

