/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.mesh.Mesh;
import net.imagej.mesh.Triangle;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.commons.math3.util.MathArrays;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Size.class, label="Geometric3D: Volume", priority=9999.0)
public class DefaultVolumeMesh
extends AbstractUnaryFunctionOp<Mesh, DoubleType>
implements Ops.Geometric.Size {
    @Override
    public DoubleType calculate(Mesh input) {
        double volume = 0.0;
        for (Triangle triangle : input.triangles()) {
            volume += this.signedVolumeOfTriangle(triangle.v0x(), triangle.v0y(), triangle.v0z(), triangle.v1x(), triangle.v1y(), triangle.v1z(), triangle.v2x(), triangle.v2y(), triangle.v2z());
        }
        return new DoubleType(Math.abs(volume));
    }

    private double signedVolumeOfTriangle(double p0x, double p0y, double p0z, double p1x, double p1y, double p1z, double p2x, double p2y, double p2z) {
        double cpx = MathArrays.linearCombination((double)p1y, (double)p2z, (double)(-p1z), (double)p2y);
        double cpy = MathArrays.linearCombination((double)p1z, (double)p2x, (double)(-p1x), (double)p2z);
        double cpz = MathArrays.linearCombination((double)p1x, (double)p2y, (double)(-p1y), (double)p2x);
        return MathArrays.linearCombination((double)p0x, (double)cpx, (double)p0y, (double)cpy, (double)p0z, (double)cpz) / 6.0;
    }
}

