/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.localMean;

import net.imagej.ops.Ops;
import net.imagej.ops.map.neighborhood.CenterAwareComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.threshold.LocalThresholdMethod;
import net.imagej.ops.threshold.apply.LocalThreshold;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.LocalMeanThreshold.class, priority=-100.0)
public class LocalMeanThreshold<T extends RealType<T>>
extends LocalThreshold<T>
implements Ops.Threshold.LocalMeanThreshold {
    @Parameter
    private double c;

    @Override
    protected CenterAwareComputerOp<T, BitType> unaryComputer(T inClass, BitType outClass) {
        LocalThresholdMethod op = new LocalThresholdMethod<T>(){
            private UnaryComputerOp<Iterable<T>, DoubleType> meanOp;

            @Override
            public void compute(Iterable<T> neighborhood, T center, BitType output) {
                if (this.meanOp == null) {
                    this.meanOp = Computers.unary(this.ops(), Ops.Stats.Mean.class, DoubleType.class, neighborhood, new Object[0]);
                }
                DoubleType m = new DoubleType();
                this.meanOp.compute(neighborhood, m);
                output.set(center.getRealDouble() > m.getRealDouble() - LocalMeanThreshold.this.c);
            }
        };
        op.setEnvironment(this.ops());
        return op;
    }

    @Override
    public boolean conforms() {
        RectangleShape rect;
        RectangleShape rectangleShape = rect = this.getShape() instanceof RectangleShape ? (RectangleShape)this.getShape() : null;
        if (rect == null) {
            return true;
        }
        return rect.getSpan() <= 2;
    }
}

