/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.localMean;

import net.imagej.ops.Ops;
import net.imagej.ops.map.neighborhood.CenterAwareIntegralComputerOp;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.stats.IntegralMean;
import net.imagej.ops.threshold.apply.LocalThresholdIntegral;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.composite.Composite;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.LocalMeanThreshold.class, priority=-101.0)
public class LocalMeanThresholdIntegral<T extends RealType<T>>
extends LocalThresholdIntegral<T>
implements Ops.Threshold.LocalMeanThreshold {
    @Parameter
    private double c;

    @Override
    protected CenterAwareIntegralComputerOp<T, BitType> unaryComputer() {
        LocalMeanThresholdComputer op = new LocalMeanThresholdComputer(this.ops().op(IntegralMean.class, DoubleType.class, RectangleNeighborhood.class));
        op.setEnvironment(this.ops());
        return op;
    }

    @Override
    protected int[] requiredIntegralImages() {
        return new int[]{1};
    }

    private class LocalMeanThresholdComputer<I extends RealType<I>>
    extends AbstractBinaryComputerOp<I, RectangleNeighborhood<Composite<DoubleType>>, BitType>
    implements CenterAwareIntegralComputerOp<I, BitType> {
        private final IntegralMean<DoubleType> integralMean;

        public LocalMeanThresholdComputer(IntegralMean<DoubleType> integralMean) {
            this.integralMean = integralMean;
        }

        @Override
        public void compute(I center, RectangleNeighborhood<Composite<DoubleType>> neighborhood, BitType output) {
            DoubleType sum = new DoubleType();
            this.integralMean.compute(neighborhood, sum);
            sum.sub((AbstractRealType)new DoubleType(LocalMeanThresholdIntegral.this.c));
            RealDoubleConverter conv = new RealDoubleConverter();
            DoubleType centerPixelAsDoubleType = new DoubleType();
            conv.convert(center, (Object)centerPixelAsDoubleType);
            output.set(centerPixelAsDoubleType.compareTo((AbstractRealType)sum) > 0);
        }
    }
}

