/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.minimaven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends ClassLoader {
    Map<String, JarFile> jarFilesMap = new HashMap<String, JarFile>();
    List<String> jarFilesNames = new ArrayList<String>(10);
    List<JarFile> jarFilesObjects = new ArrayList<JarFile>(10);
    HashMap<String, Class<?>> cache = new HashMap();

    JarClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public JarClassLoader(String ... paths) throws IOException {
        this();
        for (String path : paths) {
            this.add(path);
        }
    }

    public synchronized void add(String path) throws IOException {
        if (this.jarFilesMap.containsKey(path)) {
            return;
        }
        JarFile jar = new JarFile(path);
        this.jarFilesMap.put(path, jar);
        this.jarFilesNames.add(path);
        this.jarFilesObjects.add(jar);
    }

    @Override
    public URL getResource(String name) {
        int n = this.jarFilesNames.size();
        for (int i = n - 1; i >= 0; --i) {
            JarFile jar = this.jarFilesObjects.get(i);
            String file = this.jarFilesNames.get(i);
            if (jar.getEntry(name) == null) continue;
            String url = "file:///" + file.replace('\\', '/') + "!/" + name;
            try {
                return new URL("jar", "", url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return JarClassLoader.getSystemResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.getResourceAsStream(name, false);
    }

    public InputStream getResourceAsStream(String name, boolean nonSystemOnly) {
        int n = this.jarFilesNames.size();
        for (int i = n - 1; i >= 0; --i) {
            JarFile jar = this.jarFilesObjects.get(i);
            JarEntry entry = jar.getJarEntry(name);
            if (entry == null) continue;
            try {
                return jar.getInputStream(entry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (nonSystemOnly) {
            return null;
        }
        return super.getResourceAsStream(name);
    }

    public Class<?> forceLoadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true, true);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false);
    }

    public synchronized Class<?> loadClass(String name, boolean resolve, boolean forceReload) throws ClassNotFoundException {
        Class<?> result;
        Class<?> cached;
        Class<?> clazz = cached = forceReload ? null : this.cache.get(name);
        if (cached != null) {
            return cached;
        }
        try {
            if (!forceReload && (result = super.loadClass(name, resolve)) != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String path = name.replace('.', '/') + ".class";
        InputStream input = this.getResourceAsStream(path, false);
        if (input == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byte[] buffer = JarClassLoader.readStream(input);
            input.close();
            result = this.defineClass(name, buffer, 0, buffer.length);
            if (result.getPackage() == null) {
                String packageName = name.substring(0, name.lastIndexOf(46));
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            this.cache.put(name, result);
            return result;
        }
        catch (IOException e) {
            result = forceReload ? super.loadClass(name, resolve) : null;
            return result;
        }
    }

    protected static byte[] readStream(InputStream in) throws IOException {
        int count;
        byte[] buffer = new byte[16384];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }
}

