/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Vertex<T> {
    public float centrality = 0.0f;
    public long sigma = 0L;
    public final Set<Vertex<T>> neighbors = new HashSet<Vertex<T>>();
    public long d = -1L;
    public T data;
    float delta = 0.0f;
    final ArrayList<Vertex<T>> predecessors = new ArrayList();

    public Vertex(T data) {
        this.data = data;
    }

    protected void reset() {
        this.centrality = 0.0f;
        this.sigma = 0L;
        this.d = -1L;
        this.delta = 0.0f;
        this.predecessors.clear();
    }

    public int getNeighborCount() {
        return this.neighbors.size();
    }

    public static <T> ArrayList<Vertex<T>> clone(Collection<Vertex<T>> vs) {
        ArrayList<Vertex<T>> copies = new ArrayList<Vertex<T>>(vs.size());
        if (1 == vs.size()) {
            copies.add(new Vertex<T>(vs.iterator().next().data));
            return copies;
        }
        HashMap<Vertex<T>, Vertex<T>> rel = new HashMap<Vertex<T>, Vertex<T>>();
        for (Vertex<T> v : vs) {
            rel.put(v, new Vertex<T>(v.data));
        }
        for (Vertex<T> v : vs) {
            Vertex copy = (Vertex)rel.get(v);
            for (Vertex<T> w : v.neighbors) {
                copy.neighbors.add((Vertex<T>)rel.get(w));
            }
            copies.add(copy);
        }
        return copies;
    }

    public boolean isBranching() {
        return this.neighbors.size() > 2;
    }

    public boolean isEnding() {
        return 1 == this.neighbors.size();
    }

    public List<Vertex<T>> getBranch(Vertex<T> parent) {
        if (!this.neighbors.contains(parent)) {
            throw new IllegalArgumentException("'parent' vertex is not a neighbor");
        }
        ArrayList<Vertex<T>> chain = new ArrayList<Vertex<T>>();
        chain.add(this);
        if (this.isBranching()) {
            return chain;
        }
        Vertex o = this;
        Vertex p = parent;
        Set<Vertex<T>> c = this.neighbors;
        block0: while (1 != c.size()) {
            Iterator iterator = c.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Vertex v = (Vertex)iterator.next();
                if (v == p) continue;
                chain.add(v);
                if (v.isBranching() || v.isEnding()) {
                    return chain;
                }
                p = o;
                o = v;
                c = v.neighbors;
            }
            break;
        }
        return chain;
    }
}

