/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Tree;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.DBLoader;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.tree.TitledThing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class ProjectThing
extends DBObject
implements TitledThing {
    private TemplateThing template;
    private ProjectThing parent;
    private ArrayList<ProjectThing> al_children = null;
    private Object object;

    @Override
    public Thing shallowCopy() {
        return new ProjectThing(this);
    }

    private ProjectThing(ProjectThing pt) {
        super(pt.project, pt.id);
        this.template = pt.template;
        this.object = pt.object;
    }

    public ProjectThing(TemplateThing template, Project project, Object ob) throws Exception {
        super(project);
        if (null == ob) {
            throw new Exception("ProjectThing constructor: Null Object!");
        }
        if (null == template) {
            throw new Exception("ProjectThing constructor: Null template!");
        }
        this.template = project.getTemplateThing(template.getType());
        this.object = ob;
        this.addToDatabase();
    }

    private void assertChildren(TemplateThing tt1, TemplateThing tt2) throws Exception {
        List<Object> c1 = null == tt1.getChildren() ? Collections.EMPTY_LIST : new ArrayList<TemplateThing>(tt1.getChildren());
        List<Object> c2 = null == tt2.getChildren() ? Collections.EMPTY_LIST : new ArrayList<TemplateThing>(tt2.getChildren());
        Collections.sort(c1);
        Collections.sort(c2);
        if (c1.isEmpty() && c2.isEmpty()) {
            return;
        }
        if (c1.size() != c2.size()) {
            throw new Exception("ERROR: receiving project has a different number of children for type " + tt1.getType() + " / " + tt2.getType());
        }
        Iterator it1 = c1.iterator();
        Iterator it2 = c2.iterator();
        while (it2.hasNext()) {
            TemplateThing a = (TemplateThing)it1.next();
            TemplateThing b = (TemplateThing)it2.next();
            if (!a.getType().equals(b.getType())) {
                throw new Exception("ERROR: type '" + tt1.getType() + "' of receiving project has a child '" + a.getType() + "' that is not present in the cognate type of the sending project.");
            }
            this.assertChildren(a, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectThing deepClone(Project project, boolean copy_id) throws Exception {
        TemplateThing tt = project.getTemplateThing(this.template.getType());
        if (null == tt) {
            tt = this.template.clone(project, copy_id);
            project.addUniqueType(tt);
        } else {
            this.assertChildren(tt, this.template);
        }
        ArrayList<String> missing = new ArrayList<String>();
        for (TemplateThing tn : this.template.collectAllChildren(new ArrayList<TemplateThing>())) {
            if (project.typeExists(tn.getType())) continue;
            missing.add(tn.getType());
        }
        if (!missing.isEmpty()) {
            throw new Exception("Can't transfer: missing templates " + Utils.toString(missing));
        }
        ProjectThing copy = new ProjectThing(tt, project, this.object instanceof Displayable ? ((Displayable)this.object).clone(project, copy_id) : this.object);
        if (null != this.al_children) {
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                for (ProjectThing child : this.al_children) {
                    copy.addChild(child.deepClone(project, copy_id));
                }
            }
        }
        return copy;
    }

    public ProjectThing(TemplateThing template, Project project, long id, Object ob, ArrayList<ProjectThing> al_children) {
        super(project, id);
        this.template = project.getTemplateThing(template.getType());
        this.al_children = null == al_children || 0 == al_children.size() ? null : al_children;
        this.object = ob;
    }

    public void setObject(Object object) {
        if (null != this.object && !this.object.equals(this.template.getType())) {
            Utils.log(this + " already contains an object.");
            return;
        }
        this.object = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        if (null != this.al_children) {
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                for (ProjectThing child : this.al_children) {
                    child.parent = this;
                    child.setup();
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (null == this.object) {
            sb.append(this.template.getType());
        } else {
            sb.append(this.object.toString()).append(' ').append('[').append(this.template.getType()).append(']');
        }
        return sb.toString();
    }

    @Override
    public String getTitle() {
        return null == this.object ? this.template.getType() : this.object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canAddChild(Thing child) {
        if (!this.template.canHaveAsChild(child)) {
            Utils.log2("Rejecting child " + child);
            return false;
        }
        if (null != this.al_children) {
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                if (-1 != this.al_children.indexOf((ProjectThing)child)) {
                    Utils.log2("Rejecting child " + child);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addChild(Thing child) {
        if (!this.canAddChild(child)) {
            return false;
        }
        if (null == this.al_children) {
            this.al_children = new ArrayList();
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            this.al_children.add((ProjectThing)child);
        }
        child.setParent(this);
        return true;
    }

    public boolean addChild(ProjectThing child, int index) {
        if (!this.canAddChild(child)) {
            return false;
        }
        if (null == this.al_children) {
            this.al_children = new ArrayList();
            this.al_children.add(child);
        } else if (index < 0) {
            this.al_children.add(0, child);
        } else if (index >= this.al_children.size()) {
            this.al_children.add(child);
        } else {
            this.al_children.add(index, child);
        }
        child.setParent(this);
        if (child.object instanceof Profile) {
            child.parent.fixZOrdering();
        }
        return true;
    }

    public ArrayList<ProjectThing> getChildren() {
        return this.al_children;
    }

    @Override
    public boolean hasChildren() {
        return null != this.al_children && 0 != this.al_children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(ProjectThing child) {
        if (null == this.al_children) {
            return false;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            if (-1 == this.al_children.indexOf(child)) {
                Utils.log("ProjectThing.removeChild: child " + child + " not contained in parent " + this);
                return false;
            }
            this.al_children.remove(child);
        }
        return true;
    }

    @Override
    public boolean remove(boolean check) {
        return this.remove(check, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(boolean check, boolean remove_object) {
        if (check && !Utils.check("Really delete " + this.toString() + (null == this.al_children || 0 == this.al_children.size() ? "" : " and all its children?"))) {
            return false;
        }
        if (null != this.al_children) {
            ProjectThing[] children;
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                children = this.al_children.toArray(new ProjectThing[this.al_children.size()]);
            }
            for (int i = 0; i < children.length; ++i) {
                if (children[i].remove(false)) continue;
                Utils.showMessage("Deletion incomplete, check database, for child: " + children[i]);
                return false;
            }
        }
        if (remove_object && null != this.object && this.object instanceof DBObject) {
            if (!((DBObject)this.object).remove(false)) {
                Utils.showMessage("Deletion incomplete, check database, for object: " + this.object.toString());
                return false;
            }
            try {
                if (null != Class.forName("ij3d.ImageWindow3D")) {
                    Display3D.remove(this);
                }
            }
            catch (ClassNotFoundException cnfe) {
                Utils.log("ImageJ_3D_Viewer.jar not installed.");
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        if (null != this.parent && !this.parent.removeChild(this)) {
            Utils.showMessage("Deletion incomplete, check database, for parent of ProjectThing id=" + this.id);
            return false;
        }
        return this.removeFromDatabase();
    }

    @Override
    public void setParent(Thing parent) {
        this.parent = (ProjectThing)parent;
        this.updateInDatabase("parent_id");
    }

    @Override
    public Thing getParent() {
        return this.parent;
    }

    public ProjectThing getRootParent() {
        if (null == this.parent) {
            return this;
        }
        return this.parent.getRootParent();
    }

    public boolean hasParent(String type) {
        if (null == this.parent) {
            return false;
        }
        if (this.template.getType().equals(type)) {
            return true;
        }
        return this.parent.hasParent(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTitle(String title) {
        if (null == title || title.length() < 1) {
            if (this.object != null && this.object instanceof String) {
                this.object = this.template.getType();
            }
            return;
        }
        if (null == this.object || this.object instanceof String) {
            this.object = title;
            this.updateInDatabase("title");
            if (null != this.al_children) {
                ArrayList<ProjectThing> arrayList = this.al_children;
                synchronized (arrayList) {
                    for (ProjectThing pt : this.al_children) {
                        if (pt.object instanceof Displayable) {
                            Displayable d = (Displayable)pt.object;
                            Display.updateTitle(d.getLayer(), d);
                            continue;
                        }
                        if (!pt.getType().equals("profile_list") || null == pt.al_children) continue;
                        for (ProjectThing pd : pt.al_children) {
                            Displayable d = (Displayable)pd.object;
                            Display.updateTitle(d.getLayer(), d);
                        }
                    }
                }
            }
        } else {
            try {
                Method setTitle = null;
                if (this.object instanceof Displayable) {
                    ((Displayable)this.object).setTitle(title);
                } else {
                    setTitle = this.object.getClass().getDeclaredMethod("setTitle", String.class);
                    setTitle.invoke(this.object, title);
                }
            }
            catch (NoSuchMethodException nsme) {
                Utils.log("No such method: setTitle, for object " + this.object);
            }
            catch (Exception e) {
                Utils.log("ProjectThing.setTitle: no such method setTitle or can't access it, in the object " + this.object);
                IJError.print(e);
            }
        }
    }

    @Override
    public Object getObject() {
        if (null == this.object) {
            return this.template.getType();
        }
        return this.object;
    }

    public TemplateThing getChildTemplate(String type) {
        return this.template.getChildTemplate(type);
    }

    @Override
    public boolean canHaveAsChild(Thing thing) {
        if (null == thing) {
            return false;
        }
        return this.template.canHaveAsChild(thing);
    }

    public boolean uniquePathExists(String type) {
        return this.template.uniquePathExists(type);
    }

    public ArrayList<TemplateThing> getTemplatePathTo(String type) {
        return this.template.getTemplatePathTo(type, new ArrayList<TemplateThing>());
    }

    @Override
    public String getType() {
        return this.template.getType();
    }

    public TemplateThing getTemplate() {
        return this.template;
    }

    public JMenuItem[] getPopupItems(ActionListener listener) {
        JMenu plugin_menu;
        JMenuItem item = null;
        ArrayList<JMenuItem> al_items = new ArrayList<JMenuItem>();
        JMenu menu = new JMenu("Add...");
        ArrayList<TemplateThing> tc = this.project.getTemplateThing(this.template.getType()).getChildren();
        if (null != tc) {
            for (TemplateThing tt : tc) {
                item = new JMenuItem("new " + tt.getType());
                item.addActionListener(listener);
                menu.add(item);
            }
            item = new JMenuItem("many...");
            item.addActionListener(listener);
            menu.add(item);
        }
        if (0 != menu.getItemCount()) {
            if (this.template.getType().equals("profile_list") && null != this.al_children && this.al_children.size() > 0) {
                item.setEnabled(false);
            }
            al_items.add(menu);
        }
        this.addPopupItem("Unhide", listener, al_items).setAccelerator(KeyStroke.getKeyStroke(72, 8, true));
        this.addPopupItem("Hide", listener, al_items).setAccelerator(KeyStroke.getKeyStroke(72, 0, true));
        this.addPopupItem("Info", listener, al_items);
        this.addPopupItem("Rename...", listener, al_items).setAccelerator(KeyStroke.getKeyStroke(113, 0, true));
        if (Project.isBasicType(this.getType())) {
            this.addPopupItem("Duplicate", listener, al_items);
        }
        this.addPopupItem("Select in display", listener, al_items).setAccelerator(KeyStroke.getKeyStroke(65, 0, true));
        if (null != this.object && this.object instanceof Displayable) {
            this.addPopupItem("Show centered in Display", listener, al_items);
        }
        if (null != this.object && this.object instanceof Tree) {
            this.addPopupItem("Show tabular view", listener, al_items);
        }
        if (null != (plugin_menu = Utils.addPlugIns("Project Tree", this.project, new Callable<Displayable>(){

            @Override
            public Displayable call() {
                if (ProjectThing.this.object instanceof Displayable) {
                    return (Displayable)ProjectThing.this.object;
                }
                return null;
            }
        }))) {
            al_items.add(plugin_menu);
        }
        this.addPopupItem("Measure", listener, al_items);
        this.addPopupItem("Show in 3D", listener, al_items).setAccelerator(KeyStroke.getKeyStroke(51, 0, true));
        this.addPopupItem("Remove from 3D view", listener, al_items);
        if (this.template.getType().equals("project")) {
            if (this.project.getLoader() instanceof DBLoader) {
                this.addPopupItem("Export project...", listener, al_items);
            } else if (this.project.getLoader() instanceof FSLoader) {
                this.addPopupItem("Save", listener, al_items).setAccelerator(KeyStroke.getKeyStroke(83, 0, true));
                this.addPopupItem("Save as...", listener, al_items);
            }
        }
        if (!this.template.getType().equals("project") || !(this.project.getLoader() instanceof FSLoader)) {
            this.addPopupItem("Delete...", listener, al_items);
        }
        JMenuItem[] items = new JMenuItem[al_items.size()];
        al_items.toArray(items);
        return items;
    }

    private JMenuItem addPopupItem(String command, ActionListener listener, ArrayList<JMenuItem> al_items) {
        JMenuItem item = new JMenuItem(command);
        item.addActionListener(listener);
        al_items.add(item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean b) {
        if (this.object instanceof Displayable) {
            Displayable d = (Displayable)this.object;
            d.setVisible(b);
            Display.updateCheckboxes(d, 2, b);
        }
        if (null != this.al_children) {
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                for (ProjectThing pt : this.al_children) {
                    pt.setVisible(b);
                }
            }
        }
    }

    public ArrayList<ProjectThing> createChildren(String type, int amount, boolean recursive) {
        ArrayList<ProjectThing> al = new ArrayList<ProjectThing>();
        for (int i = 0; i < amount; ++i) {
            ProjectThing pt = this.createChild(type);
            if (null == pt) continue;
            al.add(pt);
            if (!recursive) continue;
            pt.createChildren(al, new HashSet<String>());
        }
        return al;
    }

    private void createChildren(ArrayList<ProjectThing> nc, HashSet<String> parents) {
        if (parents.contains(this.template.getType())) {
            return;
        }
        parents.add(this.template.getType());
        ArrayList<TemplateThing> children = this.template.getChildren();
        if (null == children) {
            return;
        }
        for (TemplateThing tt : children) {
            ProjectThing newchild;
            if (parents.contains(tt.getType()) || null == (newchild = this.createChild(tt.getType()))) continue;
            nc.add(newchild);
            newchild.createChildren(nc, new HashSet<String>(parents));
        }
    }

    public boolean canHaveAsChild(String type) {
        return null != this.template.getChildTemplate(type);
    }

    public ProjectThing createChild(String type) {
        TemplateThing tt = this.template.getChildTemplate(type);
        if (null == tt) {
            Utils.log2("Can't create a child of type " + type);
            return null;
        }
        Object ob = this.project.makeObject(tt);
        Layer layer = null;
        if (ob instanceof Displayable && null == (layer = Display.getFrontLayer(this.project))) {
            Utils.showMessage("Open a display first!");
            ((DBObject)ob).removeFromDatabase();
            return null;
        }
        ProjectThing pt = null;
        try {
            pt = new ProjectThing(tt, this.project, ob);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        this.addChild(pt);
        if (null != layer) {
            if (ob instanceof ZDisplayable) {
                layer.getParent().add((ZDisplayable)ob);
            } else {
                layer.add((Displayable)ob);
            }
        }
        return pt;
    }

    public ProjectThing createClonedChild(ProjectThing child) {
        if (null == child || null == child.object || null == this.al_children || !this.al_children.contains(child) || !Project.isBasicType(child.getType())) {
            return null;
        }
        Displayable displ = ((Displayable)child.object).clone();
        ProjectThing pt = null;
        try {
            pt = new ProjectThing(child.template, this.project, displ);
            this.addChild(pt);
            if (displ instanceof ZDisplayable) {
                ZDisplayable original = (ZDisplayable)child.object;
                original.getLayerSet().add((ZDisplayable)displ);
                Display.repaint(original.getLayerSet(), (Displayable)((ZDisplayable)displ), 5);
            } else {
                Displayable original = (Displayable)child.object;
                original.getLayer().add(displ);
                Display.repaint(original.getLayer(), displ, 5);
            }
            displ.setLocked(false);
            displ.setVisible(true);
            if (null != Display.getFront()) {
                Display.getFront().select(displ);
            }
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        return pt;
    }

    public ArrayList<ProjectThing> findChildren(String regex, String regex_exclude, boolean shallow) {
        ArrayList<ProjectThing> found = new ArrayList<ProjectThing>();
        this.findChildren(found, null == regex ? null : Pattern.compile("^.*" + regex + ".*$", 32), null == regex_exclude ? null : Pattern.compile("^.*" + regex_exclude + ".*$", 32), shallow);
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findChildren(ArrayList<ProjectThing> found, Pattern pattern, Pattern pattern_exclude, boolean shallow) {
        if (null == this.object) {
            return;
        }
        String name = this.object.toString();
        if (null != pattern_exclude && pattern_exclude.matcher(name).matches()) {
            return;
        }
        if (null == pattern) {
            found.add(this);
        } else if (pattern.matcher(name).matches()) {
            found.add(this);
            if (shallow) {
                return;
            }
        }
        if (null == this.al_children) {
            return;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing pt : this.al_children) {
                pt.findChildren(found, pattern, pattern_exclude, shallow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thing findChild(Object ob) {
        if (null != this.object && this.object.equals(ob)) {
            return this;
        }
        if (null == this.al_children) {
            return null;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                Thing found = child.findChild(ob);
                if (null == found) continue;
                return found;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectThing findChild(long id) {
        if (id == this.id) {
            return this;
        }
        if (null == this.al_children) {
            return null;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                ProjectThing found = child.findChild(id);
                if (null == found) continue;
                return found;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBObject findObject(long id) {
        DBObject dbo;
        if (id == this.id) {
            return this;
        }
        if (null != this.object && this.object instanceof DBObject && (dbo = (DBObject)this.object).getId() == id) {
            return dbo;
        }
        if (null == this.al_children) {
            return null;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                DBObject dbo2 = child.findObject(id);
                if (null == dbo2) continue;
                return dbo2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Class<?>, ResultsTable> measure(HashMap<Class<?>, ResultsTable> ht) {
        ArrayList<ProjectThing> arrayList;
        if (null == ht) {
            ht = new HashMap();
        }
        if (null != this.object && this.object instanceof Displayable) {
            Displayable d = (Displayable)this.object;
            if (d.isVisible()) {
                ResultsTable rta;
                ResultsTable rt = d.measure((ResultsTable)ht.get(d.getClass()));
                if (null != rt) {
                    ht.put(d.getClass(), rt);
                }
                if (this.object instanceof AreaContainer && null != (rta = ((AreaContainer)this.object).measureAreas((ResultsTable)ht.get(AreaContainer.class)))) {
                    ht.put(AreaContainer.class, rta);
                }
            } else {
                Utils.log("Measure: skipping hidden object " + d.getProject().getMeaningfulTitle(d));
            }
        }
        if (null == this.al_children) {
            return ht;
        }
        if (this.template.getType().equals("profile_list") && null != this.al_children) {
            arrayList = this.al_children;
            synchronized (arrayList) {
                if (this.al_children.size() > 1) {
                    Profile[] p = new Profile[this.al_children.size()];
                    for (int i = 0; i < this.al_children.size(); ++i) {
                        p[i] = (Profile)this.al_children.get((int)i).object;
                    }
                    ResultsTable rt = Profile.measure(p, (ResultsTable)ht.get(Profile.class), this.id);
                    if (null != rt) {
                        ht.put(Profile_List.class, rt);
                    }
                }
            }
        }
        arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                child.measure(ht);
            }
        }
        return ht;
    }

    public void measure() {
        HashMap ht = new HashMap();
        this.measure(ht);
        Utils.showAllTables(ht);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSVG(StringBuffer data, double z_scale, String indent) {
        String type = this.template.getType();
        if (!type.equals("profile_list") && Project.isBasicType(type)) {
            ((Displayable)this.object).exportSVG(data, z_scale, indent);
        } else {
            data.append(indent).append("<g type=\"").append(type).append("\" title=\"").append(null != this.object ? this.object.toString() : type).append("\"");
            data.append(" id=\"").append(this.id).append("\">\n");
            String in = indent + "\t";
            if (null != this.al_children) {
                ArrayList<ProjectThing> arrayList = this.al_children;
                synchronized (arrayList) {
                    for (ProjectThing child : this.al_children) {
                        child.exportSVG(data, z_scale, in);
                    }
                }
            }
            data.append(indent).append("</g>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectThing> findChildrenOfType(String type) {
        ArrayList<ProjectThing> al = new ArrayList<ProjectThing>();
        if (null == this.al_children) {
            return al;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing pt : this.al_children) {
                if (!pt.template.getType().equals(type)) continue;
                al.add(pt);
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ArrayList<T> findChildrenOfType(Class<T> c) {
        ArrayList<Object> al = new ArrayList<Object>();
        if (null == this.al_children) {
            return al;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing pt : this.al_children) {
                if (!c.isInstance(pt.object)) continue;
                al.add(pt.object);
            }
        }
        return al;
    }

    public HashSet<ProjectThing> findChildrenOfTypeR(String type) {
        return this.findChildrenOfTypeR(new HashSet<ProjectThing>(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ProjectThing> findChildrenOfTypeR(HashSet<ProjectThing> hs, String type) {
        if (null == hs) {
            hs = new HashSet();
        } else if (hs.contains(this)) {
            return hs;
        }
        if (this.template.getType().equals(type)) {
            hs.add(this);
        }
        if (null == this.al_children) {
            return hs;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                child.findChildrenOfTypeR(hs, type);
            }
        }
        return hs;
    }

    public List<ProjectThing> findChildrenOfTypeR(Class<?> c) {
        return this.findChildrenOfTypeR(new ArrayList<ProjectThing>(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectThing> findChildrenOfTypeR(List<ProjectThing> list, Class<?> c) {
        if (null == list) {
            list = new ArrayList<ProjectThing>();
        }
        if (c.isInstance(this.object)) {
            list.add(this);
        }
        if (null == this.al_children) {
            return list;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                child.findChildrenOfTypeR(list, c);
            }
        }
        return list;
    }

    public <T> List<T> findObjects(Class<T> c) {
        ArrayList col = new ArrayList();
        this.findObjects(c, col);
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void findObjects(Class<T> c, List<T> col) {
        if (c.isInstance(this.object)) {
            col.add(this.object);
        }
        if (null == this.al_children) {
            return;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing pt : this.al_children) {
                pt.findObjects(c, col);
            }
        }
    }

    public HashSet<ProjectThing> findBasicTypeChildren() {
        return this.findBasicTypeChildren(new HashSet<ProjectThing>(), new HashSet<ProjectThing>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ProjectThing> findBasicTypeChildren(HashSet<ProjectThing> hs_basic, HashSet<ProjectThing> hs_visited) {
        if (null == hs_basic) {
            hs_basic = new HashSet();
        }
        if (null == hs_visited) {
            hs_visited = new HashSet();
        }
        if (hs_basic.contains(this) || hs_visited.contains(this)) {
            return hs_basic;
        }
        hs_visited.add(this);
        if (Project.isBasicType(this.template.getType())) {
            hs_basic.add(this);
        }
        if (null == this.al_children) {
            return hs_basic;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                child.findBasicTypeChildren(hs_basic, hs_visited);
            }
        }
        return hs_basic;
    }

    public void updateTitle() {
        this.updateTitle(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTitle(String old_type) {
        if (this.object instanceof String && this.object.equals(old_type)) {
            this.object = this.template.getType();
        } else if (this.object instanceof Displayable) {
            Displayable d = (Displayable)this.object;
            Display.updateTitle(d.getLayer(), d);
        }
        if (null != this.al_children) {
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                for (ProjectThing child : this.al_children) {
                    child.updateTitle(old_type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateType(String new_type, String old_type) {
        if (new_type.equals(this.template.getType())) {
            this.updateInDatabase("type");
            this.updateTitle(old_type);
        }
        if (null == this.al_children) {
            return;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                child.updateType(new_type, old_type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ProjectThing> collectSimilarThings(TemplateThing tt, HashSet<ProjectThing> hs) {
        if (this.template.getType().equals(tt.getType()) && this.parent.template.getType().equals(tt.getParent().getType())) {
            hs.add(this);
        }
        if (null == this.al_children) {
            return hs;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                hs = child.collectSimilarThings(tt, hs);
            }
        }
        return hs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        Boolean b;
        String in = indent + "\t";
        String tag = this.template.getType().replace(' ', '_');
        sb_body.append(indent).append('<').append(tag).append(" id=\"").append(this.id).append('\"');
        if (null == this.object || this.object.getClass() == String.class) {
            if (!this.template.getType().equals(this.object)) {
                sb_body.append(" title=\"").append((String)this.object).append('\"');
            }
        } else {
            sb_body.append(" oid=\"").append(((DBObject)this.object).getId()).append('\"');
        }
        if (null != this.al_children && null != (b = options.expanded_states.get(this)) && Boolean.TRUE.equals(b)) {
            sb_body.append(" expanded=\"true\"");
        }
        if (null != this.al_children) {
            sb_body.append(">\n");
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                for (ProjectThing child : this.al_children) {
                    child.exportXML(sb_body, in, options);
                }
            }
            sb_body.append(indent).append("</").append(tag).append(">\n");
        } else {
            sb_body.append("/>\n");
        }
    }

    @Override
    public void debug(String indent) {
        System.out.println(indent + this.template.getType() + " (id)");
        if (null != this.al_children) {
            if (indent.length() > 20) {
                System.out.println("INDENT OVER 20 !");
                return;
            }
            for (ProjectThing child : this.al_children) {
                child.debug(indent + "\t");
            }
        }
        if (null != this.object) {
            System.out.println(indent + "ob:" + this.object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fixZOrdering() {
        if (!this.template.getType().equals("profile_list")) {
            return false;
        }
        if (null == this.al_children || this.al_children.size() < 2) {
            return true;
        }
        HashMap<Double, ArrayList<ProjectThing>> ht = new HashMap<Double, ArrayList<ProjectThing>>();
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                Profile p = (Profile)child.object;
                Layer layer = p.getLayer();
                Double z = new Double(layer.getZ());
                ArrayList<ProjectThing> al = (ArrayList<ProjectThing>)ht.get(z);
                if (null == al) {
                    al = new ArrayList<ProjectThing>();
                    al.add(child);
                    ht.put(z, al);
                    continue;
                }
                al.add(child);
            }
            Object[] zs = new Double[ht.size()];
            ht.keySet().toArray(zs);
            Arrays.sort(zs);
            this.al_children.clear();
            for (int i = 0; i < zs.length; ++i) {
                this.al_children.addAll((Collection)ht.get(zs[i]));
            }
        }
        return true;
    }

    @Override
    public boolean isExpanded() {
        return this.project.getProjectTree().isExpanded(this);
    }

    public String getNodeInfo() {
        return "Node: " + this.object + " [" + this.template.getType() + "]\n" + (this.object instanceof DBObject ? ((DBObject)this.object).getInfo() : "");
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        this.getInfo(new HashSet<ProjectThing>(), sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getInfo(HashSet<ProjectThing> hs, StringBuilder info) {
        if (hs.contains(this)) {
            return;
        }
        hs.add(this);
        info.append('\n').append(this.getNodeInfo());
        if (null == this.al_children) {
            return;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                child.getInfo(hs, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectThing subclone(Project pr) {
        Object ob = null;
        if (null != this.object) {
            ob = this.object instanceof DBObject ? pr.getRootLayerSet().findById(((DBObject)this.object).getId()) : this.object;
        }
        ProjectThing copy = new ProjectThing(pr.getTemplateThing(this.template.getType()), pr, this.id, ob, new ArrayList<ProjectThing>());
        if (null != this.al_children) {
            copy.al_children = new ArrayList();
            ArrayList<ProjectThing> arrayList = this.al_children;
            synchronized (arrayList) {
                for (ProjectThing child : this.al_children) {
                    ProjectThing cc = child.subclone(pr);
                    if (child.object instanceof DBObject && null == cc.object) continue;
                    cc.setParent(this);
                    copy.al_children.add(cc);
                }
            }
        }
        return copy;
    }

    public boolean move(int inc) {
        if (null == this.parent) {
            return false;
        }
        int i = this.parent.al_children.indexOf(this);
        if (0 == inc || i + inc < 0 || i + inc >= this.parent.al_children.size()) {
            return false;
        }
        this.parent.al_children.set(i, this.parent.al_children.get(i + inc));
        this.parent.al_children.set(i + inc, this);
        return true;
    }

    public HashMap<String, ArrayList<ProjectThing>> getByType() {
        return this.getByType(new HashMap<String, ArrayList<ProjectThing>>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, ArrayList<ProjectThing>> getByType(HashMap<String, ArrayList<ProjectThing>> ht) {
        String type = this.template.getType();
        ArrayList<ProjectThing> ap = ht.get(type);
        if (null == ap) {
            ap = new ArrayList();
            ht.put(type, ap);
        }
        ap.add(this);
        if (null == this.al_children) {
            return ht;
        }
        ArrayList<ProjectThing> arrayList = this.al_children;
        synchronized (arrayList) {
            for (ProjectThing child : this.al_children) {
                child.getByType(ht);
            }
        }
        return ht;
    }

    public final class Profile_List {
    }
}

