/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.display.Patch;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.TransformMesh;
import mpicbg.trakem2.transform.AffineModel2D;
import mpicbg.trakem2.transform.TransformMeshMappingWithMasks;
import mpicbg.trakem2.util.Pair;

public class ExportUnsignedByte {
    public static final Pair<ByteProcessor, ByteProcessor> makeFlatImageFromMipMaps(List<Patch> patches, Rectangle roi, double backgroundValue, double scale) {
        return ExportUnsignedByte.makeFlatImage(patches, roi, backgroundValue, scale, new MipMapSource());
    }

    public static final Pair<ByteProcessor, ByteProcessor> makeFlatImageFromOriginals(List<Patch> patches, Rectangle roi, double backgroundValue, double scale) {
        return ExportUnsignedByte.makeFlatImage(patches, roi, backgroundValue, scale, new OriginalSource());
    }

    public static final Pair<ByteProcessor, ByteProcessor> makeFlatImage(List<Patch> patches, Rectangle roi, double backgroundValue, double scale, ImageSource fetcher) {
        ByteProcessor target = new ByteProcessor((int)((double)roi.width * scale), (int)((double)roi.height * scale));
        target.setInterpolationMethod(1);
        ByteProcessor targetMask = new ByteProcessor(target.getWidth(), target.getHeight());
        targetMask.setInterpolationMethod(0);
        for (Patch patch : patches) {
            ImageData imgd = fetcher.fetch(patch, scale);
            AffineTransform atc = new AffineTransform();
            atc.scale(scale, scale);
            atc.translate(-roi.x, -roi.y);
            AffineTransform at = new AffineTransform();
            at.preConcatenate(atc);
            at.concatenate(patch.getAffineTransform());
            at.scale(imgd.scaleX, imgd.scaleY);
            AffineModel2D aff = new AffineModel2D();
            aff.set(at);
            CoordinateTransformMesh mesh = new CoordinateTransformMesh((CoordinateTransform)aff, patch.getMeshResolution(), (double)imgd.bp.getWidth(), (double)imgd.bp.getHeight());
            TransformMeshMappingWithMasks mapping = new TransformMeshMappingWithMasks((TransformMesh)mesh);
            imgd.bp.setInterpolationMethod(1);
            imgd.alpha.setInterpolationMethod(0);
            mapping.map(imgd.bp, imgd.alpha, target, targetMask);
        }
        return new Pair((Object)target, (Object)targetMask);
    }

    public static class OriginalSource
    implements ImageSource {
        @Override
        public final ImageData fetch(Patch patch, double scale) {
            ByteProcessor alpha;
            Patch.PatchImage pai = patch.createTransformedImage();
            double aK = Math.max(patch.getWidth() / (float)patch.getOWidth(), patch.getHeight() / (float)patch.getOHeight());
            if (aK > 1.0 || aK * scale > 1.0) {
                return new ImageData(pai.target.convertToByteProcessor(true), pai.getMask(), 1.0, 1.0);
            }
            double K = aK * scale;
            int width = pai.target.getWidth();
            int height = pai.target.getHeight();
            int s_width = (int)((double)width * K);
            int s_height = (int)((double)height * K);
            double max_dimension_source = Math.max(width, height);
            double max_dimension_target = Math.max(s_width, s_height);
            double s = 0.5;
            double sigma = 0.5 * max_dimension_source / max_dimension_target - 0.25;
            new GaussianBlur().blurGaussian(pai.target, sigma, sigma, 2.0E-4);
            pai.target.setInterpolationMethod(0);
            ByteProcessor mask = pai.getMask();
            if (null != mask) {
                new GaussianBlur().blurGaussian((ImageProcessor)mask, sigma, sigma, 0.002);
                mask.setInterpolationMethod(0);
                alpha = (ByteProcessor)mask.resize(s_width, s_height);
            } else {
                alpha = new ByteProcessor(s_width, s_height);
                Arrays.fill((byte[])alpha.getPixels(), (byte)-1);
            }
            return new ImageData(pai.target.resize(s_width, s_height).convertToByteProcessor(true), alpha, 1.0 / K, 1.0 / K);
        }
    }

    public static class MipMapSource
    implements ImageSource {
        @Override
        public final ImageData fetch(Patch patch, double scale) {
            ByteProcessor alpha;
            double aK = Math.max(patch.getWidth() / (float)patch.getOWidth(), patch.getHeight() / (float)patch.getOHeight());
            double K = aK > 1.0 ? 1.0 : Math.min(1.0, scale * aK);
            MipMapImage mipMap = patch.getProject().getLoader().fetchImage(patch, K);
            BufferedImage bi = new BufferedImage(mipMap.image.getWidth(null), mipMap.image.getHeight(null), 10);
            Graphics2D g = bi.createGraphics();
            g.drawImage(mipMap.image, 0, 0, null);
            g.dispose();
            ByteProcessor bp = new ByteProcessor(bi);
            if (patch.hasAlphaChannel()) {
                alpha = new ColorProcessor(mipMap.image).getChannel(4, null);
            } else {
                alpha = new ByteProcessor(bp.getWidth(), bp.getHeight());
                Arrays.fill((byte[])alpha.getPixels(), (byte)-1);
            }
            return new ImageData(bp, alpha, mipMap.scaleX, mipMap.scaleY);
        }
    }

    public static interface ImageSource {
        public ImageData fetch(Patch var1, double var2);
    }

    public static class ImageData {
        private ByteProcessor bp;
        private ByteProcessor alpha;
        private double scaleX;
        private double scaleY;

        public ImageData(ByteProcessor bp, ByteProcessor alpha, double scaleX, double scaleY) {
            this.bp = bp;
            this.alpha = alpha;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
        }
    }
}

