/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apposed.appose.Service;
import org.apposed.appose.util.Types;

public class GroovyWorker {
    private static final Map<String, Object> initVars = new ConcurrentHashMap<String, Object>();
    private final Map<String, Task> tasks = new ConcurrentHashMap<String, Task>();
    private final Deque<Task> queue = new ArrayDeque<Task>();
    private final Map<String, Object> exports = new ConcurrentHashMap<String, Object>();
    private boolean running = true;

    public GroovyWorker() {
        new Thread(this::processInput, "Appose-Receiver").start();
        new Thread(this::cleanupThreads, "Appose-Janitor").start();
    }

    public void run() {
        while (this.running) {
            if (this.queue.isEmpty()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Task task = this.queue.pop();
            task.run();
        }
    }

    private void processInput() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String line;
            try {
                line = stdin.readLine();
            }
            catch (IOException exc) {
                line = null;
            }
            if (line == null) break;
            Map<String, Object> request = Types.decode(line);
            String uuid = (String)request.get("task");
            String requestType = (String)request.get("requestType");
            switch (Service.RequestType.valueOf(requestType)) {
                case EXECUTE: {
                    String script = (String)request.get("script");
                    Map inputs = (Map)request.get("inputs");
                    String queue = (String)request.get("queue");
                    Task task = new Task(uuid, script, inputs);
                    this.tasks.put(uuid, task);
                    if ("main".equals(queue)) {
                        this.queue.add(task);
                        break;
                    }
                    task.thread = new Thread(() -> task.run(), "Appose-" + uuid);
                    task.thread.start();
                    break;
                }
                case CANCEL: {
                    Task taskToCancel = this.tasks.get(uuid);
                    if (taskToCancel == null) {
                        System.err.println("No such task: " + uuid);
                        break;
                    }
                    taskToCancel.cancelRequested = true;
                }
            }
        }
        this.running = false;
    }

    private void cleanupThreads() {
        while (this.running) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Map<String, Task> dead = this.tasks.entrySet().stream().filter(Objects::nonNull).filter(entry -> this.isTaskDead((Task)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (Map.Entry<String, Task> entry2 : dead.entrySet()) {
                String uuid = entry2.getKey();
                Task task = entry2.getValue();
                this.tasks.remove(uuid);
                if (task.finished) continue;
                task.fail("thread death");
            }
        }
    }

    private boolean isTaskDead(Task task) {
        return task.thread != null && !task.thread.isAlive();
    }

    public static void main(String ... args) {
        File initFile;
        String initScriptPath = System.getenv("APPOSE_INIT_SCRIPT");
        if (initScriptPath != null && (initFile = new File(initScriptPath)).exists()) {
            try {
                String initCode = new String(Files.readAllBytes(initFile.toPath()), StandardCharsets.UTF_8);
                Binding binding = new Binding();
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate(initCode);
                initVars.putAll(binding.getVariables());
                initFile.delete();
            }
            catch (Exception e) {
                System.err.println("[WARNING] Init script failed: " + e.getMessage());
            }
        }
        new GroovyWorker().run();
    }

    public class Task {
        public final String uuid;
        public final Map<Object, Object> outputs = new ConcurrentHashMap<Object, Object>();
        public boolean cancelRequested;
        private final String script;
        private final Map<String, Object> inputs;
        private boolean finished;
        private Thread thread;

        public Task(String uuid, String script, Map<String, Object> inputs) {
            this.uuid = uuid;
            this.script = script;
            this.inputs = inputs;
        }

        public void export(Map<String, Object> vars) {
            GroovyWorker.this.exports.putAll(vars);
        }

        public void update(String message) {
            this.update(message, null, null, null);
        }

        public void update(Long current, Long maximum) {
            this.update(null, current, maximum, null);
        }

        public void update(Map<String, Object> info) {
            this.update(null, null, null, info);
        }

        public void update(String message, Long current, Long maximum) {
            this.update(message, current, maximum, null);
        }

        public void update(String message, Long current, Long maximum, Map<String, Object> info) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            if (message != null) {
                args.put("message", message);
            }
            if (current != null) {
                args.put("current", current);
            }
            if (maximum != null) {
                args.put("maximum", maximum);
            }
            if (info != null) {
                args.put("info", info);
            }
            this.respond(Service.ResponseType.UPDATE, args);
        }

        public void cancel() {
            this.respond(Service.ResponseType.CANCELATION, null);
        }

        public void fail(String error) {
            Map<String, Object> args = error == null ? null : Collections.singletonMap("error", error);
            this.respond(Service.ResponseType.FAILURE, args);
        }

        private void run() {
            try {
                Binding binding = new Binding();
                binding.setVariable("task", (Object)this);
                initVars.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
                GroovyWorker.this.exports.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
                this.inputs.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
                this.reportLaunch();
                GroovyShell shell = new GroovyShell(binding);
                Object result = shell.evaluate(this.script);
                if (result instanceof Map) {
                    this.outputs.putAll((Map)result);
                } else if (result != null) {
                    this.outputs.put("result", result);
                }
                this.reportCompletion();
            }
            catch (Exception exc) {
                this.fail(Types.stackTrace(exc));
            }
        }

        private void reportLaunch() {
            this.respond(Service.ResponseType.LAUNCH, null);
        }

        private void reportCompletion() {
            Map<String, Object> args = Collections.singletonMap("outputs", this.outputs);
            this.respond(Service.ResponseType.COMPLETION, args);
        }

        private void respond(Service.ResponseType responseType, Map<String, Object> args) {
            boolean alreadyTerminated = false;
            if (responseType.isTerminal()) {
                if (this.finished) {
                    alreadyTerminated = true;
                }
                this.finished = true;
            }
            HashMap<String, String> response = args == null ? new HashMap<String, String>() : new HashMap<String, Object>(args);
            response.put("task", this.uuid);
            response.put("responseType", responseType.toString());
            try {
                System.out.println(Types.encode(response));
            }
            catch (Exception exc) {
                if (alreadyTerminated) {
                    return;
                }
                this.fail(Types.stackTrace(exc));
            }
            System.out.flush();
        }
    }
}

