/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.apposed.appose.SharedMemory;

abstract class ShmBase<HANDLE>
implements SharedMemory {
    protected final ShmInfo<HANDLE> info;
    private boolean closed;
    private boolean unlinked;

    protected ShmBase(ShmInfo<HANDLE> info) {
        this.info = info;
    }

    protected abstract void doClose();

    protected abstract void doUnlink();

    @Override
    public String name() {
        return this.info.name;
    }

    @Override
    public long rsize() {
        return this.info.rsize;
    }

    @Override
    public long size() {
        return this.info.size;
    }

    @Override
    public ByteBuffer buf(long fromIndex, long toIndex) {
        return this.info.pointer.getByteBuffer(fromIndex, toIndex);
    }

    @Override
    public void unlinkOnClose(boolean unlinkOnClose) {
        this.info.unlinkOnClose = unlinkOnClose;
    }

    @Override
    public synchronized void unlink() {
        if (this.unlinked) {
            throw new IllegalStateException("Shared memory '" + this.info.name + "' is already unlinked.");
        }
        this.doClose();
        this.doUnlink();
        this.unlinked = true;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.doClose();
        if (this.info.unlinkOnClose) {
            this.doUnlink();
        }
        this.closed = true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("name='").append(this.name()).append("', size=").append(this.size());
        if (this.info.pointer != null) {
            sb.append(", pointer=").append(this.info.pointer);
        }
        if (this.info.writePointer != null) {
            sb.append(", writePointer=").append(this.info.writePointer);
        }
        if (this.info.handle != null) {
            sb.append("handle=").append(this.info.handle);
        }
        sb.append(", closed=").append(this.closed);
        sb.append(", unlinked=").append(this.unlinked);
        sb.append("}");
        return sb.toString();
    }

    protected static class ShmInfo<HANDLE> {
        String name;
        long rsize;
        long size;
        Pointer pointer;
        Pointer writePointer;
        HANDLE handle;
        boolean unlinkOnClose;

        protected ShmInfo() {
        }
    }
}

